@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('css/bootstrap-datepicker3.css')}}" rel="stylesheet">
<link href="{{ asset('css/bootstrap-datepicker3.min.css')}}" rel="stylesheet">

@endsection

@section('content')
<div class="login-pannel-box">
  <div class="row out_of_bradcrom">
      
      <div class="col-md-3"></div>
      <div class="col-md-7">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
   
        </div>
  
   <div class="row">
      <div class="col-sm-10 col-md-10 col-md-offset-1 col-lg-7 col-lg-offset-3 mlt-sm">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h1> SignUp</h1>
          </div>
          <div class="panel-body">
        <form class="" name="signup" id="signupForm" action="" method="post">
             <input type="hidden" name="_token" value="{{csrf_token()}}">
          <div class="form">
          @if ($validation_errors && count($validation_errors) > 0)
                <div class="alert alert-danger clearfix">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($validation_errors as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
        <div class="col-sm-12">
            <div class="btn-group form-group" data-toggle="buttons">
                <label class="btn btn-default active">
                    <input type="radio"  name="selected_profile" value="T"  class="selected_profile" checked="checked"/> Talent
                </label> 
                <label class="btn btn-default">
                    <input type="radio"  name="selected_profile" value="O" class="selected_profile"/> Organization
                </label> 
               
            </div>
        </div>
    
            
            <div class="col-sm-12">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Full Name / Business Name" name="name" value="{{ isset($social_data->name) ? $social_data->name:'' }}">
              </div>
            </div>
            
             
               <?php 
                        $gender ="";
                        if(isset($social_data->user))
                        {
                            
                            $gender = $social_data->user;
                        }
                ?>
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="User Name" name="username">
              </div>
            </div>
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="City" name="city">
              </div>
            </div>
            <div class="clearfix"></div>
            <div id="talent_flds">
             <div class="col-sm-6">
               <div class="form-group">
                 <div class="input-group date" > 
                   <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                   <input type="text" class="form-control" value="" name="dob" placeholder="Date of Birth" id="dob" autocomplete="off">
                </div>
               </div>
             </div>
             <div class="col-sm-6">
                 <div class="form-group">
                     <select name="gender" class="form-control" id="gender">   
                       <option value="">Gender</option>
                       <option value="M" {{ ($gender!="" && $gender['gender']=='male') ? 'selected':'' }}>Male</option>
                       <option value="F" {{ ($gender!="" && $gender['gender']=='female') ? 'selected':'' }}>Female</option>
                     </select>
                 </div>
            </div>
           
          </div>
            <div class="clearfix"></div>
            <div class="col-sm-12">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Email Address" name="email" value="{{ isset($social_data->email) ? $social_data->email:'' }}">
              </div>
            </div> 
         
            <div class="col-sm-6">
              <div class="form-group">
                <input type="password" class="form-control" placeholder="Password" name="password" value="">
              </div>
            </div>
            <div class="col-sm-6">
              <div class="form-group">
                 <input type="password" class="form-control" placeholder="Confirm Password" name="password_confirmation" value="">
              </div>
            </div>
             <div class="col-sm-12" id="permission">
              <div class="form-group">
                <input type="checkbox" value="1" name="permission">&nbspDo you have permission from your parents
                </div>
            </div>
            <div class="clearfix"></div>
            <div id="org_flds">
            
             <div class="col-sm-6">
                 <div class="form-group">
                     <select name="years_in_business" class="form-control" id="years_in_business">   
                       <option value="">Years In Business</option>
                       <?php foreach($business_years as $year): ?>
                       <option {{ (isset($funding_data->years_in_business) && $funding_data->years_in_business == $year->id) ? 'selected=selected' : '' }} value="{{$year->id}}">{{$year->years}}</option>
                       <?php endforeach; ?>
                     </select>
                 </div>
            </div>
           
          </div>
         <div class="clearfix"></div>
            
            <div class="xs-login-btns">
              <div class="col-sm-4">
                  <button type="submit" class=" btn mbot-5 pull-right signup-create" name="signup" id="signup_submit" value="signup">Create</button>
              </div>
              <div class="clearfix"></div>
              <div class="col-sm-4 xs-w-50">
               
              <a href="{{Config::get('constants.FACEBOOK_LOGIN_URL')}}" class=" mbot-5 btn btn-fb-login signup-fb"><i class="fa fa-facebook"></i><i class="fa fa-facebook"></i> Login with Facebook </a>
              </div>
              <div class="col-sm-4 xs-w-50">
                <input name="linked_id" type="hidden" value="{{ isset($social_data->linked_id) ? $social_data->linked_id : '' }}" />
                  <input name="fb_id" type="hidden" value="{{ isset($social_data->id) ? $social_data->id : '' }}" />
                  <input name="fb_access_token" type="hidden" value="{{ isset($social_data->token) ? $social_data->token : '' }}" />
  <!--              <button type="submit" class="form-control">Sign Up with Linked In</button>
  -->              <a href="{{Config::get('constants.LINKEDIN_LOGIN_URL')}}" class="btn btn-linkedin-login signup-link"><i class="fa fa-linkedin"></i> Login with Linked In </a>
              </div>
            </div>
            
            <div class="clearfix"></div>

            <div class="sm-login-btns">
              <div class="col-sm-4">
              
              <a href="{{Config::get('constants.FACEBOOK_LOGIN_URL')}}" class="btn btn-fb-login signup-fb"> <i class="fa fa-facebook"></i> Login with Facebook </a>
              </div>
              <div class="col-sm-4">
                <input name="linked_id" type="hidden" value="{{ isset($social_data->linked_id) ? $social_data->linked_id : '' }}" />
                  <input name="fb_id" type="hidden" value="{{ isset($social_data->id) ? $social_data->id : '' }}" />
                  <input name="fb_access_token" type="hidden" value="{{ isset($social_data->token) ? $social_data->token : '' }}" />
  <!--              <button type="submit" class="form-control">Sign Up with Linked In</button>
  -->              <a href="{{Config::get('constants.LINKEDIN_LOGIN_URL')}}" class="btn  btn-linkedin-login signup-link"> <i class="fa fa-linkedin"></i> Login with Linked In </a>
              </div>
              <div class="col-sm-4">
                  <button type="submit" class=" btn pull-right signup-create" name="signup" id="signup_submit" value="signup">Create</button>
              </div>              
            </div>            
              
          </div>
        </form> 
        </div>
        <div class="panel-footer "><div class="col-md-12">By Joining Sanskar, you agree to our Terms of Use and the Privacy Policy.</div><div class="clearfix"></div></div>      
        </div>
      </div>
    </div>
  
</div>
@endsection
@section('js')
<script src="{{asset('js/bootstrap-datepicker.js')}}"></script>
<script src="{{asset('js/bootstrap-datepicker.min.js')}}"></script>
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script type="text/javascript">
    $(function(){

      $("#permission").hide();

    $('#dob').datepicker({
            autoclose: true, 
            format: "mm/dd/yyyy",
            endDate: '+0d',
        }).on('changeDate', function(e) {

                  date =new Date();
                  fomat= (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
                  d1 = new Date($(this).val()); d2 = new Date(fomat);
                  diff_date = (d2 - d1);
                  var years = Math.floor(diff_date/31536000000);
                  var months = Math.floor((diff_date % 31536000000)/2628000000);
                  var days = Math.floor(((diff_date % 31536000000) % 2628000000)/86400000);
                  if(years>18){$("#permission").hide();}
            $('#signupForm').bootstrapValidator('revalidateField', 'dob');
        });
     
       $('.datepicker').css({"font-size": "16px", "width": "20%","padding":"0px 0px 0px 6px"});

        $("#org_flds").hide();
            $("input[name='selected_profile']").change(function(){
              var selected_profile=$('input:radio[name=selected_profile]:checked').val(); 
               if(selected_profile=='O'){$("#talent_flds").hide();$("#org_flds").show(); }
               if(selected_profile=='T'){$("#talent_flds").show();$("#org_flds").hide();}
            });

              $(".signup-create").on('click',function(){
               if($("#dob").val()!="")
               {
                  date =new Date();
                  fomat= (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
                  d1 = new Date($("#dob").val()); d2 = new Date(fomat);
                  diff_date = (d2 - d1);
                  var years = Math.floor(diff_date/31536000000);
                  var months = Math.floor((diff_date % 31536000000)/2628000000);
                  var days = Math.floor(((diff_date % 31536000000) % 2628000000)/86400000);
                  if(years<18 || !$('#permission').attr('checked')){$("#permission").show();}
                  
               }
                 
            });
        });
</script>
@endsection
