@extends('main')
@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')

    <div class="container">
         <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="search">Search</a></li>
              <li class="active">Searched list</li>
            </ol>
            <div class="row">

  <div class="clearfix"></div>
             @if (Session::get('error_msg'))
              <div class="col-md-12">
                <div class="alert alert-danger">
                   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
                    <?php echo Session::get('error_msg') ?>
                </div>
              </div>
            @endif
            @if (Session::get('succ_msg'))
              <div class="col-md-12">
                <div class="alert alert-success">
                   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
                    <?php echo Session::get('succ_msg')?>
                </div>
              </div>  
            @endif
          </div>
 <section class="body-content"> 
             <div class="row">
       @include("left_menu")
         <div class="col-md-9 col-sm-9">
          <div class="border-wraper search-page">
         <h1 class="heading mtop-0 mylikes-head">Saved list</h1>          
          
          <div class="clearfix"></div>
           
         <table id="userstable" class="display responsive nowrap table table-bordered zui-table zui-table-rounded invitation-pg-table">
                  <thead>
                    <tr>
                      <th>Title</th>                     
                      <th>Actions</th>                     
                    </tr>
                    @foreach($results as $row)                                      
                    <tr>
                        <td>{{ucfirst($row['name'])}}</td><td><a href="{{url('searchresult/'.$row['id'])}}" class="btn btn-primary save-search-run-btn">Run</a> &nbsp;<a href="{{url('search?history='.$row['id'])}}" class="btn btn-primary save-search-run-btn">Edit</a>&nbsp;<a href="#" id="deleteresult" data-id="{{$row['id']}}" class="btn btn-primary save-search-del-btn">Delete</a></td>
                    </tr> 
                    @endforeach
                  </thead>
              </table>
            </div>
          </div>
          
        </div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script>
    $('#deleteresult').click( function(){
        var v = $(this).attr("data-id");
        
        bootbox.confirm("Are you sure, you want to Delete Search Result", function(result){   
            if(result){ window.location.href = 'deletesearch/'+v;}
            

        });
       
    });
</script>
@endsection
