@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8 talent_custom_search">
          <h1 class="heading">Search History</h1>
          <div class="row">
            <div class="col-md-12">
              <table id="users-table" class="table table-condensed">
                <thead>
                  <tr>
                    <th>Search Terms</th>
                    <th>Created At</th>
                    <th>Action</th>
                  </tr>
                </thead>
            </table>
            </div>
          </div>          
        </div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script><script>
if($('#users-table').length)
{
  $('#users-table').DataTable({
    processing: true,
    serverSide: true,
    ajax: '/search/ajax_history',
    columns: [
      {data: 'search_terms', name: 'search_terms', width:'60%'},
      {data: 'created_at', name: 'created_at', width:'25%'},
      {data: 'action', name: 'action', width:'15%', orderable: false, searchable: false}
    ],
    "order": [[ 1, "desc" ]]
  });


    $(document).on('click','.search_history',function(){
      history_id = $(this).attr('data-search');
      location.href= '{{url("/search/")}}?history='+history_id;
    });
}
</script>
@endsection
