@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
	 <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/recruit')}}">Recruits</a></li>
              <li class="active">View Recruit Details</li>
            </ol>   
             
            <div class="row">
               <div class="clearfix"></div>
              @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
            </div> 

      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-9">
         <div class="rt-panel-block">  
           <div class="my-profiles-block"> 
          <h1 class="view-recruit-img-head"><?php 
            $default_image = 'default-profile.png';
         if($user_det->profile_image && is_file('uploads/profile_images/'.$user_det->profile_image)){                
                $default_image = $user_det->profile_image;}


          ?><img src="{{url('uploads/profile_images/'.$default_image)}}" class="img-circle invite_pro_pic"><span class="view-reruit-heading">{{ucwords($recruit_details->title)}}</span></h1>
         
         
             
            <div class="col-md-12">
              <div class="panel panel-default ">
                <div class="panel-heading">{{ucwords($user_det->name)}}</div>
                <div class="panel-body">
                     <div class="row talent_data1 mtop-0 recruit-br">
                    <div class="col-sm-12 mbot10">
                      <div class="col-sm-12 mbot10"><h1 class="recruit-job-infodet ">Job Specification Info</h1></div>    
                   
                   
                  <div class="row">
                    <div class="col-sm-4  col-xs-5"> <strong>Purpose :</strong></div>
                    <div class="col-sm-8  col-xs-7"> {{$recruit_details->title}} </div>
                  </div>
                  <div class="row">
                    <div class="col-sm-4 col-xs-5"> <strong>Description :</strong></div>
                    <div class="col-sm-8 col-xs-7"> <?php echo nl2br($recruit_details->msg_content);?></div>
                  </div>
				   </div>
                 </div>
                <div class="row talent_data1 mtop-0 recruit-br">
                 <div class="col-sm-12 mbot10">
                   <div class="col-sm-12 mbot10"><h1 class="recruit-job-infodet">Basic Information</h1></div>    
                 
                    
                @if($job_details->title!="")    
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Title :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->title}} </div>
                </div>
                @endif
                @if($job_details->company_name!="")   
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Company Name :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->company_name}} </div>
                </div>
                @endif
                @if($job_details->link_to_website!="")  
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Link to Website:</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->link_to_website}} </div>
                </div>
                @endif   
                @if($job_details->website_link!="")  
                <div class="row">
                    <div class="col-sm-4 coll-xs-5"><strong>Apply Website Link :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->website_link}} </div>
                </div>
                @endif  
                @if($job_details->industry!="")  
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Industrys :</strong></div>
                    <div class="col-sm-6 col-xs-7"> 
                        <?php $industry = explode(",", $job_details->industry);  ?>
                        @foreach($industry_data as $ind)
                        @if(in_array($ind->id, $industry))
                       {{$ind->name.', '}}
                        @endif
                        @endforeach
                </div>
                </div>
                @endif 
                @if($job_details->function!="")  
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Functions :</strong></div>
                    <div class="col-sm-6 col-xs-7"> <?php  $function = explode(",", $job_details->function);  ?>
                        @foreach($roles_data as $r)
                        @if(in_array($r->id, $function)) {{$r->name.', '}}
                        @endif
                        @endforeach 
                 </div>
                </div>
                @endif 
                 @if($job_details->company_desc!="")
                <?php $company_desc=str_replace("<p>","","$job_details->company_desc");
                      $company_desc=str_replace("</p>","",$company_desc);?>
                 <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Company description :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$company_desc}}
                 </div>
                </div>
                @endif 
                
                @if($job_details->position_desc!="")
                <?php $position_desc=str_replace("<p>","","$job_details->position_desc");
                $position_desc=str_replace("</p>","",$position_desc);?>
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Position description :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$position_desc}}
                 </div>
                </div>
                @endif 
                
               @if($country_name->name!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Country :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$country_name->name}}
                 </div>
                </div>
              @endif 
              
             @if($job_details->province!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Province :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->province}}
                 </div>
                </div>
              @endif 
              
             @if($state_name->name!="")
             <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>State :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$country_name->name}}
                 </div>
                </div>
              @endif 
              
             @if($job_details->city!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>City :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->city}}
                 </div>
                </div>
              @endif 
              </div>
                </div>
            <div class="row talent_data1 mtop-0 recruit-br">
             <div class="col-sm-12 mbot10">
               <div class="col-sm-12 mbot10"><h1 class="recruit-job-infodet">Compensation</h1></div>    

             @if($job_details->sal_range!="" && $job_details->hide_sal==0)
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Base Salary Range :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->sal_range}}
                 </div>
                </div>
              @endif 
              @if($job_details->additional_elements!="")
           <?php $additional_elements=str_replace("<p>","","$job_details->additional_elements");
             $additional_elements=str_replace("</p>","",$additional_elements);?>
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Additional Elements :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$additional_elements}}
                 </div>
                </div>
              @endif 
                        </div>
            </div>
              
              <div class="row talent_data1 mtop-0 recruit-br">
             <div class="col-sm-12 mbot10">
               <div class="col-sm-12 mbot10"><h1 class="recruit-job-infodet">Preferred Candidate</h1></div>    
            
               @if($job_details->skill_level!="")
            <?php  $array = explode(",", $job_details->skill_level);?>  
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Likely Skill Level :</strong></div>
                    <div class="col-sm-6 col-xs-7"> @for($i = 0; $i < count($array); $i++){{ $array[$i].', ' }}@endfor
                 </div>
                </div>
              @endif 
              
          @if($job_details->jobtype!="")
               <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Job Type :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->jobtype}}
                 </div>
                </div>
              @endif 
              
         @if($job_details->experience!="")
          <?php $experience=str_replace("<p>","","$job_details->experience");
          $experience=str_replace("</p>","",$experience);?>
               <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Experience :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{ $experience }}
                 </div>
                </div>
              @endif 
           
              @if($job_details->qualification!="")
          <?php $qualification=str_replace("<p>","","$job_details->qualification");
          $qualification=str_replace("</p>","",$qualification);?>
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Qualification :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{ $qualification }}
                 </div>
                </div>
              @endif 
              </div>
            </div> 
            <div class="row talent_data1 mtop-0 recruit-br no-recruit-br">
             <div class="col-sm-12 mbot10">
               <div class="col-sm-12 mbot10"><h1 class="recruit-job-infodet">Contact Info</h1></div>    
             
              @if($job_details->anonymous!="")
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Keep anonymous :</strong></div>
                    <div class="col-sm-6 col-xs-7"> @if($job_details->anonymous==0){{'No'}}@else{{'Yes'}}@endif
                 </div>
                </div>
              @endif 
              
              @if($job_details->username!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Name :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->username}}
                 </div>
                </div>
              @endif 
              
               @if($job_details->email!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Email :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->email}}
                 </div>
                </div>
              @endif 
              @if($job_details->apply!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Apply to :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->apply}}
                 </div>
                </div>
              @endif 
               @if($job_details->contact_company!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Company Name :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->contact_company}}
                 </div>
                </div>
              @endif 
               @if($job_details->street!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Street :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->street}}
                 </div>
                </div>
              @endif 
               @if($job_details->contact_city!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>City :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->contact_city}}
                 </div>
                </div>
              @endif
                @if($job_details->contact_state!="")
                <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>State :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$contact_state->name}}
                 </div>
                </div>
              @endif
               @if($job_details->contact_country!="")
               <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Country :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$contact_country->name}}
                 </div>
                </div>
              @endif
              @if($job_details->contact_province!="")
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Province :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->contact_province}}
                 </div>
                </div>
              @endif 
              @if($job_details->phone!="")
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Phone Number :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->phone}}
                 </div>
                </div>
              @endif 
            
              @if($job_details->fax!="")
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Fax Number :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->fax}}
                 </div>
                </div>
              @endif 
               @if($job_details->comment!="")
              <div class="row">
                    <div class="col-sm-4 col-xs-5"><strong>Comment :</strong></div>
                    <div class="col-sm-6 col-xs-7"> {{$job_details->comment}}
                 </div>
                </div>
              @endif 
              </div>
            </div>
                  <div class="clearfix"></div>
                  <div class="pull-right"><?php echo date('h:i a  M d, Y',strtotime($recruit_details->updated_at));?></div>
                </div>
              </div>
            </div>
         </div>
		 <div class="clearfix"></div>
		 </div>
          </div>  
          <p>&nbsp;</p> 
        </div>

  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/invitations_js.js')}}"></script>
@endsection
