@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li class="active">My Videos</li>
            </ol>
             @if (Session::get('error_msg') || Session::get('succ_msg'))
        <div class="row">
          <div class="col-md-12">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
        </div>
        @endif
      <div class="row talent_home">
        
        @include("left_menu")
        <!--<div class="col-md-9 col-sm-8"> <a href="#" class="btn btn-default">My Videos . . .</a>-->
        <div class="col-md-9 col-sm-9"> 
           
            
           <div class="imagebanner-block">
           <img src="images/my-videos-bg.png" class="img-responsive" alt="banner">
          <h1 class="banner-txt">My Videos</h1>
               </div>
       
        <div class="row ">
            <div class="col-sm-12 mbot10">
             <h1 class="mypics-head">Search Videos </h1>
             <div class="picture-search-input">
                <input type="text" name="search" placeholder="Search Videos based on Title"  id="auto_search" value="" class="form-control">
              </div>    
            </div>
            <div class="col-sm-12">
              <div class="mbot10"><h1 class="mypics-head">Post Videos</h1></div>
              
                  <form class="" name="" action="" id="talent_vid_from" method="post" enctype="multipart/form-data">
                      <div class="form-group col-sm-4 picture-search-input">
                          <input type="text" name="name" placeholder="Video Title" value="" class="form-control">
                      </div>    
                      <div class="form-group col-sm-4 picture-search-input ">
                          <input type="file" name="image" class="form-control" value="">
                      </div>
                      <input type="hidden" name="_token" value="{{csrf_token()}}">
                     <div class="col-sm-4 btn-no-pad">
                      <button type="submit" name="upload" value="push" class="btn pic-upload-btn">Upload Video</button>
            </div>
                  </form>
               
            </div>  
        </div>    
          <div class="row my-pics-block" id="videos_div">
            @if(count($data)>0)
              @foreach($data as $video)
            
                  <div class="col-sm-6 col-md-6 col-lg-4 mbot10 vidlen">
                     <div class="row mypic-view-block">  
                      <div class="col-sm-12">
                      <?php 

                        if($video->processed == '0')
                        {
                      ?>
                      <img src="/uploads/processing.jpg" class="img-responsive vid-img234" view-id="{{$video->id}}">
                      <?php
                        }else{
                      ?>
                      <img src="{{$video->thumb_img}}" iframe-src ="https://player.vimeo.com/video/{{$video->path}}" view-id="{{$video->id}}" class="img-responsive popup vid-img234">
                      <!---->
                      <?php 
                        }
                      ?>
                      </div>
                       <div class="mypics-botm-links"> 
                      <div class="col-md-8 col-xs-6">
                        <h4 class="heading_min_height" title="{{$video->name}}">{{ str_limit($video->name, $limit = 15, $end = '.....') }}</h4>
                      </div>
                      <div class="col-md-4 col-xs-6 mtop10 my-pics-action-icons">
                         <div class="user-upload-action-icons">
                        @if($video->access=='PUB')
            
                        <span class="lock-icon">
                          <a href="javascript:;" class="share_btn" data-id="{{$video->id}}" data-url="{{$video->thumb_img}}" title="Share"><i class="fa fa-share-alt"></i></a>
                        </span>                        
                        <span class="lock-icon">
                          <a href="{{url('videos/'.$video->id.'?access=lock')}}" title="Unlock"><i class="fa fa-unlock"></i></a>
                        </span>
                        @else
                        <span class="lock-icon">
                          <a href="{{url('videos/'.$video->id.'?access=unlock')}}" title="Lock"><i class="fa fa-lock"></i></a>
                        </span>  
                        @endif
            
                        <span class="delete-icon">
                          <a href="javascript:void(0)" title="Delete" class="delete_video" data-id="{{$video->id}}"><i class="fa fa-trash-o"></i></a>
                        </span>
                      </div>
                      </div></div>
                  </div></div>
                  
            @endforeach  
            @else
              <div class="col-sm-4">
                                 <h4>No Videos Found</h4>
             </div>
            @endif
           
          </div>
            <div id="LoadingImage" style="display: none;">
               <img class="img-responsive" src="images/spin.gif" width="120" height="120" alt=""/>
            </div>
            <input type="hidden" name="numrows" value="{{$numrows}}">
            <div class="col-sm-4 col-md-offset-4">
             <button  class="btn mypics-more-btn" id="video_next">More</button>    
            </div>
        </div>
      </div>
    </div>
  </section>


<!-- Modal -->
<div class="modal fade" id="popup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog">
    <div class="modal-content">
         <iframe src="" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen width="600" height="400" id="modal-iframe"></iframe>
      <div class="modal-footer video-model-foot">
        <button type="button" class="btn-close btn delete-btn clear_form pull-right" id="modal-close" >Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Profile  Video Modal -->
<div id="share_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog">
    <div class="modal-content">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title">Share Video</h4>
    </div>
    <div class="modal-body">
      <form class="form-horizontal" method="post" id="shareForm" name="shareForm" action="{{url('share/share_asset')}}">
          <input type="hidden" name="_token" value="{{ csrf_token() }}">
          <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
          <input type="hidden" name="assets_id" value="" class="assets_id_elem">
          <input type="hidden" name="asset_type" value="video">
          <div class="form-group">
            <label class="col-sm-1 share_label" >To<span class="reqired-val">*</span></label>
            <div class="col-sm-11">
                <!--<input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">-->
                <select name="to[]" id="to" class="form-control" multiple="multiple" placeholder="Ex: Username">
                  
                </select>
            </div>
          </div>
          <div class="form-group">
            <div class="col-sm-12 text-center"><img src="" class="img-elem"></div>
          </div>
          <div class="form-group">
              <div class="col-md-12">
                  <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                  <button type="submit" value="Submit" class="btn-close btn delete-btn clear_form pull-left">Share</button>
              </div>
          </div>
      </form>          
    </div><!-- End of Modal body -->
    </div><!-- End of Modal content -->
    </div><!-- End of Modal dialog -->
</div><!-- End of Profile Image Modal --> 

@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script type="text/javascript">

$(document).ready(function(){
   /* $('.popup').click(function(){
       $('#modal-iframe').attr('src',$(this).attr('iframe-src'))
       $('#popup').modal('show');
    });*/
 
 $(document).on('click','.popup',function(){
      var atr_val=$(this).attr('view-id');
      var dataString = 'atr_val='+ atr_val +  '&_token=' + $("input[name=_token]").val();
       // alert(dataString);
                       $.ajax({
                              type: "POST",
                              url : "video_view",
                              data : dataString,
                              success : function(data){ }
                          },"json");
                          
                          $('#modal-iframe').attr('src',$(this).attr('iframe-src'));
                          $('#popup').modal('show'); 
                          
       
 });

    $("#modal-close").click(function(){
        $('#modal-iframe').attr('src',"");
        $('#popup').modal('hide');
    })
@if($numrows<=$maxlimit)
$('#video_next').hide();    
@endif    
  /*var numvideos=$("input[name=numrows]").val();
  if(numvideos<={{$maxlimit}}){$('#video_next').css("display", "none");}*/
 var ajax_request;

  function load_more()
  {
    if(ajax_request != null) ajax_request.abort(); //cancel previous request      
   
       $("#LoadingImage").show();
       var current_prof_id = {{Session::get('auth_selected_profile')}};
       var findsiz= $(".vidlen").length;
//       var divsiz=findsiz+{{$maxlimit}};
       var divsiz={{$maxlimit}};
       var numrow=$("input[name=numrows]").val();
       var sea_key = $('#auto_search').val();
       if(numrow<=divsiz){$('#video_next').css("display", "none");}
       var url = "{{url('vidoes_loadmore')}}?take="+divsiz+"&skip="+findsiz+"&sea_key="+sea_key;
       /*if(sea_key)
           $('#auto_search').attr('readonly','readonly');*/
          ajax_request = $.ajax({
                    type: "get",
                    url : url,
                    dataType: "json",
                    success : function(data){
                        ajax_request = null;
                      append_data = '';
                     // likes_data = data['likes'];
                      //var arr = Object.keys(data['likes']).map(function(k) { alert(obj[k]) });
                      var obj = data['likes'];
                        var arr = [];
                        for (elem in obj) {
                           arr.push(obj[elem]);
                        }
                      $.each(data['values'],function(i,v){
                        icon = '';icon_url='';permission='';
                        video_img='';popup='';iframe_src='';vid_likes='';
                          vid_title='';
                        if(current_prof_id==v.profile_id)
                        {
                            share = '<div class="user-upload-action-icons">';
                            if(v.access=='PUB')
                            {
                              icon = 'fa-unlock';
                              icon_url = "{{url('videos')}}/"+v.id+"?access=lock";
                              icon_title = 'Unlock';

                              share =  '<span class="lock-icon">';
                              share += '<a href="javascript:;" class="share_btn" data-id="'+v.id+'" data-url="'+v.thumb_img+'" title="Share"><i class="fa fa-share-alt"></i></a>';
                              share += '</span>';
                            }
                            else
                            {
                             icon = 'fa-lock'; icon_url = "{{url('videos')}}/"+v.id+"?access=unlock";
                             icon_title = 'Lock';
                            }
                            permission =  share + '<span class="lock-icon"><a href="'+icon_url+'" title="'+icon_title+'"><i class="fa '+icon+'"></i></a></span> <span class="delete-icon"><a href="javascript:void(0)" title="Delete" class="delete_video" data-id="'+v.id+'"><i class="fa fa-trash-o"></i></a></span></div>';
                        }   
                        else
                        { 
                          
                           
                            vid_likes='<div class="update_likes'+v.id+'">';
                            if($.inArray(v.id,arr)!=-1)
                            {
                            vid_likes=vid_likes+'<a href="javascript:void(0)" class="updt_pro like'+v.id+' unlike_col" data-id="'+v.id+'"><span class="glyphicon glyphicon-thumbs-down"></span> (Unlike)</a>';
                             }                        
                           else
                             {
                             vid_likes=vid_likes+'<a href="javascript:void(0)" class="updt_pro unlike'+v.id+'" data-id="'+v.id+'" ><span class="glyphicon glyphicon-thumbs-up"></span> (Like)</a>';
                              }
                            vid_likes=vid_likes+'</div>';
                        }
                        if(v.processed==0)
                        {
                          video_img = '/uploads/processing.jpg';
                        }
                        else
                        {
                          iframe_src ='iframe-src ="https://player.vimeo.com/video/'+v.path+'"';
                          popup = 'popup';
                          video_img = v.thumb_img;
                        }
                            len=v.name.length;
                           var vid_title=v.name;
                            if(len>15)
                            {
                              v.name=v.name.substr(0,15)+'...';
                            }
                                             append_data = append_data+'<div class="col-sm-6 col-md-6 col-lg-4 mbot10 vidlen"><div class="row mypic-view-block"><div class="col-sm-12"><img src="'+video_img+'" '+iframe_src+' class="img-responsive '+popup+' vid-img234" view-id="'+v.id+'"></div><div class="mypics-botm-links"><div class="col-sm-8 col-xs-6"><h4 title="'+vid_title+'" class="heading_min_height">'+v.name+'</h4></div><div class="col-sm-4 col-xs-6 my-pics-action-icons">'+permission+vid_likes+' </div></div></div></div>';
                      });   
                     if(append_data) append_data=append_data+'<div class="clearfix"></div>';
                    /*if(sea_key)
                        $('#auto_search').removeAttr('readonly');*/

                      if(!$(".vidlen").length)$('#videos_div').html('');
                      $('#videos_div').append(append_data);
                      if(! append_data)$('#videos_div').html('No Records Found');
/*                      if(numrow>$(".vidlen").length){$('#video_next').show();}else{$('#video_next').hide();}
                      $("#LoadingImage").hide();*/
                      if(parseInt(data['count'])>$(".vidlen").length){$('#video_next').show();}else{$('#video_next').hide();}
                      $("#LoadingImage").hide();
                      
                    }
                },"json");

  }
  $('#video_next').click(function(){
    load_more();
  });
  $(document).on('click','.delete_video',function(){
    var video_id = $(this).attr("data-id");
    bootbox.confirm("Are you sure, you want to delete video?", function(result) {
      if(result)
      location.href = '{{url("videos_delete/")}}/'+video_id;
    });  
  });

  $("#auto_search").keyup(function(){
    $("#LoadingImage").show();
    var curval=$(this).val();

      if(curval=='')
      {
        $('#videos_div').html('<a href="javascript:void(0)"><i class="fa fa-circle-o-notch fa-spin"></i> loading results</a>');
        load_more();
      }
      else
      {
          $('#videos_div').html('');
          $( document ).ajaxStop(function() {
          });  
          load_more();
    /* $('#video_next').css("display", "none");
        var dataString = 'searchdata='+ curval +  '&_token=' + $("input[name=_token]").val();
        $.ajax({
            type: "get",
            url : "/videosearch",
            data : dataString,
            success : function(data){
               $("#LoadingImage").hide();
               $('#videos_div').html(data);
            }
        },"json");*/
      }  
  });

});

//for mylikes script
     $(document).on('click','.updt_pro',function(){
    var data_id = $(this).attr("data-id");//alert(data_id);
     // location.href = '{{url("pictures/likes")}}/'+data_id;
      $("#LoadingImage").show();
      //for mylikes ajax
 var dataString = 'like_id='+ data_id +  '&_token=' + $("input[name=_token]").val();
  $.ajax({
                    type: "POST",
                    url : "/videos/likes",
                    data : dataString,
                    success : function(data){
                       $("#LoadingImage").hide();
                      var Unlike='<a href="javascript:void(0)" class="updt_pro like'+data_id+' unlike_col" data-id="'+data_id+'" ><span class="glyphicon glyphicon-thumbs-down"></span> (Unlike)</a>';
                      var Like='<a href="javascript:void(0)" class="updt_pro unlike'+data_id+'" data-id="'+data_id+'" ><span class="glyphicon glyphicon-thumbs-up"></span> (Like)</a>';
                       if(data=='Like'){ $('.like'+data_id).replaceWith(Like);}
                       if(data=='Unlike'){ $('.unlike'+data_id).replaceWith(Unlike);}}
                },"json");
   
  });

// Share js code
$(document).ready(function(){

  if($('.share_btn').length)
  {
    $(document).on('click','.share_btn',function(){
      $('#share_modal').modal('show');
      $('#share_modal .img-elem').attr('src', $(this).attr('data-url'));
      $('#share_modal .assets_id_elem').val($(this).attr('data-id'));
    });
  }

    $("#to").select2({
      ajax: {
        url: "/invitation_typeahead",
        dataType: 'json',
        delay: 250,
        data: function (params) {
          return {
            user_name: params.term, // search term
          };
        },
        processResults: function (data) {
          //alert('hi');
          // parse the results into the format expected by Select2.
          // since we are using custom formatting functions we do not need to
          // alter the remote JSON data
          var results = [];
         // console.log(data);
          $.each(data, function(index, item){
            results.push({
              id: item.id,
              text: item.value
            });
          });
          return {
              results: results
          };
        },
        cache: true
      },
      escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
      //minimumInputLength: 1,
      maximumSelectionLength: 5
      //templateResult: formatRepo, // omitted for brevity, see the source of this page
      //templateSelection: formatRepoSelection // omitted for brevity, see the source of this page
    });  
})
</script>
@endsection
