@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/jcrop/css/jquery.Jcrop.css')}}" rel="stylesheet">
<link href="{{ asset('/css/jquery.fileupload.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrap-select.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content talent-profile-edit-page">
    <div class="container">
	<ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
             @if(empty(Auth::user()->id))<li class="active"><a href="javascript:history.go(-1)">Profile List</a></li>@endif
             <li class="active">Talent Profile</li>
            </ol>
			    @if ($error_msg)
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{$error_msg}}
              </div>
          @endif
          @if ($succ_msg)
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{$succ_msg}}
              </div>
          @endif
		  <div class="clearfix"></div>
      <div class="row talent_profile">
         
      
        @if($prof_det->private || strpos($prof_det->private_permission,'B,')===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
        @if(isset(Auth::user()->id) && Auth::user()->id==$prof_det->user_id)<input type="hidden" value="{{$prof_det->user_id}}" id="find_auth">@endif
        <div class="col-sm-5">
          <!--<h1 class="heading">Talent Profile</h1>-->
          <ul class="pro_head">
            <li class="porfile_title">
              <div class="row">
                <div class="profile_display_data main_pro"> 
                  <div class="col-sm-8 col-md-9 col-xs-8">
                    <span>{{ucwords($prof_det->name)}}</span>
                 
                  </div>
                  @if($prof_det->private)
                  <div class="col-sm-4 col-md-3 col-xs-4">
                    <a href="javascript:void(0)" class="profile_show pull-right">
                      @if(ucwords($prof_det->name))
                        <i class="fa fa-pencil" title="Edit"></i><span>Edit</span>
                      @else
                        <i class="fa fa-plus" title="Add"></i><span>Add</span>
                      @endif 
                    </a>
                  </div>
                  @endif
                  <div class="clearfix"></div>
               </div> 
             </div>   
             <div class="profile_edit_data ">
              <form method="post" id="nameForm" name="nameForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="name">
                  <div class="form-group">
                    <input type="text" class="form-control" name="name" id="name" value="{{ucwords($prof_det->name)}}">
                  </div>
                
                   <div class="talent_profile-btn-grp"> 
                      <button type="submit" name="submit_name" id="submit_name" value="name" class="btn btn-default">Save</button> 
                      <button type="button" class="profile_close_open btn btn-default">Cancel</button>
                    </div> 
                                  
              </form>
             </div>
             <div class="clearfix"></div>
            </li>
<!--            <li><a href="{{url('profile/step2/'.$prof_det->id)}}"><i class="fa fa-tags"></i><span>{{$categories}}</span></a></li>-->
            <li>
              <div class="row">
                <div class="col-sm-8 col-md-9 col-xs-8 ">
                  <i class="fa fa-tags"></i><span>{{$categories}}</span>
                </div>
                @if($prof_det->private)
                <div class="col-sm-4 col-xs-4 col-md-3">
                  <a href="{{url('profile/step2/'.$prof_det->id)}}" class="pull-right"><i class="fa fa-pencil" title="Edit"></i><span>Edit</span></a>
                </div>
                @endif
              </div>
            </li>
            <li>
              <div class="row">
               <div class="profile_display_data main_pro"> 
                <div class="col-sm-8 col-md-9 col-xs-8">
                  <i class="fa fa-map-marker"></i> <span>@if($prof_det->city){{$prof_det->city}}@else Add City @endif</span>
                </div>
                @if($prof_det->private)
                  <div class="col-sm-4 col-xs-4 col-md-3">
                    <a href="javascript:void(0)" class="profile_show pull-right">
                      @if(ucwords($prof_det->city))
                        <i class="fa fa-pencil" title="Edit"></i><span>Edit</span>
                      @else
                        <i class="fa fa-plus" title="Add"></i><span>Add</span>
                      @endif 
                    </a>
                  </div>
                @endif 
               </div> 
                <div class="clearfix"></div>
             </div> 
             <div class="profile_edit_data">
              <form method="post" id="cityForm" name="cityForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="city">
                  <div class="form-group">
                    <input type="text" class="form-control" name="city" id="city" value="{{ucwords($prof_det->city)}}">
                  </div>
                   <div class="talent_profile-btn-grp"> 
                      <button type="submit" name="submit_city" id="submit_city" value="city" class="btn btn-default">Save</button> 
                      <button type="button" class="profile_close_open btn btn-default">Cancel</button>
                  </div>                   
              </form>
             </div>
             <div class="clearfix"></div>
            </li>
            <li>
              <div class="row">
               <div class="profile_display_data main_pro"> 
                <div class="col-sm-8 col-md-9 col-xs-8">
                  <i class="fa fa-link"></i> <span>@if($prof_det->url){{$prof_det->url}}@else Add URL @endif</span>
                </div>
                @if($prof_det->private)
                  <div class="col-sm-4 col-xs-4 col-md-3">
                    <a href="javascript:void(0)" class="profile_show pull-right">
                      @if(ucwords($prof_det->url))
                        <i class="fa fa-pencil" title="Edit"></i><span>Edit</span>
                      @else
                        <i class="fa fa-plus" title="Add"></i><span>Add</span>
                      @endif 
                    </a>
                  </div>
                 @endif 
               </div> 
                <div class="clearfix"></div>
             </div> 
             <div class="profile_edit_data">
              <form method="post" id="urlForm" name="urlForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="url">
                  <div class="form-group">
                    <input type="text" class="form-control" name="url" id="url" placeholder="http://example.com/" value="{{ucwords($prof_det->url)}}">
                  </div>
                  <div class="talent_profile-btn-grp"> 
                      <button type="submit" name="submit_url" id="submit_url" value="url" class="btn btn-default">Save</button> 
                      <button type="button" class="profile_close_open btn btn-default">Cancel</button>
                    </div> 
                               
              </form>
             </div>
             <div class="clearfix"></div>
            </li> 
<!--            <li><a href="javascript:void(0)"><i class="fa fa-link"></i><span>URL</span></a></li>
            <li><a href="javascript:void(0)"><i class="fa fa-paperclip"></i><span>Add links to other websites</span></a></li>-->
            @if($prof_det->private)
            <li>
              <div class="row">
                <div class="col-sm-8 col-md-9 col-xs-8">
                  <i class="fa fa-paperclip"></i>
                  {{--*/ $link_type = array('f'=>'facebook','l'=>'linkedin','t'=>'twitter','p'=>'pinterest','g'=>'google-plus') /*--}}
                  @if($profile_links)
                  <?php  $i = 1 ?>
                    @foreach($profile_links as $key=>$value)
                      @if($value)
                        @if(strpos($value,"http")===0)
                        {{--*/ $u='';/*--}}
                        @else 
                          {{--*/ $u='//';/*--}}
                        @endif
                        <a href="{{$u.$value}}" target="_blank"><i class="fa fa-{{$link_type[$key]}}"></i></a>
                      @else
                      @if($i==1) <span>Add links to other websites</span>@endif
                      @endif
                  <?php $i++?>
                    @endforeach
                  @else
                  <span>Add links to other websites</span>
                  @endif
                </div>
                @if($prof_det->private)
                  <div class="col-sm-4 col-xs-4 col-md-3">
                    <a href="javascript:void(0)" class="pull-right social_links">
                     @if($profile_links) 
                      <i class="fa fa-pencil" title="Edit"></i><span>Edit</span>
                     @else 
                      <i class="fa fa-plus" title="Add"></i><span>Add</span>
                     @endif
                    </a>
                  </div>
                @endif  
              </div>
            </li>
            @endif
          </ul>
        </div>
        @if($prof_det->private)
          <div class="col-sm-1">
            @if(strpos($prof_det->private_permission,'B,') === false)
              <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=B')}}" class="lock_unlock_2"><i class="fa fa-unlock"></i></a>
            @else
             <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=B')}}" class="lock_unlock_2"><i class="fa fa-lock"></i></a>
            @endif
          </div>
        @endif
        <div class="col-md-4 col-sm-5 pull-right talent_profile-avatar">
            @if($prof_det->profile_image && is_file('uploads/profile_images/'.$prof_det->profile_image))
              <img class="pro_pic img-responsive" src="{{url('uploads/profile_images/'.$prof_det->profile_image)}}" alt=""/>
            @else                    
              <img class="pro_pic img-responsive" src="{{url('uploads/profile_images/default-profile.png')}}" alt=""/>
            @endif
			
           <!--<img class="pro_pic img-responsive" data-src="holder.js/100%x180" src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iMjQyIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDI0MiAyMDAiIHByZXNlcnZlQXNwZWN0UmF0aW89Im5vbmUiPjxkZWZzLz48cmVjdCB3aWR0aD0iMjQyIiBoZWlnaHQ9IjIwMCIgZmlsbD0iI0VFRUVFRSIvPjxnPjx0ZXh0IHg9IjkxLjUiIHk9IjEwMCIgc3R5bGU9ImZpbGw6I0FBQUFBQTtmb250LXdlaWdodDpib2xkO2ZvbnQtZmFtaWx5OkFyaWFsLCBIZWx2ZXRpY2EsIE9wZW4gU2Fucywgc2Fucy1zZXJpZiwgbW9ub3NwYWNlO2ZvbnQtc2l6ZToxMXB0O2RvbWluYW50LWJhc2VsaW5lOmNlbnRyYWwiPjI0MngyMDA8L3RleHQ+PC9nPjwvc3ZnPg==" data-holder-rendered="true">-->
          <p>
          @if($prof_det->private)
          <button type="button" class="btn btn-success" id="changeprofilepic">Upload / Update Profile Image</button>
          <!--<input id="changeprofilepic" type="file" name="files">-->
          @endif
          </p>
        </div>
        @else
          <div class="col-md-5">
            <ul class="pro_head">
              <li class="porfile_title">
                <div class="row">
                  <div class="profile_display_data"> 
                    <div class="col-sm-9">
                      <span>{{ucwords($prof_det->name)}}</span>
                    </div>
                  </div>
                </div>
              </li>
            </ul>    
          </div>
          <div class="clearfix"></div>
          <br>  
        @endif
        <div class="clearfix"></div>
        <div class="col-md-12">
            <div class="panel panel-default">
              <div class="panel-body">
                <ul class="status">
                  <li><a href="javascript:void(0)">0 Friends</a></li>
                  <li><a href="javascript:void(0)">0 Followers</a></li>
                  <li><a href="javascript:void(0)">0 Following</a></li>
                </ul>
              </div>
            </div>
            <div class="profile_edit">
              @if($prof_det->private || strpos($prof_det->private_permission,'S,') ===false  || (isset($prof_det->full_profile) && $prof_det->full_profile))
                <form method="post" id="skillForm" name="skillForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="skill">
                  <div class="panel panel-default">
                    <div class="panel-body row">
                      <div class="col-sm-4 col-xs-7">
                        <h3 class="pull-left">Skills <span class="profile-loc-icon"> @if($prof_det->private)
                              @if(strpos($prof_det->private_permission,'S,') === false)
                                <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=S')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                              @else
                                <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=S')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                              @endif
                        @endif   </span></h3>
                                            
                      </div>
                    @if($prof_det->private)
                      <div class="col-sm-8 col-xs-5">
                        <div class="talent_show" href="javascript:void(0)"> 
                          @if($prof_det->skills)
                            <i class="fa fa-pencil"></i><span>Edit</span>
                          @else
                            <span class="prof_plus-icon"><i class="fa fa-plus"></i></span><span>You can detail your skillset here</span>
                          @endif
                        </div>
                      </div>
                    @endif
                      <div class="clearfix"></div>
                      <div class="profile_display_data">
                        <div class="col-sm-12">
                          {{$prof_det->skills}}
                        </div>
                      </div>
                      <div class="profile_edit_data">
                          <div class="col-sm-8">
                            <textarea name="skills" id="skills" limit="255" rows="4" class="form-control" placeholder="Describe your skills...">{{$prof_det->skills}}</textarea>
                          </div>
                          <div class="col-sm-4">
                          <div class="talent-profile-edit-btn-grp">
                            <button type="submit" name="submit_skill" id="submit_skill" value="skill" class="btn talent_close">Save</button>
                            <button type="button" class="btn talent_close_open">Cancel</button>
                            </div>
                          </div>
                      </div>
                    </div>
                  </div>
                </form>
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'EXP,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="experienceForm" name="experienceForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="experience">

                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Experience <span class="profile-loc-icon">@if($prof_det->private)
                          @if(strpos($prof_det->private_permission,'EXP,') === false)
                            <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=EXP')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                          @else
                            <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=EXP')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                          @endif
                        @endif    </span></h3>
                        
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show add_experience" href="javascript:void(0)"> <span class="prof_plus-icon"><i class="fa fa-plus"></i></span><span>You can add your experience here</span></div>
                    </div>
                  @endif  
                    <div class="clearfix"></div>
                    <div class="profile_display_data"> 
                      @foreach($profile_exp as $exp)
                        <div class="col-sm-12 alert-warning">
                          <div>
                            <ul>
                              <li>@if($exp['from_date'] && $exp['to_date']!='-')
                              {{$exp['from_date']}} to {{$exp['to_date']}}
                             @else
                              {{$exp['from_date']}} to Till Date
                             @endif</li>
                              <li>{{$exp['exp_company']}}</li>                              
                              <li>{{$exp['exp_description']}}</li>
                              <li>{{$exp['exp_location']}}</li>
                              <li>{{$exp['exp_partners']}}</li>
                            </ul>
                        @if($prof_det->private)
                            <div class="edit_btns">
                             <button type="button" class='pull-right btn btn-primary delete' data-parent="{{$prof_det->id}}" data-type="exp" data-value="{{$exp['id']}}">Delete</button>&nbsp; &nbsp;
                             <button type="button" class='pull-right btn btn-primary exp_edit' data-parent="{{$prof_det->id}}" data-type="exp" data-id="{{$exp['id']}}">Edit</button>
                            </div>
                        @endif      
                          </div>
                        </div>
                      @endforeach
                    </div>
                    <div class="profile_edit_data">
                      <div class="col-sm-8">
                        <ul>
                          <li><span>From</span>
                            <div class="form-group">
                              <select class="form-control" name="exp_from_yy" id="exp_from_yy">
                                <option value="">Year</option>
                                <?php
                                  for($y=date('Y'); $y>=date('Y')-90; --$y):
                                    echo '<option>'.$y.'</option>';
                                  endfor;
                                ?>
                              </select>
							  <select class="form-control" name="exp_from_mm" id="exp_from_mm">
                                <option value="">Month</option>
                                <?php
                                for($m=1; $m<=12; ++$m):
                                   $m_name = date('F', mktime(0, 0, 0, $m, 1)); 
                                  if($m>9) $n=$m; else $n="0".$m;
                                  echo '<option value="'.$n.'">'.$m_name.'</option>';
                                endfor;
                                ?>
                              </select>
                            </div>
                               <div class="clearfix"></div>
                          </li>
                          <li>
                            <span class="to-lable">To</span>
                            <div class="form-group">
                              <select class="form-control" name="exp_to_yy" id="exp_to_yy">
                                <option value="">Year</option>
                                <?php
//                                  for($y=date('Y'); $y>=date('Y')-90; --$y):
//                                    echo '<option>'.$y.'</option>';
//                                  endfor;
                                ?>
                              </select>
							  <select class="form-control" name="exp_to_mm" id="exp_to_mm">
                                  
                                <option value="">Month</option>
                                <?php
//                                for($m=1; $m<=12; ++$m):
//                                   $m_name = date('F', mktime(0, 0, 0, $m, 1)); 
//                                  if($m>9) $n=$m; else $n="0".$m;
//                                  echo '<option value="'.$n.'">'.$m_name.'</option>';
//                                endfor;
                                ?>
                              </select>
                              
                                <input type="checkbox" value="1" name="exp_tilldate" id="exp_tilldate" <?php if(isset($exp['from_date']) && $exp['to_date']=='-'){echo "checked='checked'";}?>>&nbsp;I currently work here
                            </div>
                             <div class="clearfix"></div>
                          </li>
                          <li>
                            <div class="form-group">
                             <input class="form-control" type="text" placeholder="Location" name="exp_location" id="exp_location">
                            </div>
                          </li>
                          <li>
                            <div class="form-group">
                            <input class="form-control" type="text" placeholder="Name of company/project/collective..." name="exp_company" id="exp_company">
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <textarea limit="255" rows="2" class="form-control" placeholder="Description" name="exp_description" id="exp_description"></textarea>
                          </div>
                          </li>
                        <!--  <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Partners (among your friends)" name="exp_partners" id="exp_partners">
                          </div>
                          </li>-->
                        </ul>
                      </div>
                      <div class="col-sm-4">
                      <div class="talent-profile-edit-btn-grp">
                        <button type="submit" name="submit_experience" id="submit_experience" value="experience" class="btn talent_close">Save</button>
                        <button type="button" class="btn talent_close_open">Cancel</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
               </form> 
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'EDU,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="educationForm" name="educationForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="education">
                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Education <span class="profile-loc-icon">@if($prof_det->private)
                        @if(strpos($prof_det->private_permission,'EDU,') === false)
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=EDU')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                        @else
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=EDU')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                        @endif
                      @endif   </span></h3>
                      
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show add_education" href="javascript:void(0)"> <span class="prof_plus-icon"><i class="fa fa-plus"></i></span><span>You can add your education here</span></div>
                    </div>
                  @endif    
                    <div class="clearfix"></div>
                    <div class="profile_display_data"> 
                      @foreach($profile_edu as $edu)
                        <div class="col-sm-12 alert-warning">
                          <div>
                            <ul>
                              <li>@if($edu['from_date'] && $edu['to_date']!='-')
                              {{$edu['from_date']}} to {{$edu['to_date']}}
                             @else
                              {{$edu['from_date']}} to Till Date
                             @endif
                              </li>
                              <li>{{$edu['edu_company']}}</li>
                              <li>{{$edu['edu_description']}}</li>
                              <li>{{$edu['edu_location']}}</li>
                              <li>{{$edu['edu_partners']}}</li> 
                            </ul>
                        @if($prof_det->private)
                            <div class="edit_btns">
                             <button type="button" class='pull-right btn btn-primary delete' data-parent="{{$prof_det->id}}" data-type="edu" data-value="{{$edu['id']}}">Delete</button>&nbsp; &nbsp;
                             <button type="button" class='pull-right btn btn-primary edu_edit' data-parent="{{$prof_det->id}}" data-type="edu" data-id="{{$edu['id']}}">Edit</button>
                            </div>
                        @endif    
                          </div>
                        </div>
                      @endforeach
                    </div>
                    <div class="profile_edit_data">
                      <div class="col-sm-8">
                        <ul>
                          <li><span>From</span>
                            <div class="form-group">
                               <select class="form-control" name="edu_from_yy" id="edu_from_yy">
                                <option value="">Year</option>
                                <?php
                                  for($y=date('Y'); $y>=date('Y')-90; --$y):
                                    echo '<option>'.$y.'</option>';
                                  endfor;
                                ?>
                              </select>
							  <select class="form-control" name="edu_from_mm" id="edu_from_mm">
                                <option value="">Month</option>
                                <?php
                                for($m=1; $m<=12; ++$m):
                                   $m_name = date('F', mktime(0, 0, 0, $m, 1));
                                 if($m>9) $n=$m; else $n="0".$m;
                                  echo '<option value="'.$n.'">'.$m_name.'</option>';
                                endfor;
                                
                                ?>
                              </select>
                             
                            </div>
                               <div class="clearfix"></div>
                          </li>
                          <li>
                            <span class="to-label">To</span>
                            <div class="form-group">
                              <select class="form-control" name="edu_to_yy" id="edu_to_yy">
                                <option value="">Year</option>
                                <?php
//                                  for($y=date('Y'); $y>=date('Y')-90; --$y):
//                                    echo '<option>'.$y.'</option>';
//                                  endfor;
                                ?>
                              </select>
							  <select class="form-control" name="edu_to_mm" id="edu_to_mm">
                                <option value="">Month</option>
                                <?php
//                                for($m=1; $m<=12; ++$m):
//                                   $m_name = date('F', mktime(0, 0, 0, $m, 1)); 
//                                  echo '<option value="'.$m_name.'">'.$m_name.'</option>';
//                                endfor;
                                ?>
                              </select>
                              
                                <input type="checkbox" value="1" name="edu_tilldate" id="edu_tilldate" <?php if(isset($edu['from_date']) && $edu['to_date']=='-'){echo "checked='checked'";}?>>&nbsp;I currently studying here
                            </div>
                            <div class="clearfix"></div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Location" name="edu_location" id="edu_location">
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Name of company/project/collective..." name="edu_company" id="edu_company">
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <textarea limit="255" rows="2" class="form-control" placeholder="Description" name="edu_description" id="edu_description"></textarea>
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="hidden" placeholder="Partners (among your friends)" name="edu_partners" id="edu_partners">
                           </div> 
                          </li>
                        </ul>
                      </div>
                      <div class="col-sm-4">
                      <div class="talent-profile-edit-btn-grp">
                        <button type="submit" name="submit_education" id="submit_education" value="education" class="btn talent_close">Save</button>
                        <button type="button" class=" btn talent_close_open">Cancel</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
               </form> 
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'L,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="locationForm" name="locationForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="location">

                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Location(s) <span class="profile-loc-icon"> @if($prof_det->private)
                        @if(strpos($prof_det->private_permission,'L,') === false)
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=L')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                        @else
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=L')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                        @endif
                      @endif</span></h3>
                     
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show add_location" href="javascript:void(0)"><span class="prof_plus-icon"> <i class="fa fa-plus"></i></span><span>You can add your location here</span></div>
                    </div>
                  @endif  
                    <div class="clearfix"></div>
                    <div class="profile_display_data"> 
                      @foreach($profile_loc as $loc)
                        <div class="col-sm-12 alert-warning">
                          <div>
                            <ul>
                              <li>{{$loc['loc_name']}}</li>
                              <li>{{$loc['loc_number']}}</li>
                              <li>{{$loc['loc_street']}}</li>
                              <li>{{$loc['loc_city']}}</li>
                              <li>{{$loc['loc_state']}}</li>
                              <li>{{$loc['loc_zip']}}</li>
                              <li>{{$loc['loc_country']}}</li>
                              <li>{{$loc['loc_description']}}</li>
                            </ul>
                        @if($prof_det->private)
                            <div class="edit_btns">
                             <button type="button" class='pull-right btn btn-primary delete' data-parent="{{$prof_det->id}}" data-type="loc" data-value="{{$loc['id']}}">Delete</button>&nbsp; &nbsp;
                             <button type="button" class='pull-right btn btn-primary loc_edit' data-parent="{{$prof_det->id}}" data-type="loc" data-id="{{$loc['id']}}">Edit</button>
                            </div>
                        @endif    
                          </div>
                        </div>
                      @endforeach
                    </div>
                    <div class="profile_edit_data">
                      <div class="col-sm-8">
                        <ul>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="First Name"  name="loc_name" id="loc_name">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Lastname" name="loc_number" id="loc_number">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Street, Avenue, etc." name="loc_street" id="loc_street">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="City" name="loc_city" id="loc_city">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="State" name="loc_state" id="loc_state">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Postal Code" name="loc_zip" id="loc_zip">
                          </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <!--<input class="form-control" type="text" placeholder="Country" name="loc_country" id="loc_country">-->
                            <select name="loc_country" id="loc_country" class="form-control country-selectbox">
                              <option value="">Country</option>
                              @if(count($countries)>0)
                                @foreach($countries as $c)
                                  <option value="{{$c['printable_name']}}" <?php if(count($profile_loc)>0){if($loc['loc_country']==$c['printable_name']){?>selected="selected" <?php } }?>>{{$c['printable_name']}}</option>
                                @endforeach
                              @endif  
                            </select>

                          </div>
                              <div class="clearfix"></div>
                          </li>
                          <li>
                          <div class="form-group">
                            <textarea limit="255" rows="2" class="form-control" placeholder="Description" name="loc_description" id="loc_description"></textarea>
                          </div>  
                          </li>
                        </ul>
                      </div>
                        <div class="col-sm-4">
                        <div class="talent-profile-edit-btn-grp">
                          <button type="submit" name="submit_location" id="submit_location" value="location" class="btn talent_close" href="javascript:void(0)">Save</button>
                           <button type="button" class="btn talent_close_open">Cancel</button>
                       </div>
                        </div>
                      
                      <!--<div class="col-sm-4"><a class="tp_add_image" href="javascript:void(0)"> <i class="fa fa-plus"></i><span>Add Image</span></a> </div>-->
                    </div>
                  </div>
                </div>
              </form> 
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'AW,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="awardsForm" name="awardsForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="awards">
                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Awards <span class="profile-loc-icon">@if($prof_det->private)
                        @if(strpos($prof_det->private_permission,'AW,') === false)
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=AW')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                        @else
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=AW')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                        @endif
                      @endif </span></h3>
                       
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show add_awards" href="javascript:void(0)"> <span class="prof_plus-icon"><i class="fa fa-plus"></i></span><span>You can add your awards here</span></div>
                    </div>
                  @endif    
                    <div class="clearfix"></div>
                    <div class="profile_display_data"> 
                      @foreach($profile_aw as $aw)
                        <div class="col-sm-12 alert-warning">
                          <div>
                            <ul>
                              <li>
                                @if($aw['from_date'])
                                {{$aw['from_date']}}
                                @endif
                              </li>
                              <li>{{$aw['aw_company']}}</li>
                              <li>{{$aw['aw_description']}}</li>
                              <li>{{$aw['aw_location']}}</li>
                            </ul>
                        @if($prof_det->private)
                            <div class="edit_btns">
                             <button type="button" class='pull-right btn btn-primary delete' data-parent="{{$prof_det->id}}" data-type="aw" data-value="{{$aw['id']}}">Delete</button>&nbsp; &nbsp;
                             <button type="button" class='pull-right btn btn-primary aw_edit' data-parent="{{$prof_det->id}}" data-type="aw" data-id="{{$aw['id']}}">Edit</button>
                            </div>
                        @endif    
                          </div>
                        </div>
                      @endforeach
                    </div>
                    <div class="profile_edit_data">
                      <div class="col-sm-8">
                        <ul>
                          <li><span>Award</span>
                            <div class="form-group">
                              <select class="form-control" name="aw_from_mm" id="aw_from_mm">
                                <option value="">Month</option>
                                <?php
                                for($m=1; $m<=12; ++$m):
                                   $m_name = date('F', mktime(0, 0, 0, $m, 1)); 
                                  echo '<option value="'.$m_name.'">'.$m_name.'</option>';
                                endfor;
                                ?>
                              </select>
                              <select class="form-control" name="aw_from_yy" id="aw_from_yy">
                                <option value="">Year</option>
                                <?php
                                  for($y=date('Y'); $y>=date('Y')-90; --$y):
                                    echo '<option>'.$y.'</option>';
                                  endfor;
                                ?>
                              </select>
                            </div>
                              <div class="clearfix"></div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Location" name="aw_location" id="aw_location">
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <input class="form-control" type="text" placeholder="Name of company/project/collective..." name="aw_company" id="aw_company">
                            </div>
                          </li>
                          <li>
                          <div class="form-group">
                            <textarea limit="255" rows="2" class="form-control" placeholder="Description" name="aw_description" id="aw_description"></textarea>
                            </div>
                          </li>
                        </ul>
                      </div>
                      <div class="col-sm-4">
                      <div class="talent-profile-edit-btn-grp">
                        <button type="submit" name="submit_education" id="submit_awards" value="awards" class="btn talent_close">Save</button>
                        <button type="button" class="btn talent_close_open">Cancel</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
               </form> 
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'In,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="influenceForm" name="influenceForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="influence">
                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Influence(s) <span class="profile-loc-icon"> @if($prof_det->private)
                        @if(strpos($prof_det->private_permission,'In,') === false)
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=In')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                        @else
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=In')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                        @endif
                      @endif    </span></h3>
                                        
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show" href="javascript:void(0)"> 
                        @if($prof_det->influence)
                          <i class="fa fa-pencil"></i><span>Edit</span>
                        @else
                         <span class="prof_plus-icon"> <i class="fa fa-plus"></i></span><span>You can detail your influences here</span>
                        @endif
                      </div>
                    </div>
                  @endif  
                    <div class="clearfix"></div>
                    <div class="profile_display_data">
                      <div class="col-sm-12">
                        {{$prof_det->influence}}
                      </div>
                    </div>                  
                    <div class="profile_edit_data ">
                      <div class="col-sm-8 form-group">
                        <textarea name="influence" id="influence" limit="255" rows="4" class="form-control" placeholder="Describe your influences...">{{$prof_det->influence}}</textarea>
                      </div>
                      <div class="col-sm-4">
                      <div class="talent-profile-edit-btn-grp">
                        <button type="submit" name="submit_influence" id="submit_influence" value="influence" class="btn talent_close" href="javascript:void(0)">Save</button>
                        <button type="button" class="btn talent_close_open" href="javascript:void(0)">Cancel</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
              @endif  
              @if($prof_det->private || strpos($prof_det->private_permission,'Int,') ===false || (isset($prof_det->full_profile) && $prof_det->full_profile))
              <form method="post" id="interestsForm" name="interestsForm">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="save_type" value="interests">
                <div class="panel panel-default">
                  <div class="panel-body row">
                    <div class="col-sm-4 col-xs-7">
                      <h3 class="pull-left">Interests <span class="profile-loc-icon">@if($prof_det->private)                      
                        @if(strpos($prof_det->private_permission,'Int,') === false)
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?lock=Int')}}" class="lock_unlock"><i class="fa fa-unlock"></i></a>
                        @else
                          <a href="{{url('/profile_permision/'.$prof_det->id.'?unlock=Int')}}" class="lock_unlock"><i class="fa fa-lock"></i></a>
                        @endif
                      @endif</span></h3>
                      
                    </div>
                  @if($prof_det->private)
                    <div class="col-sm-8 col-xs-5">
                      <div class="talent_show" href="javascript:void(0)">
                        @if($prof_det->interests)
                          <i class="fa fa-pencil"></i><span>Edit</span>
                        @else
                          <span class="prof_plus-icon"><i class="fa fa-plus"></i></span><span>You can specify here your artistic interests</span>
                        @endif
                       </div>
                    </div>
                  @endif  
                    <div class="clearfix"></div>
                      <div class="profile_display_data">
                        <div class="col-sm-12">
                          {{$prof_det->interests}}
                        </div>
                       </div>   
                    <div class="profile_edit_data">
                      <div class="col-sm-8 form-group">
                        <textarea name="interests" id="interests" limit="255" rows="4" class="form-control" placeholder="Describe your interests...">{{$prof_det->interests}}</textarea>
                      </div>
                      <div class="col-sm-4">
                      <div class="talent-profile-edit-btn-grp">
                        <button type="submit" name="submit_interest" id="submit_interest" value="interests" class="btn talent_close" href="javascript:void(0)">Save</button>
                        <button type="button" class="btn talent_close_open">Cancel</button>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
              @endif  
            </div>
        </div>
      </div>
    </div>
  </section>
 <!-- Social Modal -->
    <div id="social_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Links to your sites</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="socialLinksForm" name="socialLinksForm">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="save_type" value="social_links">
              <div class="form-group">
                  <label class="control-label col-md-2">Host</label>
                  <label class="control-label col-md-10 pull-left">Link to your profile</label>
              </div>
              <div class="form-group">
                  <label class="control-label col-md-2"><i class="fa fa-facebook fa-2x"></i></label>
                  <div class="col-md-10">
                      <input type="text" class="form-control" id="link[f]" name="link[f]" value="@if(isset($profile_links['f'])){{$profile_links['f']}}@endif" />
                  </div>
              </div>
              <div class="form-group">
                  <label class="control-label col-md-2"><i class="fa fa-linkedin fa-2x"></i></label>
                  <div class="col-md-10">
                      <input type="text" class="form-control" id="link[l]" name="link[l]" value="@if(isset($profile_links['l'])){{$profile_links['l']}}@endif"/>
                  </div>
              </div>
              <div class="form-group">
                  <label class="control-label col-md-2"><i class="fa fa-twitter fa-2x"></i></label>
                  <div class="col-md-10">
                      <input type="text" class="form-control" id="link[t]" name="link[t]" value="@if(isset($profile_links['t'])){{$profile_links['t']}}@endif" />
                  </div>
              </div>
              <div class="form-group">
                  <label class="control-label col-md-2"><i class="fa fa-pinterest fa-2x"></i></label>
                  <div class="col-md-10">
                      <input type="text" class="form-control" id="link[p]" name="link[p]" value="@if(isset($profile_links['p'])){{$profile_links['p']}}@endif" />
                  </div>
              </div>
              <div class="form-group">
                  <label class="control-label col-md-2"><i class="fa fa-google-plus fa-2x"></i></label>
                  <div class="col-md-10">
                      <input type="text" class="form-control" id="link[g]" name="link[g]" value="@if(isset($profile_links['g'])){{$profile_links['g']}}@endif" />
                  </div>
              </div>
              <div class="form-group">
                  <div class="col-md-6">
                      <button type="submit" value="Submit" class="btn btn-custom pull-right pop-btn">Save</button>				  
					  
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Social Modal -->
 <!-- Profile  Image Modal -->
    <div id="profile_image_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Upload / Update Profile Image</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="socialLinksForm" name="socialLinksForm" enctype="multipart/form-data">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="save_type" value="profile_image">
                <input type="hidden" id="x" name="x" />
                <input type="hidden" id="y" name="y" />
                <input type="hidden" id="w" name="w" />
                <input type="hidden" id="h" name="h" />   
                <input type="hidden" id="image_name" name="image_name">           
              <div class="form-group">
                <div class="col-sm-9">
                  You can upload a JPEG, GIF, or PNG file (File size limit is 2 MB).
                  
				  <span class="btn btn-file blue-btn btn-success">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Images</span>
                            <!-- The file input field used as target for the file upload widget -->
                           <input type="file" name="profile_pic" id="profile_pic"> 
                        </span>
				  
				  <br>
                  <div class="preview_img" style="margin-top: 10px;"></div> 
                </div>  
                <div class="col-sm-3">
                  @if($prof_det->profile_image)
                    <img class="img-responsive" src="{{url('uploads/profile_images/'.$prof_det->profile_image)}}" alt=""/>
                  @else                    
                    <img class="img-responsive" src="{{url('uploads/profile_images/default-profile.png')}}" alt=""/>
                  @endif
				 
                </div>
              </div>
              <div class="form-group">
                  <div class="col-md-6">
                      
					  <button type="submit" value="Submit" class="btn btn-custom pull-right pop-btn">Save</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal -->
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>

<script src="{{ asset('plugins/jcrop/js/jquery.Jcrop.js')}}"></script>
<!--<script src="{{ asset('plugins/ajaxupload/ajaxupload.3.5.js')}}"></script>
<script src="{{ asset('js/changeprofilepic.js')}}"></script>-->
<script src="{{ asset('js/validation.js')}}"></script>

<script src="{{ asset('js/vendor/jquery.ui.widget.js')}}"></script>
<script src="{{ asset('js/jquery.iframe-transport.js')}}"></script>
<script src="{{ asset('js/jquery.fileupload.js')}}"></script>
<script src="{{ asset('js/bootstrap-select.js')}}"></script>
<script type="text/javascript">
$('.talent_close_open').click(function(){
		$('.profile_edit_data').hide();
		$('.profile_display_data').show();
		$('.talent_show').show();
		$(this).parent().parent('.profile_edit_data').hide();
//		$(this).parent().parent('.profile_edit_data').slideUp(200);
		$(this).parent().parent().parent().children('.profile_display_data').show();
		$(this).parent().parent().parent().children('div').children('.talent_show').show();
	});

</script>

<script type="text/javascript">

  var experience = JSON.parse('<?php echo json_encode($profile_exp)?>');
  var education = JSON.parse('<?php echo json_encode($profile_edu)?>');
  var locations = JSON.parse('<?php echo json_encode($profile_loc)?>');
  var awards = JSON.parse('<?php echo json_encode($profile_aw)?>');

  $(document).on('click','.add_experience',function(){
    $("#experienceForm").attr("action", '');
    $("#experienceForm")[0].reset();   
   });

  $(document).on('click','.exp_edit',function(){
    if($("#exp_tilldate").prop('checked') == true){
           $("#exp_to_mm").prop("disabled", true);
           $("#exp_to_yy").prop("disabled", true);
     }
    parent = $(this).attr('data-parent');
    type = $(this).attr('data-type');
    value = $(this).attr('data-id');
    exp_data = experience[value]; 
     
     var year_val=checkyear();
     var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
     for (var i = year_val; i >= exp_data['exp_from_yy']; i--)
                {
                $('#exp_to_yy').append('<option>' + i + '</option>');
                }
                
     if(year_val==exp_data['exp_from_yy'])
                { 
                  addfrommonth();
                  add_from_months_current();
                }
     
      if(year_val==exp_data['exp_to_yy'])
            { 
                if(exp_data['exp_to_yy']==exp_data['exp_from_yy'])
                { 
                             addtomonth();
                             var selec_val=exp_data['exp_from_mm'];
                             selec_val = selec_val.replace(/^0+/, '');
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=selec_val;i<=currentMonth;i++)
                                {
                                 $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                }
                else
                {
                    addtomonth();
                    add_to_months_current2();
                }

            }
           
       if(exp_data['exp_to_yy']==exp_data['exp_from_yy'] && year_val!=exp_data['exp_to_yy'])
        {
                             addtomonth();
                             var selec_val=exp_data['exp_from_mm'];
                             selec_val = selec_val.replace(/^0+/, '');
                             var tot=parseInt(selec_val);
                             for(i=tot;i<=12;i++)
                                {
                                 $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }

        }
        if(exp_data['exp_to_yy']>exp_data['exp_from_yy'] && year_val!=exp_data['exp_to_yy'])
        {
                addtomonth();
                add_list_months();

        }
       
     
    $.each(exp_data, function(key, values) {
      if($('#'+key).length)
        $('#'+key).val(values);
    });
   
   
                
    action = '/profiles/'+parent+'/edit/'+type+'/'+value;
    $("#experienceForm").attr("action", action);
//    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').slideDown(600);
    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').show();
    $(this).parent().parent().parent().parent().parent().children('.profile_display_data').hide();
    //$('.talent_show').hide();
  });

$(document).on('click','.add_awards',function(){
    $("#awardsForm").attr("action", '');
    $("#awardsForm")[0].reset();   
   });

  $(document).on('click','.aw_edit',function(){
    parent = $(this).attr('data-parent');
    type = $(this).attr('data-type');
    value = $(this).attr('data-id');
    aw_data = awards[value];  
    console.log(aw_data);
    $.each(aw_data, function(key, values) {
      if($('#'+key).length)
        $('#'+key).val(values);
    });
    action = '/profiles/'+parent+'/edit/'+type+'/'+value;
    $("#awardsForm").attr("action", action);
//    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').slideDown(600);
    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').show();
    $(this).parent().parent().parent().parent().parent().children('.profile_display_data').hide();
    //$('.talent_show').hide();
  });

  $(document).on('click','.add_education',function(){
    $("#educationForm").attr("action", '');
    $("#educationForm")[0].reset();   
 });

  $(document).on('click','.edu_edit',function(){
       if($("#edu_tilldate").prop('checked') == true){
           $("#edu_to_mm").prop("disabled", true);
           $("#edu_to_yy").prop("disabled", true);
     }
    parent = $(this).attr('data-parent');
    type = $(this).attr('data-type');
    value = $(this).attr('data-id');
    edu_data = education[value];  
    
     var year_val=checkyear();
     var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
     for (var i = year_val; i >= edu_data['edu_from_yy']; i--)
                {
                $('#edu_to_yy').append('<option>' + i + '</option>');
                }
                
     if(year_val==edu_data['edu_from_yy'])
                { 
                  addedufrommonth();
                  add_edu_from_months_current();
                }
     
      if(year_val==edu_data['edu_to_yy'])
            { 
                if(edu_data['edu_to_yy']==edu_data['edu_from_yy'])
                { 
                             addedutomonth();
                             var selec_val=edu_data['edu_from_mm'];
                             selec_val = selec_val.replace(/^0+/, '');
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=selec_val;i<=currentMonth;i++)
                                {
                                 $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                }
                else
                {
                    addedutomonth();
                    add_edu_to_months_current2();
                }

            }
           
       if(edu_data['edu_to_yy']==edu_data['edu_from_yy'] && year_val!=edu_data['edu_to_yy'])
        {
                             addedutomonth();
                             var selec_val=edu_data['edu_from_mm'];
                             selec_val = selec_val.replace(/^0+/, '');
                             var tot=parseInt(selec_val);
                             for(i=tot;i<=12;i++)
                                {
                                 $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }

        }
        if(edu_data['edu_to_yy']>edu_data['edu_from_yy'] && year_val!=edu_data['edu_to_yy'])
        {
                addedutomonth();
                add_edu_list_months();

        }
    
    
    $.each(edu_data, function(key, values) {
      if($('#'+key).length)
        $('#'+key).val(values);
    });
    action = '/profiles/'+parent+'/edit/'+type+'/'+value;
    $("#educationForm").attr("action", action);
//    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').slideDown(600);
    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').show();
    $(this).parent().parent().parent().parent().parent().children('.profile_display_data').hide();
    //$('.talent_show').hide();
  });

  $(document).on('click','.add_location',function(){
    $("#locationForm").attr("action", '');
    $("#locationForm")[0].reset();   
  });

  $(document).on('click','.loc_edit',function(){
    parent = $(this).attr('data-parent');
    type = $(this).attr('data-type');
    value = $(this).attr('data-id');
    loc_data = locations[value];  
    $.each(loc_data, function(key, values) {
      if($('#'+key).length)
        $('#'+key).val(values);
    });
    action = '/profiles/'+parent+'/edit/'+type+'/'+value;
    $("#locationForm").attr("action", action);
//    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').slideDown(600);
    $(this).parent().parent().parent().parent().parent().children('.profile_edit_data').show();
    $(this).parent().parent().parent().parent().parent().children('.profile_display_data').hide();
    //$('.talent_show').hide();
  });

  $(document).on('click','.delete',function(){
    parent = $(this).attr('data-parent');
    type = $(this).attr('data-type');
    type_id = $(this).attr('data-value');
    location.href='/profiles/'+parent+'/delete/'+type+'/'+type_id;
  });

/*fileupload script*/
$(document).on('click','#changeprofilepic',function(){
        $("#profile_image_modal").modal('show');
       // test();
});
$(function () {
    'use strict';
    // Change this to the location of your server-side upload handler:
    var url = "{{ url('profile/do_ajaxupload', $parameters = [], $secure = null) }}";
    $('#profile_pic').fileupload({
        url: url,
        dataType: 'json',
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        formData : {
                    _token: '{{ csrf_token() }}'
                    },
        done: function (e, data) {
            $.each(data.files, function (index, file) {
              if(data.result.files.error)
              {
                
                $('.preview_img').html(data.result.files.error);
                $('#profile_image_save').hide();
                return false;
              } 
              else
              { 
                $('.preview_img').html('<img src="/uploads/profile_images/'+file.name+'" alt="preview" class="img-responsive crop">');
                $('#image_name').val(file.name);
                $('#profile_image_save').show();
              }  
            });
            crop();
        },
       /* progressall: function (e, data) {
            var progress = parseInt(data.loaded / data.total * 100, 10);
            $('#progress .progress-bar').css(
                'width',
                progress + '%'
            );
        }*/
    }).bind('fileuploadadded', function (e, data) {
        console.log(data.files.valid);
    });/*.prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');*/
});

var jcrop_api,
        boundx,
        boundy,

        // Grab some information about the preview pane
        $preview = $('#preview-pane'),
        $pcnt = $('#preview-pane .preview-container'),
        $pimg = $('#preview-pane .preview-container img'),

        xsize = $pcnt.width(),
        ysize = $pcnt.height();

function crop(){//alert();
  var jcrop_api,
        boundx = 10,
        boundy = 10; /*,

        // Grab some information about the preview pane
        $preview = $('#preview-pane'),
        $pcnt = $('#preview-pane .preview-container'),
        $pimg = $('#preview-pane .preview-container img'),

        xsize = $pcnt.width(),
        ysize = $pcnt.height();*/
    
   // console.log('init',[xsize,ysize]);
    $('.crop').Jcrop({
      onChange: updateCoords,
      onSelect: updateCoords,
      onRelease:  clearCoords,
    bgColor: 'black',
      bgOpacity: .6,
    setSelect: [10, 10, 200, 200 ],
      aspectRatio: 1,
      minSize:[200,200],
      maxSize:[0,0],
      allowResize: 1,
      aspectRatio: 1
    },function(){
      // Use the API to get the real image size
      var bounds = this.getBounds();
      boundx = bounds[0];
      boundy = bounds[1];
      // Store the API in the jcrop_api variable
      jcrop_api = this;

      // Move the preview into the jcrop container for css positioning
      //$preview.appendTo(jcrop_api.ui.holder);
    });
}

function updateCoords(c)
  {
  
    $('#x').val(c.x);
    $('#y').val(c.y);
    $('#w').val(c.w);
    $('#h').val(c.h);
  };

function clearCoords()
  {
      $('#x').val('');
        $('#y').val('');
        $('#w').val('');
        $('#h').val('');
  };
/*fileupload script*/

$(function(){
        $('#exp_tilldate').click(function() {
        if($(this).is(":checked")) 
        {
           $("#exp_to_mm").prop("disabled", true);
           $("#exp_to_yy").prop("disabled", true);
        }
        else
        {
           $("#exp_to_mm").prop("disabled", false);
           $("#exp_to_yy").prop("disabled", false);
        }   
       
    });
         $('#edu_tilldate').click(function() {
        if($(this).is(":checked")) 
        {
           $("#edu_to_mm").prop("disabled", true);
           $("#edu_to_yy").prop("disabled", true);
        }
        else
        {
           $("#edu_to_mm").prop("disabled", false);
           $("#edu_to_yy").prop("disabled", false);
        }   
       
    });
    
});

function checkyear()
{
   var start_year = new Date().getFullYear();  
   return start_year;
}
function addtoyears()
{
   var val1=$('#exp_to_yy').html('');
   var val2=$('#exp_to_yy').html('<option value="">Year</option>');
    return [val1,val2];  
}
function addedutoyears()
{
   var val1=$('#edu_to_yy').html('');
   var val2=$('#edu_to_yy').html('<option value="">Year</option>');
    return [val1,val2];  
}
function addfrommonth()
{
   var val1=$('#exp_from_mm').empty(); 
   var val2=$('#exp_from_mm').html('<option value="">Month</option>').change();
    return [val1,val2];  
}
function addedufrommonth()
{
   var val1=$('#edu_from_mm').empty(); 
   var val2=$('#edu_from_mm').html('<option value="">Month</option>').change();
    return [val1,val2];  
}
function addtomonth()
{
   var val1=$('#exp_to_mm').empty(); 
   var val2=$('#exp_to_mm').html('<option value="">Month</option>').change();
    return [val1,val2];  
}
function addedutomonth()
{
   var val1=$('#edu_to_mm').empty(); 
   var val2=$('#edu_to_mm').html('<option value="">Month</option>').change();
    return [val1,val2];  
}
function add_from_months_current()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                              for(i=1;i<=12;i++)
                                {
                                 $("#exp_from_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                             var currentMonth = (new Date).getMonth() + 1;
                              for(i=currentMonth;i<=12;i++)
                                 {
                                     $("#exp_from_mm option[value="+("0" + (i+1)).slice(-2)+"]").each(function() {
                                         $(this).remove();
                                     });
                                 }
}
function add_edu_from_months_current()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                              for(i=1;i<=12;i++)
                                {
                                 $("#edu_from_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                             var currentMonth = (new Date).getMonth() + 1;
                              for(i=currentMonth;i<=12;i++)
                                 {
                                     $("#edu_from_mm option[value="+("0" + (i+1)).slice(-2)+"]").each(function() {
                                         $(this).remove();
                                     });
                                 }
}
function add_to_months_current()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var selec_val=jQuery("#exp_from_mm option:selected").val();
                             selec_val = selec_val.replace(/^0+/, '');
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=selec_val;i<=currentMonth;i++)
                                {
                                 $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                            
}
function add_edu_to_months_current()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var selec_val=jQuery("#edu_from_mm option:selected").val();
                             selec_val = selec_val.replace(/^0+/, '');
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=selec_val;i<=currentMonth;i++)
                                {
                                 $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                            
}
function add_to_months_current2()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=1;i<=currentMonth;i++)
                                {
                                 $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                            
}
function add_edu_to_months_current2()
{              
    
        var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var currentMonth = (new Date).getMonth() + 1;
                             
                           for(i=1;i<=currentMonth;i++)
                                {
                                 $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
                            
}
function add_from_months()
{               
                var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                var lastValue = $('#exp_from_mm option:last-child').val();
                lastValue = lastValue.replace(/^0+/, '');
                var tot=parseInt(lastValue)+1;
                for(i=tot;i<=12;i++)
                  {
                   $("#exp_from_mm").append("<option value="+("0" + (i-1)).slice(-2)+">"+months[i-1]+"</option>");
                  }
}
function add_edu_from_months()
{               
                var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                var lastValue = $('#edu_from_mm option:last-child').val();
                lastValue = lastValue.replace(/^0+/, '');
                var tot=parseInt(lastValue)+1;
                for(i=tot;i<=12;i++)
                  {
                   $("#edu_from_mm").append("<option value="+("0" + (i-1)).slice(-2)+">"+months[i-1]+"</option>");
                  }
}
function add_to_months()
{               
               var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var selec_val=jQuery("#exp_from_mm option:selected").val();
                             selec_val = selec_val.replace(/^0+/, '');
                             var tot=parseInt(selec_val);
                           for(i=tot;i<=12;i++)
                                {
                                 $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
}
function add_edu_to_months()
{               
               var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
                            
                             var selec_val=jQuery("#edu_from_mm option:selected").val();
                             selec_val = selec_val.replace(/^0+/, '');
                             var tot=parseInt(selec_val);
                           for(i=tot;i<=12;i++)
                                {
                                 $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                                }
}
function add_list_months()
{ 
    var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
    for(i=1;i<=12;i++)
                    {
                     $("#exp_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                    }
}
function add_edu_list_months()
{ 
    var months = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
    for(i=1;i<=12;i++)
                    {
                     $("#edu_to_mm").append("<option value="+("0" + (i)).slice(-2)+">"+months[i-1]+"</option>");
                    }
}
//for exp drop down boxes
$('#exp_from_yy').change(function()
    {
                var year_val=checkyear();
                addtoyears();
                addtomonth();
                for (var i = year_val; i >= $('#exp_from_yy').val(); i--)
                {
                $('#exp_to_yy').append('<option>' + i + '</option>');
                }
                var selec_val=jQuery("#exp_from_mm option:selected").val();
                    selec_val = selec_val.replace(/^0+/, '');
                var currentMonth = (new Date).getMonth() + 1;
                   
                 if(year_val==$('#exp_from_yy').val())
                { 
                   addfrommonth();
                  add_from_months_current();
                }
                else
                {   
                    var lastValue = $('#exp_from_mm option:last-child').val();
                    if(lastValue!=12)
                    {  
                        addtomonth();
                        add_from_months();
                    }
                    
                   
                }
        //alert(year);
    });
    
$('#edu_from_yy').change(function()
    {
                var year_val=checkyear();
                addedutoyears();
                addedutomonth();
                for (var i = year_val; i >= $('#edu_from_yy').val(); i--)
                {
                $('#edu_to_yy').append('<option>' + i + '</option>');
                }
                var selec_val=jQuery("#edu_from_mm option:selected").val();
                    selec_val = selec_val.replace(/^0+/, '');
                var currentMonth = (new Date).getMonth() + 1;
                   
                 if(year_val==$('#edu_from_yy').val())
                { 
                   addedufrommonth();
                  add_edu_from_months_current();
                }
                else
                {   
                    var lastValue = $('#edu_from_mm option:last-child').val();
                    if(lastValue!=12)
                    {  
                        addedutomonth();
                        add_edu_from_months();
                    }
                    
                   
                }
        //alert(year);
    });
    $('#exp_from_mm').change(function()
    {
        if($('#exp_to_yy').val()=="")
          {
           $('#exp_to_mm').html(''); 
           $('#exp_to_mm').html('<option value="">Month</option>');
          } 
          else
          {
               var year_val=checkyear();
              if(year_val==$('#exp_to_yy').val())
                    { 
                        if($('#exp_to_yy').val()==$('#exp_from_yy').val())
                        { 
                            addtomonth();
                            add_to_months_current();
                        }
                        else
                        {
                             addtomonth();
                            add_to_months_current2();
                        }
                         
                    }
              if($('#exp_to_yy').val()==$('#exp_from_yy').val() && year_val!=$('#exp_to_yy').val())
                {
                        addtomonth();
                        add_to_months();
                    
                }
                 if($('#exp_to_yy').val()>$('#exp_from_yy').val() && year_val!=$('#exp_to_yy').val())
                {
                        addtomonth();
                        add_list_months();
                    
                }
          }
    });
       $('#edu_from_mm').change(function()
    {
        if($('#edu_to_yy').val()=="")
          {
           $('#edu_to_mm').html(''); 
           $('#edu_to_mm').html('<option value="">Month</option>');
          } 
          else
          {
               var year_val=checkyear();
              if(year_val==$('#edu_to_yy').val())
                    { 
                        if($('#edu_to_yy').val()==$('#edu_from_yy').val())
                        { 
                            addedutomonth();
                            add_edu_to_months_current();
                        }
                        else
                        {
                             addedutomonth();
                            add_edu_to_months_current2();
                        }
                         
                    }
              if($('#edu_to_yy').val()==$('#edu_from_yy').val() && year_val!=$('#edu_to_yy').val())
                {
                        addedutomonth();
                        add_edu_to_months();
                    
                }
                 if($('#edu_to_yy').val()>$('#edu_from_yy').val() && year_val!=$('#edu_to_yy').val())
                {
                        addedutomonth();
                        add_edu_list_months();
                    
                }
          }
    });
    $('#exp_to_yy').change(function()
    { 
         if($('#exp_to_yy').val()=="")
          {
           $('#exp_to_mm').html(''); 
           $('#exp_to_mm').html('<option value="">Month</option>');
          } 
          else
          {
               var year_val=checkyear();
              if(year_val==$('#exp_to_yy').val())
                    { 
                        if($('#exp_to_yy').val()==$('#exp_from_yy').val())
                        { 
                            addtomonth();
                            add_to_months_current();
                        }
                        else
                        {
                             addtomonth();
                            add_to_months_current2();
                        }
                         
                    }
              if($('#exp_to_yy').val()==$('#exp_from_yy').val() && year_val!=$('#exp_to_yy').val())
                {
                        addtomonth();
                        add_to_months();
                    
                }
                if($('#exp_to_yy').val()>$('#exp_from_yy').val() && year_val!=$('#exp_to_yy').val())
                {
                        addtomonth();
                        add_list_months();
                    
                }
          }
    });
       $('#edu_to_yy').change(function()
    { 
         if($('#edu_to_yy').val()=="")
          {
           $('#edu_to_mm').html(''); 
           $('#edu_to_mm').html('<option value="">Month</option>');
          } 
          else
          {
               var year_val=checkyear();
              if(year_val==$('#edu_to_yy').val())
                    { 
                        if($('#edu_to_yy').val()==$('#edu_from_yy').val())
                        { 
                            addedutomonth();
                            add_edu_to_months_current();
                        }
                        else
                        {
                             addedutomonth();
                            add_edu_to_months_current2();
                        }
                         
                    }
              if($('#edu_to_yy').val()==$('#edu_from_yy').val() && year_val!=$('#edu_to_yy').val())
                {
                        addedutomonth();
                        add_edu_to_months();
                    
                }
                if($('#edu_to_yy').val()>$('#edu_from_yy').val() && year_val!=$('#edu_to_yy').val())
                {
                        addedutomonth();
                        add_edu_list_months();
                    
                }
          }
    });
    
</script>

@endsection
