<div class="panel panel-default">
  <div class="panel-body row">
    @if($funding==1)
    <!-- Raising Funding -->
    <div class="col-sm-12 funding-block" id="funding1">
    <form method="post" id="fundForm" name="fundForm" enctype="multipart/form-data" action="{{$action_url}}">
      <input type="hidden" name="_token" value="{{ csrf_token() }}">
      <input type="hidden" name="sel_funding_type" id="sel_funding_type" value="{{$funding}}">
      <input type="hidden" name="_fb_id" id="_fb_id" value="{{ ( isset($funding_data->id) ) ? $funding_data->id : 0 }}">
      <h3>Raise Funding</h3><hr>
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'BY,') ===false))
      <div class="col-md-4">
        <div class="form-group">
          <div class="panel panel-default">
            <div class="panel-heading">
              <label class="control-label">Years in business</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'BY,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=BY')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=BY')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>
            <div class="panel-body">
              <select class="form-control" id="years_in_business" name="years_in_business">
                <option value="">Years</option>
                <?php foreach($business_years as $year): ?>
                  <option {{ (isset($funding_data->years_in_business) && $funding_data->years_in_business == $year->id  || isset($funding_year->years_in_business) && $funding_year->years_in_business == $year->id) ? 'selected=selected' : '' }} value="{{$year->id}}">{{$year->years}}</option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>                          
      </div>   
      <div class="clearfix"></div>
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'RV,') ===false))
      <div class="col-md-12">
       
          <div class="panel panel-default">
            <div class="panel-heading">
              <label class="control-label">Your Revenue</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'RV,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=RV')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=RV')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif              
            </div>
            <div class="panel-body">
              <div class="col-md-4 form-group">
                <input type="text" class="form-control" name="revenue_det" id="revenue_det" placeholder="Revenue Details" <?php if(isset($funding_data->revenue_det) && $funding_data->revenue_det) echo 'value="'.$funding_data->revenue_det.'"';?>>
              </div>
              <div class="col-md-4 form-group">
                <select class="form-control" id="assets_currency" name="assets_currency" >
                  <option value="">Currency</option>
                  <?php foreach($currency_all as $curreny): ?>
                    <option {{ (isset($funding_data->assets_currency) && $funding_data->assets_currency == $curreny->id) ? 'selected=selected' : '' }} value="{{$curreny->id}}">{{$curreny->name}}</option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-4 form-group">  
                <select class="form-control" id="assets_currency_units" name="assets_currency_units">
                  <option value="">Unit</option>
                  <?php foreach($currency_units as $unit): ?>
                    <option {{ (isset($funding_data->assets_currency_units) && $funding_data->assets_currency_units == $unit->id) ? 'selected=selected' : '' }} value="{{$unit->id}}">{{$unit->units}} ({{$unit->amount}})</option>
                  <?php endforeach; ?>
                </select>
              </div>  
            </div>
          </div>
        
      </div>  
      <div class="clearfix"></div>
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'G,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Projected Growth Year Over Year
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'G,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=G')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=G')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
            </label>
            <div class="col-sm-6">
                <?php $per=$growth_per_year->percentage;
               
                ?>
              <select class="form-control" id="growth" name="growth">
                <option value="">Growth </option>
                  <option value="<?php echo '0-'.$growth_per_year->percentage; ?>"><?php echo '0-'.$growth_per_year->percentage; ?></option>
                <?php 
                for($i=$per; $i<100;$i+=$per){
                   $sam=$per+$i; ?>
                  <option  {{ (isset($funding_data->growth) && $funding_data->growth == ($i+1).'-'.$sam) ? 'selected=selected' : ''}} value="<?php echo ($i+1).'-'.$sam; ?>"><?php echo ($i+1).'-'.$sam; ?></option>
                <?php 
                    } ?>
               
              </select>
            </div>
          </div>
        </div>
      </div>
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'E,') ===false))
      <div class="col-md-12">
       <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Number of Employees
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'E,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=E')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=E')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
                <input class="form-control" type="text" id="emp_strength" name="emp_strength" value="<?php if(isset($funding_data->emp_strength))echo $funding_data->emp_strength;?>">
            </div>
          </div>
        </div>
      </div>  
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'NB,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Nature of Business
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'NB,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=NB')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=NB')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
              <select class="form-control" id="nature_business" name="nature_business">
                <option value="">Industry</option>
                <?php foreach($industries as $industry): ?>
                  <option {{ (isset($funding_data->nature_business) && $funding_data->nature_business == $industry->id) ? 'selected=selected' : '' }} value="{{$industry->id}}">{{$industry->name}}</option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>
      </div>   
      @endif                                                     
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PL,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Your Profit and Loss Statement (Last 5 Years)
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PL,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=PL')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=PL')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
              @if(isset($funding_data->prev_profit_loss) && $funding_data->prev_profit_loss)
                {{--*/ $viewName = @end( @explode( '.', $funding_data->prev_profit_loss) );$file_type=''; /*--}}
                @if($viewName=='doc')
                {{--*/ $file_type='fa-file-word-o' /*--}}
                @endif
                @if($viewName=='docx')
                {{--*/ $file_type='fa-file-word-o' /*--}}
                @endif
                @if($viewName=='pdf')
                {{--*/ $file_type='fa-file-pdf-o' /*--}}
                @endif
                @if($viewName=='txt')
                {{--*/ $file_type='fa-file-text-o' /*--}}
                @endif
                @if($viewName=='xls')
                {{--*/ $file_type='fa-file-excel-o' /*--}}
                @endif
                @if($viewName=='xlsx')
                {{--*/ $file_type='fa-file-excel-o' /*--}}
                @endif
                @if($viewName=='ppt')
                {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                @endif
                @if($viewName=='pptx')
                {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                @endif
                <div class="col-md-4">
                  <!--<div>{{$funding_data->prev_profit_loss}}</div>-->
                  <div class="pull-right">
                    @if($prof_det->private)
                      <!--<a href="javascript:void(0)" title="Delete"><i class="fa fa-trash-o"></i></a>-->
                      <a href="javascript:void(0)" data-url="{{url('funding_docs_delete/'.$funding_data->id.'/prev_profit_loss')}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                    @endif
                  </div>
                  <a target="_blank" href="{{asset('/download/funding/'.$funding_data->id.'/prev_profit_loss')}}"><i class="fa {{$file_type}} fa-3x"></i></a>
                </div>
              @else  
                <span class="btn btn-file blue-btn">
                    <i class="glyphicon glyphicon-plus"></i>
                    <span>Select files...</span>
                    <!-- The file input field used as target for the file upload widget -->
                    <input id="prev_profit_loss" type="file" name="prev_profit_loss">
                </span>
                    <p id="prev_profit_loss_error" class="error txt-red"></p>
                <!-- The global progress bar -->
                <div id="ppl_progress" class="progress">
                    <div class="progress-bar progress-bar-success"></div>
                </div>
                <!-- The container for the uploaded files -->
                <div id="ppl_files" class="files">
                  <?php /* foreach($funding_assets_data as $asset) { 
                      if($asset->type == 'DOCS')
                      {
                  ?>
                    <p><?php echo $asset->name; ?> - <span class="removeTh text-danger" style="cursor:pointer" data-id="<?php echo $asset->id; ?>" data-url="<?php echo $asset->delete_url; ?>">remove</span>
                  <?php } } */ ?>
                </div>  
                <p class="help-block">Attach P & L.</p>
              @endif
            </div>
          </div>
        </div>                              
      </div>  
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PN,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Your Profit and Loss Statement (Next 5 Year: Projected)
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PN,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=PN')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=PN')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
                @if(isset($funding_data->next_profit_loss) && $funding_data->next_profit_loss)
                  {{--*/ $viewName = @end( @explode( '.', $funding_data->next_profit_loss) );$file_type=''; /*--}}
                  @if($viewName=='doc')
                  {{--*/ $file_type='fa-file-word-o' /*--}}
                  @endif
                  @if($viewName=='docx')
                  {{--*/ $file_type='fa-file-word-o' /*--}}
                  @endif
                  @if($viewName=='pdf')
                  {{--*/ $file_type='fa-file-pdf-o' /*--}}
                  @endif
                  @if($viewName=='txt')
                  {{--*/ $file_type='fa-file-text-o' /*--}}
                  @endif
                  @if($viewName=='xls')
                  {{--*/ $file_type='fa-file-excel-o' /*--}}
                  @endif
                  @if($viewName=='xlsx')
                  {{--*/ $file_type='fa-file-excel-o' /*--}}
                  @endif
                  @if($viewName=='ppt')
                  {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                  @endif
                  @if($viewName=='pptx')
                  {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                  @endif
                  <div class="col-md-4">
                    <!--<div>{{$funding_data->next_profit_loss}}</div>-->
                    <div class="pull-right">
                      @if($prof_det->private)
                        <!--<a href="javascript:void(0)" title="Delete"><i class="fa fa-trash-o"></i></a>-->
                        <a href="javascript:void(0)" data-url="{{url('funding_docs_delete/'.$funding_data->id.'/next_profit_loss')}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                      @endif
                    </div>
                    <a target="_blank" href="{{asset('/download/funding/'.$funding_data->id.'/next_profit_loss')}}"><i class="fa {{$file_type}} fa-3x"></i></a>
                  </div>
                @else  
                  <span class="btn btn-file blue-btn">
                      <i class="glyphicon glyphicon-plus"></i>
                      <span>Select files...</span>
                      <!-- The file input field used as target for the file upload widget -->
                      <input id="next_profit_loss" type="file" name="next_profit_loss">
                  </span>
                  <p id="next_profit_loss_error" class="error txt-red"></p>
                  <!-- The global progress bar -->
                  <div id="nppl_progress" class="progress">
                      <div class="progress-bar progress-bar-success"></div>
                  </div>
                  <!-- The container for the uploaded files -->
                  <div id="nppl_files" class="files"></div>  
                  <p class="help-block">Attach P & L Projected</p>
                @endif
            </div>
          </div>
        </div>
      </div> 
      @endif 
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'LT,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Your Leadership Team
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'LT,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=LT')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=LT')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
                @if(isset($funding_data->lship_team_file) && $funding_data->lship_team_file)
                  {{--*/ $viewName = @end( @explode( '.', $funding_data->lship_team_file) );$file_type=''; /*--}}
                  @if($viewName=='doc')
                  {{--*/ $file_type='fa-file-word-o' /*--}}
                  @endif
                  @if($viewName=='docx')
                  {{--*/ $file_type='fa-file-word-o' /*--}}
                  @endif
                  @if($viewName=='pdf')
                  {{--*/ $file_type='fa-file-pdf-o' /*--}}
                  @endif
                  @if($viewName=='txt')
                  {{--*/ $file_type='fa-file-text-o' /*--}}
                  @endif
                  @if($viewName=='xls')
                  {{--*/ $file_type='fa-file-excel-o' /*--}}
                  @endif
                  @if($viewName=='xlsx')
                  {{--*/ $file_type='fa-file-excel-o' /*--}}
                  @endif
                  @if($viewName=='ppt')
                  {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                  @endif
                  @if($viewName=='pptx')
                  {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                  @endif
                  <div class="col-md-4">
                    <!--<div>{{$funding_data->lship_team_file}}</div>-->
                    <div class="pull-right">
                      @if($prof_det->private)
                        <!--<a href="javascript:void(0)" title="Delete"><i class="fa fa-trash-o"></i></a>-->
                        <a href="javascript:void(0)" data-url="{{url('funding_docs_delete/'.$funding_data->id.'/lship_team_file')}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                      @endif
                    </div>
                    <a target="_blank" href="{{asset('/download/funding/'.$funding_data->id.'/lship_team_file')}}"><i class="fa {{$file_type}} fa-3x"></i></a>
                  </div>
               @else   
                <span class="btn btn-success btn-file blue-btn">
                    <i class="glyphicon glyphicon-plus"></i>
                    <span>Select files...</span>
                    <!-- The file input field used as target for the file upload widget -->
                    <input id="lship_team_file" type="file" name="lship_team_file">
                </span>
                <p id="lship_team_file_error" class="error txt-red"></p>
                <!-- The global progress bar -->
                <div id="lship_progress" class="progress">
                    <div class="progress-bar progress-bar-success"></div>
                </div>
                <!-- The container for the uploaded files -->
                <div id="lship_files" class="files"></div>                
                <p class="help-block">Attach bios</p>
              @endif

            </div>
          </div>
        </div>                                      
      </div> 
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'BU,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">How Is Your Business Unique?
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'BU,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=BU')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=BU')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
              </label>
            <div class="col-sm-6">
              <textarea class="form-control" rows="4" id="industry_focus" name="industry_focus">{{ $funding_data->industry_focus or '' }}</textarea>
            </div>
          </div>
        </div>
      </div>  
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'F,') ===false))
      <div class="col-md-12">
        
          <div class="row">
            <label class="col-sm-4 control-label">How Much Funding Are You Looking For
              @if($prof_det->private)
                <span class="">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'F,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=F')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=F')}}"><i class="fa fa-lock"></i></a>
                @endif
                </span>
              @endif
            </label>
            <div class="col-sm-2 form-group">
              <input type="text" class="form-control" id="investment_amt" name="investment_amt" value="<?php if(isset($funding_data->investment_amt)){echo $funding_data->investment_amt;} ?>">
            </div>
            <div class="col-sm-3 form-group">
              <select class="form-control" id="min_investment_currency" name="min_investment_currency">
                <option value="">Currency</option>
                  <?php foreach($currency_all as $curreny): ?>
                    <option {{ (isset($funding_data->min_investment_currency) && $funding_data->min_investment_currency == $curreny->id) ? 'selected=selected' : '' }} value="{{$curreny->id}}">{{$curreny->name}}</option>
                  <?php endforeach; ?>
              </select>
            </div>
            <div class="col-sm-3 form-group">
              <select class="form-control" id="min_investment_currency_units" name="min_investment_currency_units">
                <option value="">Unit</option>
                  <?php foreach($currency_units as $unit): ?>
                    <option {{ (isset($funding_data->min_investment_currency_units) && $funding_data->min_investment_currency_units == $unit->id) ? 'selected=selected' : '' }} value="{{$unit->id}}">{{$unit->units}} ({{$unit->amount}})</option>
                  <?php endforeach; ?>
              </select>
            </div>
          </div>
        
      </div>
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PI,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Add Your Pitch To Investors</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PIVD,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=PIVD')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=PIVD')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>  
            <div class="panel-body">
                        <span class="btn btn-success btn-file blue-btn">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Videos</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="assets_videos" type="file" name="assets_videos" multiple>
                        </span>
                          <p id="assets_videos_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="video_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="video_files" class="files">
                          @if($funding_assets_video)                          
                            @foreach($funding_assets_video as $video)
                              <div class="col-md-4">
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($video->access=='PUB')
                                      <a href="{{url('funding_assets_permision/'.$video->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('funding_assets_permision/'.$video->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('funding_assets_delete/'.$video->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                @if($video->processed==0)
                                  <img src="/uploads/processing.jpg" class="img-responsive ">
                                @else
                                  <img src="{{$video->thumb_img}}" iframe-src ="https://player.vimeo.com/video/{{$video->url}}" class="img-responsive popup">
                                @endif
                              </div>
                              @endforeach
                          @endif
                        </div>
                        <div class="clearfix"></div>
                        <!--<p class="help-block">Upload Video</p>-->
            </div>  
          </div>
        </div>  
      </div>
      @endif
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PI,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Add Your Pitch To Investors</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'PI,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=PI')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=PI')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>  
            <div class="panel-body">
                        <span class="btn btn-file blue-btn">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Images</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="assets_pics" type="file" name="assets_pics[]" multiple>
                        </span>
                          <p id="assets_pics_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="pics_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="pics_files" class="files">
                        @if($funding_assets_data)
                          @foreach($funding_assets_data as $asset)
                            @if($asset->type == 'IMAGES')
                              <div class="col-md-4">
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($asset->access=='PUB')
                                      <a href="{{url('funding_assets_permision/'.$asset->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('funding_assets_permision/'.$asset->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('funding_assets_delete/'.$asset->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                
                              </div>
                            @endif
                          @endforeach
                            <!--<p>{{$asset->name}} - <span class="removeTh text-danger" style="cursor:pointer" data-id="{{$asset->id}}" data-url="{{$asset->delete_url}}">remove</span>-->
                        @endif
                            <div class="clearfix"></div>
							<?php if(isset($asset->url)) { ?><img src="{{$asset->url}}" class="img-responsive"> <?php } ?>
                        </div>
                        <!--<p class="help-block">Upload pictures</p>-->
            </div>  
          </div>
        </div>                                  
      </div>
      @endif
      <div class="clearfix"></div>
      @if($prof_det->private || (isset($funding_data->private_permission) && strpos($funding_data->private_permission,'O,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Other Creative Assets</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($funding_data->private_permission) && strpos($funding_data->private_permission,'O,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?lock=O')}}"><i class="fa fa-unlock"></i></a>
                @elseif($funding_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$funding_data->id.'?unlock=O')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif

            </div>  
            <div class="panel-body">
                        <span class="btn btn-file blue-btn">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Files</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="assets_docs" type="file" name="assets_docs[]" multiple>
                        </span>
                          <p id="assets_docs_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="docs_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="doc_files" class="files">
                        @if($funding_assets_data)
                          @foreach($funding_assets_data as $asset)
                            @if($asset->type == 'DOCS')
                              {{--*/ $viewName = @end( @explode( '.', $asset->name ) ) /*--}}
                              @if($viewName=='doc')
                              {{--*/ $file_type='fa-file-word-o' /*--}}
                              @endif
                              @if($viewName=='docx')
                              {{--*/ $file_type='fa-file-word-o' /*--}}
                              @endif
                              @if($viewName=='pdf')
                              {{--*/ $file_type='fa-file-pdf-o' /*--}}
                              @endif
                              @if($viewName=='txt')
                              {{--*/ $file_type='fa-file-text-o' /*--}}
                              @endif
                              @if($viewName=='xls')
                              {{--*/ $file_type='fa-file-excel-o' /*--}}
                              @endif
                              @if($viewName=='xlsx')
                              {{--*/ $file_type='fa-file-excel-o' /*--}}
                              @endif
                              @if($viewName=='ppt')
                              {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                              @endif
                              @if($viewName=='pptx')
                              {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                              @endif
                              <div class="col-md-4">
                                <!--<div>{{$asset->name}}</div>-->
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($asset->access=='PUB')
                                      <a href="{{url('funding_assets_permision/'.$asset->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('funding_assets_permision/'.$asset->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('funding_assets_delete/'.$asset->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                <a target="_blank" href="{{asset('/download/funding_assets/'.$asset->id)}}"><i class="fa {{$file_type}} fa-3x"></i></a>
                              </div>
                            @endif
                          @endforeach
                            <!--<p>{{$asset->name}} - <span class="removeTh text-danger" style="cursor:pointer" data-id="{{$asset->id}}" data-url="{{$asset->delete_url}}">remove</span>-->
                        @endif
                            <div class="clearfix"></div>
                        </div>  
                        <!--<p class="help-block"> Upload documents</p>-->
            </div>  
          </div>
        </div>  
      </div>
      <div class="col-sm-6">
      </div>
      @endif
      @if($prof_det->private)
      <div class="col-md-12">
        <div class="form-group">
          <div class="row mtop20"> 
            <div class="col-sm-4 col-xs-6 col-sm-offset-4 raise-fund-save-btn-block"> 
              <button type="submit" id="fundFormSubmit" class="btn funding-save-btn">Save</button>
            </div>
            <!--<div class="col-sm-3 col-xs-6">
              <button type="button" onclick="javascript:location.href='{{ url('profiles', ['profile_id' => $prof_det->id]) }}'" class="btn btn-default">Cancel</button>
            </div>                                        -->
          </div>
        </div>
      </div>
      @endif
    </form>
    </div>  
    <!-- End of Raising Funding -->
    @elseif($funding==2)

    <!-- Funding Business -->
    <div class="col-sm-12 funding-block" id="funding2">
    <form method="post" id="fundForm2" name="fundForm" enctype="multipart/form-data" action="{{$action_url}}">
      <input type="hidden" name="_token" value="{{ csrf_token() }}">
      <input type="hidden" name="sel_funding_type" id="sel_funding_type" value="{{$funding}}">
      <input type="hidden" name="_fb_id" id="_fb_id" value="{{ ( isset($fb_data->id) ) ? $fb_data->id : 0 }}">
      <h3>Funding Business</h3><hr>

      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'BY,') ===false))
      <div class="col-md-4">
        <div class="form-group">
          <div class="panel panel-default">
            <div class="panel-heading">
              <label class="control-label">Years in business</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'BY,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=BY')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=BY')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>
            <div class="panel-body">
              <select class="form-control" id="years_in_business" name="years_in_business">
                <option value="">Years</option>
                <?php foreach($business_years as $year): ?>
                  <option {{ (isset($fb_data->years_in_business) && $fb_data->years_in_business == $year->id || isset($funding_year->years_in_business) && $funding_year->years_in_business == $year->id) ? 'selected=selected' : '' }} value="{{$year->id}}">{{$year->years}}</option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>                          
      </div>   
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'NB,') ===false))
      <div class="col-md-4">
        <div class="form-group">
          <div class="panel panel-default">
            <div class="panel-heading">
              <label class="control-label">Nature of business</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'NB,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=NB')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=NB')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>
            <div class="panel-body">
              <select class="form-control" id="financial_service" name="financial_service">
                <option value="0">Financial Services</option>
                <?php foreach($financial_services as $service): ?>
                  <option {{ (isset($fb_data->financial_service) && $fb_data->financial_service == $service->id) ? 'selected=selected' : '' }} value="{{$service->id}}">{{$service->name}}</option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>                          
      </div> 
      @endif  
@if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'UM,') ===false))
      <div class="col-md-8">
        <div class="form-group">
          <div class="panel panel-default">
            <div class="panel-heading">
              <label class="control-label">Assets Under Management</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'UM,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=UM')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=UM')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>
            <div class="panel-body">
              <div class="row">
                <div class="form-group">
                  <div class="col-md-4">
                    <input type="text" class="form-control funding-pg-input" name="revenue_det" id="revenue_det" placeholder="Revenue Details" <?php if(isset($fb_data->revenue_det) && $fb_data->revenue_det) echo 'value="'.$fb_data->revenue_det.'"';?>>
                  </div>
                  <div class="col-md-4">
                    <select class="form-control funding-pg-input" id="assets_currency" name="assets_currency">
                      <option value="">Currency</option>
                      <?php foreach($currency_all as $curreny): ?>
                        <option {{ (isset($fb_data->assets_currency) && $fb_data->assets_currency == $curreny->id) ? 'selected=selected' : '' }} value="{{$curreny->id}}">{{$curreny->name}}</option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                  <div class="col-md-4">
                    <select class="form-control funding-pg-input" id="assets_currency_units" name="assets_currency_units">
                      <option value="">Unit</option>
                      <?php foreach($currency_units as $unit): ?>
                        <option {{ (isset($fb_data->assets_currency_units) && $fb_data->assets_currency_units == $unit->id) ? 'selected=selected' : '' }} value="{{$unit->id}}">{{$unit->units}} ({{$unit->amount}})</option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                </div>
              </div>  
            </div>
          </div>
        </div>                            
      </div>  
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'MI,') ===false))
      <div class="clearfix"></div>
      <div class="col-md-12">
       
          <div class="row">
            <label class="col-sm-6 control-label">Minimum Investment Size (Per Investment)
              @if($prof_det->private)
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'MI,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=MI')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=MI')}}"><i class="fa fa-lock"></i></a>
                @endif
              @endif
            </label>
            <div class="col-sm-6">
              <label class="radio-inline">
                <input type="radio" name="min_inv" id="min_inv" value="Y" {{ (isset($fb_data->min_investment_currency) && $fb_data->min_investment_currency) ? 'checked="true"' : '' }}> Yes
              </label>
              <label class="radio-inline">
                <input type="radio" name="min_inv" id="min_inv" value="N" {{ (!isset($fb_data->min_investment_currency) || !$fb_data->min_investment_currency) ? 'checked="true"' : '' }}> No
              </label>
              <div id="min_inv_det" class="row {{ (!isset($fb_data->min_investment_currency) || !$fb_data->min_investment_currency) ? 'display-none' : '' }}">
           
              <div class="col-sm-4 form-group">
              <input type="text" class="form-control" id="min_investment_amt" name="min_investment_amt" value="<?php if(isset($fb_data->min_investment_amt)){echo $fb_data->min_investment_amt;} ?>">
              </div>
                <div class="col-sm-4 form-group">
                  <select class="form-control" id="min_investment_currency" name="min_investment_currency">
                    <option value="">Currency</option>
                      <?php foreach($currency_all as $curreny): ?>
                        <option {{ (isset($fb_data->min_investment_currency) && $fb_data->min_investment_currency == $curreny->id) ? 'selected=selected' : '' }} value="{{$curreny->id}}">{{$curreny->name}}</option>
                      <?php endforeach; ?>
                  </select>
                </div>
                <div class="col-sm-4 form-group">
                  <select class="form-control" id="min_investment_currency_units" name="min_investment_currency_units">
                    <option value="">Unit</option>
                      <?php foreach($currency_units as $unit): ?>
                        <option {{ (isset($fb_data->min_investment_currency_units) && $fb_data->min_investment_currency_units == $unit->id) ? 'selected=selected' : '' }} value="{{$unit->id}}">{{$unit->units}} ({{$unit->amount}})</option>
                      <?php endforeach; ?>
                  </select>
                </div>
              </div>            
            </div>
          </div>
       
      </div>
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'MX,') ===false))
      <div class="col-md-12">
       
          <div class="row">
            <label class="col-sm-6 control-label">Maximum Investment Size (Per Investment)
              @if($prof_det->private)
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'MX,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=MX')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=MX')}}"><i class="fa fa-lock"></i></a>
                @endif
              @endif
              </label>
            <div class="col-sm-6">
              <label class="radio-inline">
                <input type="radio" name="max_inv" id="max_inv" value="Y" {{ (isset($fb_data->max_investment_currency) && $fb_data->max_investment_currency) ? 'checked="true"' : '' }}> Yes
              </label>
              <label class="radio-inline">
                <input type="radio" name="max_inv" id="max_inv" value="N" {{ (!isset($fb_data->max_investment_currency) || !$fb_data->max_investment_currency) ? 'checked="true"' : '' }}> No
              </label>
              <div id="max_inv_det" class="row {{ (!isset($fb_data->max_investment_currency) || !$fb_data->max_investment_currency) ? 'display-none' : '' }}">
                <div class="col-sm-4 form-group">
              <input type="text" class="form-control" id="max_investment_amt" name="max_investment_amt" value="<?php if(isset($fb_data->max_investment_amt)){echo $fb_data->max_investment_amt;} ?>">
              </div>
                <div class="col-sm-4 form-group">
                  <select class="form-control" id="max_investment_currency" name="max_investment_currency">
                    <option value="">Currency</option>
                      <?php foreach($currency_all as $curreny): ?>
                        <option {{ (isset($fb_data->max_investment_currency) && $fb_data->max_investment_currency == $curreny->id) ? 'selected=selected' : '' }} value="{{$curreny->id}}">{{$curreny->name}}</option>
                      <?php endforeach; ?>
                  </select>
                </div>
                <div class="col-sm-4 form-group">
                  <select class="form-control" id="max_investment_currency_units" name="max_investment_currency_units">
                    <option value="">Unit</option>
                      <?php foreach($currency_units as $unit): ?>
                        <option {{ (isset($fb_data->max_investment_currency_units) && $fb_data->max_investment_currency_units == $unit->id) ? 'selected=selected' : '' }} value="{{$unit->id}}">{{$unit->units}} ({{$unit->amount}})</option>
                      <?php endforeach; ?>
                  </select>
                </div>
              </div>            
            </div>
         
        </div>
      </div>
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'IF,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Industry Focus (Select Multiple)
              @if($prof_det->private)
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'IF,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=IF')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=IF')}}"><i class="fa fa-lock"></i></a>
                @endif
              @endif
              </label>
            <div class="col-sm-6">
              <select multiple class="form-control" id="industry_focus" name="industry_focus[]" size="5">
                <option value="">Industry</option>
                <?php foreach($industries as $industry): ?>
                <?php 
                      $selected = '';
                    if(isset($fb_data->industry_focus) && preg_match("~\b".$industry->id."\b~",$fb_data->industry_focus))
                      $selected = 'selected=selected';
                ?>
                  <option {{$selected}} value="{{$industry->id}}">{{$industry->name}}</option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>
      </div>                                                        
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'POR,') ===false))
      <div class="col-md-12">
        <div class="form-group">
          <div class="row">
            <label class="col-sm-6 control-label">Your Current Portfolio
              @if($prof_det->private)
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'POR,') === false)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=POR')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/fb_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=POR')}}"><i class="fa fa-lock"></i></a>
                @endif
              @endif
              </label>
            <div class="col-sm-6">
              <?php
                $portfolio = array(0=>'');
                if(isset($fb_data->portfolio) && $fb_data->portfolio)
                  $portfolio = explode('||',$fb_data->portfolio);
              ?>
              <div class="row" id="append_fb_portfolio">
                <div class="col-sm-8">
                  <input type="text" name="portfolio[]" id="portfolio" class="form-control cur-port-f" value="{{$portfolio[0]}}">
                </div>
                <div class="col-sm-4">
                  <a href="javascript:void(0)" class="btn blue-btn btn-success" id="add_fb_portfolio"><i class="fa fa-plus" ></i> Add More</a>
                </div>
                <div class="clearfix"></div>
                <?php
                  $p = 0;
                  foreach($portfolio as $key=>$value):
                    if($p)
                    echo '<div class="form-group"><div class="col-sm-8"><input type="text" name="portfolio[]" id="portfolio" class="form-control cur-port-f" value="'.$value.'"></div><div class="col-sm-4"><span class="btn btn-success remove_fb_portfolio blue-btn remove-btn"><i class="fa fa-minus-circle"></i> Remove</span></div></div>';
                    $p++;
                  endforeach;
                ?>
              </div>  
            </div>    
          </div>
        </div>
      </div>
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'PI,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Add Your Pitch To Investors</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'PIVD,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=PIVD')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=PIVD')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>  
            <div class="panel-body">
                        <span class="btn btn-file blue-btn btn-success">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Videos</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="fb_assets_videos" type="file" name="assets_videos" multiple>
                        </span>
                          <p id="fb_assets_videos_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="fb_video_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="fb_video_files" class="files">
                          @if($fb_assets_video)                          
                            @foreach($fb_assets_video as $video)
                              <div class="col-md-4">
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($video->access=='PUB')
                                      <a href="{{url('fb_assets_permision/'.$video->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('fb_assets_permision/'.$video->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('fb_assets_delete/'.$video->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                @if($video->processed==0)
                                  <img src="/uploads/processing.jpg" class="img-responsive ">
                                @else
                                  <img src="{{$video->thumb_img}}" iframe-src ="https://player.vimeo.com/video/{{$video->url}}" class="img-responsive popup">
                                @endif
                              </div>
                              @endforeach
                          @endif
                        </div>
                        <div class="clearfix"></div>
                        <!--<p class="help-block">Upload Video</p>-->
            </div>  
          </div>
        </div>  
      </div>
      @endif
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'PI,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Add Your Pitch To Investors</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'PI,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=PI')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=PI')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif
            </div>  
            <div class="panel-body">
                        <span class="btn btn-file blue-btn btn-success">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Images</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="fb_assets_pics" type="file" name="assets_pics[]" multiple>
                        </span>
                          <p id="fb_assets_pics_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="fb_pics_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="fb_pics_files" class="files">
                        @if($fb_assets_data)
                          @foreach($fb_assets_data as $asset)
                            @if($asset->type == 'IMAGES')
                              <div class="col-md-4">
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($asset->access=='PUB')
                                      <a href="{{url('fb_assets_permision/'.$asset->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('fb_assets_permision/'.$asset->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('fb_assets_delete/'.$asset->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                <img src="{{$asset->url}}" class="img-responsive">
                              </div>
                            @endif
                          @endforeach
                            <!--<p>{{$asset->name}} - <span class="removeTh text-danger" style="cursor:pointer" data-id="{{$asset->id}}" data-url="{{$asset->delete_url}}">remove</span>-->
                        @endif
                            <div class="clearfix"></div>
                        </div>
                        <!--<p class="help-block">Upload pictures</p>-->
            </div>  
          </div>
        </div>                                  
      </div>
      @endif
      <div class="clearfix"></div>
      @if($prof_det->private || (isset($fb_data->private_permission) && strpos($fb_data->private_permission,'O,') ===false))
      <div class="col-sm-6">
        <div class="form-group">
          <div class="panel-default panel">                              
            <div class="panel-heading">
              <label class="control-label">Other Creative Assets</label>
              @if($prof_det->private)
                <div class="pull-right">
                @if(isset($fb_data->private_permission) && strpos($fb_data->private_permission,'O,') === false)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?lock=O')}}"><i class="fa fa-unlock"></i></a>
                @elseif($fb_data)
                  <a href="{{url('/funding_permision/'.$prof_det->id.'/'.$fb_data->id.'?unlock=O')}}"><i class="fa fa-lock"></i></a>
                @endif
                </div>
              @endif

            </div>  
            <div class="panel-body">
                        <span class="btn btn-file blue-btn btn-success">
                            <i class="glyphicon glyphicon-plus"></i>
                            <span>Upload Files</span>
                            <!-- The file input field used as target for the file upload widget -->
                            <input id="fb_assets_docs" type="file" name="assets_docs[]" multiple>
                        </span>
                          <p id="fb_assets_docs_error" class="error txt-red"></p>
                        <!-- The global progress bar -->
                        <div id="fb_docs_progress" class="progress">
                            <div class="progress-bar progress-bar-success"></div>
                        </div>
                        <!-- The container for the uploaded files -->
                        <div id="fb_doc_files" class="files">
                        @if($fb_assets_data)
                          @foreach($fb_assets_data as $asset)
                            @if($asset->type == 'DOCS')
                              {{--*/ $viewName = @end( @explode( '.', $asset->name ) ) /*--}}
                              @if($viewName=='doc')
                              {{--*/ $file_type='fa-file-word-o' /*--}}
                              @endif
                              @if($viewName=='docx')
                              {{--*/ $file_type='fa-file-word-o' /*--}}
                              @endif
                              @if($viewName=='pdf')
                              {{--*/ $file_type='fa-file-pdf-o' /*--}}
                              @endif
                              @if($viewName=='txt')
                              {{--*/ $file_type='fa-file-text-o' /*--}}
                              @endif
                              @if($viewName=='xls')
                              {{--*/ $file_type='fa-file-excel-o' /*--}}
                              @endif
                              @if($viewName=='xlsx')
                              {{--*/ $file_type='fa-file-excel-o' /*--}}
                              @endif
                              @if($viewName=='ppt')
                              {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                              @endif
                              @if($viewName=='pptx')
                              {{--*/ $file_type='fa-file-powerpoint-o' /*--}}
                              @endif
                              <div class="col-md-4">
                                <!--<div>{{$asset->name}}</div>-->
                                <div class="pull-right">
                                  @if($prof_det->private)
                                    @if($asset->access=='PUB')
                                      <a href="{{url('fb_assets_permision/'.$asset->id.'?access=lock')}}"><i class="fa fa-unlock"></i></a>
                                    @else
                                      <a href="{{url('fb_assets_permision/'.$asset->id.'?access=unlock')}}"><i class="fa fa-lock"></i></a>
                                    @endif
                                    <a href="javascript:void(0)" data-url="{{url('fb_assets_delete/'.$asset->id)}}" class="delete_assets" title="Delete"><i class="fa fa-trash-o"></i></a>
                                  @endif
                                </div>
                                <a target="_blank" href="{{asset('/download/fb_assets/'.$asset->id)}}"><i class="fa {{$file_type}} fa-3x"></i></a>
                              </div>
                            @endif
                          @endforeach
                            <!--<p>{{$asset->name}} - <span class="removeTh text-danger" style="cursor:pointer" data-id="{{$asset->id}}" data-url="{{$asset->delete_url}}">remove</span>-->
                        @endif
                            <div class="clearfix"></div>
                        </div>  
                        <!--<p class="help-block"> Upload documents</p>-->
            </div>  
          </div>
        </div>  
      </div>
      @endif
      <div class="col-sm-6">
      </div>

      <div class="col-md-12">
        <div class="form-group">
          <div class="row mtop20"> 
            <div class="col-sm-3 col-sm-offset-3"> 
              <button type="submit" id="fundFormSubmit" class="btn funding-save-btn">Save</button>
            </div>
            <!--<div class="col-sm-3 col-xs-6">
              <button type="button" onclick="javascript:location.href='{{ url('profiles', ['profile_id' => $prof_det->id]) }}'" class="btn btn-default">Cancel</button>
            </div>-->
          </div>
        </div>
      </div>

    </form>

    </div>                                             
    <!-- End of Funding Business -->
    @else
    <!-- No Funding -->
    <div class="col-sm-12 funding-block" id="funding0">
      <h3>No Funding</h3>
      <form method="post" id="nofundForm" name="nofundForm" enctype="multipart/form-data" action="{{$action_url}}">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <input type="hidden" name="sel_funding_type" id="sel_funding_type" value="{{$funding}}">
        @if($prof_det->private)
        <div class="col-md-12">
          <div class="form-group">
            <div class="row mtop20"> 
              <div class="col-sm-4 col-xs-6 col-sm-offset-4 raise-fund-save-btn-block"> 
                <button type="submit" id="fundFormSubmit" class="btn funding-save-btn">Save</button>
              </div>
            </div>
          </div>
        </div>
        @endif
      </form>  
    </div>                                             
    <!-- End of Funding -->
    @endif

  </div>
</div> 
