@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
      <div class="row">
        <div class="col-md-1"></div>
        <div class="col-md-10">
          <h1 class="heading">Specify your tags</h1>
          <p> You can detail your tags even further to get the best out of our search and collaboration features. 
            You will be able to do it later if you want.</p>
         <form method="post">   
          <div class="talent_specify talent-edit-specify">
            <ul class="row">
              @foreach($req_parent_data as $req)
              <li>
                <div class="col-sm-3">
                  <div class="btn-group">
                    <button data-toggle="dropdown" class="btn btn-info" type="button">{{$parent_data[$req]['name']}}</button>
                    <i class="fa fa-close remove_cat"></i><input type="hidden" name="req_parent_data[]" value="{{$req}}">
                  </div>
                </div>
                <div class="col-sm-3" id="div_cat_{{$req}}">
                    @if(isset($child_data[$req]))
                        <?php
                            $option='<option value="">Add Skills</option>';
                            foreach($child_data[$req] as $ch):
                              $option .='<option value="'.$ch['id'].'">'.$ch['name'].'</option>'; 
                            endforeach;
                        ?>
                        <select class="form-control input-lg btn-warning profile_select change_cat" name="sub_cat_{{$req}}[]" id="sub_cat_{{$req}}" data-parent="{{$req}}">
                           <?php echo $option; ?>   
                        </select>
                    @endif
                </div>
                <div class="col-sm-3" id="div_ind_{{$req}}">
                    @if(isset($child_data[$req]))
                        <?php
                            $option='<option value="">Add Industry</option>';
                            foreach($industry_data as $ind):
                              $option .='<option value="'.$ind->id.'">'.$ind->name.'</option>'; 
                            endforeach;
                        ?>
                        <select class="form-control input-lg btn-success profile_select change_industry" name="sub_industry_{{$req}}[]" id="sub_industry_{{$req}}" data-parent="{{$req}}">
                           <?php echo $option; ?>   
                        </select>
                    @endif
                </div>
                <div class="col-sm-3" id="div_role_{{$req}}">
                    @if(isset($child_data[$req]))
                        <?php
                            $option='<option value="">Add Role</option>';
                            foreach($roles_data as $r):
                              $option .='<option value="'.$r->id.'">'.$r->name.'</option>'; 
                            endforeach;
                        ?>
                        <select class="form-control input-lg btn-primary profile_select change_role" name="sub_role_{{$req}}[]" id="sub_role_{{$req}}" data-parent="{{$req}}">
                           <?php echo $option; ?>   
                        </select>
                    @endif
                </div>
                <div class="clearfix"></div>
              </li>
              @endforeach
            </ul>
            <div class="clearfix"></div>
          </div>
		  <div class="row">
          <div class="col-sm-12">
		  <div class="specify-tags-edit-btn">
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
           <!-- <div class="col-sm-3"> <button type="button" class="form-control">Previous</button></div>-->
             <input type="hidden" name="profile_save_type" id="profile_save_type" value="next">
           <!--<div class="col-sm-3"> <button type="submit" class="form-control" id="goto_profile" value="goto_profile">Goto Profile</button></div>-->
                @if(!Auth::user()->selected_profile || Auth::user()->profile_completed<Config::get('constants.'.Auth::user()->selected_profile.'_LIMIT'))  
                 <button type="button" class="btn add-new-btn" id="profile_step1" name="profile_step1" value="step1">Add New</button>
			    @endif
               <button type="button" class="btn cancel-btn" id="profile_cancel" name="profile_cancel" value="cancel">Cancel</button>
               <button type="submit" class="btn add-new-btn" id="profile_next" name="next" value="step2">Save</button>
          </div>
        </form>
        </div>
		</div>
      </div>
	  </div>
    </div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script type="text/javascript">
  var parent_cat = JSON.parse('<?php echo json_encode($parent_data);?>');
  var child_cat = JSON.parse('<?php echo json_encode($child_data);?>');
  //var roles = JSON.parse('<?php echo json_encode($roles_data);?>');
  var industry = JSON.parse('<?php echo json_encode($industry_data);?>');
  var roles = JSON.parse('<?php echo json_encode($roles_data);?>');
  var req_parent_cat = JSON.parse('<?php echo json_encode($req_parent_data);?>');
  var req_child_cat = JSON.parse('<?php echo json_encode($req_child_data);?>');
  var req_industry = JSON.parse('<?php echo json_encode($req_industry_data);?>');
  var req_roles = JSON.parse('<?php echo json_encode($req_roles_data);?>');

    $(document).on('change','.change_cat',function(){
    sel_category = $(this).val();
    if(sel_category=='remove')
    {
      $(this).remove();
      $('select#sub_cat_'+parent_id).each(function(){
            if($(this).val()=='')
            $(this).remove();
       });
    }  
      
    parent_id = $(this).attr('data-parent');
    parent_child_data = child_cat[parent_id];
    p_c_d_length = parent_child_data.length;
    d_c_length = $('select#sub_cat_'+parent_id).length;
    
        tempArray = new Array();
         $('select#sub_cat_'+parent_id).each(function(){
         // alert($.type(parseInt($(this).val())));
            tempArray.push(parseInt($(this).val()));
          });
          option ='<option value="">Add Skills</option>';
           selected_id=''; selected_value='';cate_next_option=0;
         $.each(parent_child_data, function(i, item) {
         // alert($.inArray(parent_child_data[i].id,tempArray));
            if($.inArray(parent_child_data[i].id,tempArray)===-1)
            {
              option=option+'<option value="'+parent_child_data[i].id+'">'+parent_child_data[i].name+'</option>';
              cate_next_option++;
              //alert(parent_child_data[i].name);
            }
            else if(sel_category==parent_child_data[i].id)
            {
              selected_id = parent_child_data[i].id;
              selected_value = parent_child_data[i].name;
            }
          });
         
         if(selected_value && selected_id)
         $(this).html('<option value="remove">Remove Skills</option><option value="'+selected_id+'" selected>'+selected_value+'</option>');

        if(cate_next_option>0)
        {
         select ='<select class="form-control input-lg btn-warning profile_select change_cat" name="sub_cat_'+parent_id+'[]" id="sub_cat_'+parent_id+'" data-parent="'+parent_id+'">'+option+'</select>';
         $("#div_cat_"+parent_id).append(select); 
        }
    //console.log(tempArray);
  });

$(document).on('change','.change_industry',function(){
    parent_id = $(this).attr('data-parent');
    sel_industry = $(this).val();

    if(industry[sel_industry] && industry[sel_industry].name ==='Other')
    {
      $("#div_ind_"+parent_id).append('<input type="text" class="form-control other_industry" name="sub_oindustry_'+parent_id+'[]" id="sub_oindustry_'+parent_id+'"  placeholder="Other Industry Value">');
    }

    if(sel_industry=='remove')
    {
      selected_data_id = $(this).attr('data-selected-id');
      
      if(industry[selected_data_id].name ==='Other')
      $('.other_industry').remove();
      
      $(this).remove();
      $('select#sub_industry_'+parent_id).each(function(){
            if($(this).val()=='')
            $(this).remove();
       });
    }  

      s_i_t_array = new Array(); //s_i_t_array : selected indutry temprary array;
        $('select#sub_industry_'+parent_id).each(function(){
            s_i_t_array.push(parseInt($(this).val()));
          });

        //console.log(s_i_t_array);
          industry_option ='<option value="">Add Industry</option>';      

          industry_next_option = 0;selected_ind_id=''; selected_ind_value='';
          $.each(industry, function(i, item) {
         // alert($.inArray(parent_child_data[i].id,tempArray));
              
            if($.inArray(industry[i].id,s_i_t_array)===-1)
            {
              industry_option=industry_option+'<option value="'+industry[i].id+'">'+industry[i].name+'</option>';
              industry_next_option++; 
              //alert(parent_child_data[i].name);
            }
            else if(sel_industry==industry[i].id)
            {
              selected_ind_id = industry[i].id;
              selected_ind_value = industry[i].name;
            }
          });

       if(selected_ind_value && selected_ind_id)
       {
        $(this).attr('data-selected-id',selected_ind_id);
        $(this).html('<option value="remove">Remove Industry</option><option value="'+selected_ind_id+'" selected>'+selected_ind_value+'</option>');
       }
       if(industry_next_option>0)   
       {
         industry_select ='<select class="form-control input-lg btn-success profile_select change_industry" name="sub_industry_'+parent_id+'[]" id="sub_industry_'+parent_id+'" data-parent="'+parent_id+'">'+industry_option+'</select>';

         $("#div_ind_"+parent_id).append(industry_select);
       }   
});
$(document).on('change','.change_role',function(){
    parent_id = $(this).attr('data-parent');
    sel_role = $(this).val();
    if(sel_role=='remove')
    {
      $(this).remove();
      $('select#sub_role_'+parent_id).each(function(){
            if($(this).val()=='')
            $(this).remove();
       });
    }  

    s_c_i_r_length = $('select#sub_role_'+parent_id).length; //s_c_i_r_length : selected category indutry role length

      s_r_t_array = new Array(); //s_r_t_array : selected role temprary array;
        $('select#sub_role_'+parent_id).each(function(){
            s_r_t_array.push(parseInt($(this).val()));
          });


        //console.log(s_r_t_array);
          roles_option ='<option value="">Add Role</option>';    
          selected_id=''; selected_value=''; roles_next_option=0;
          $.each(roles, function(i, item) {
            if($.inArray(roles[i].id,s_r_t_array)===-1)
            {
              roles_option=roles_option+'<option value="'+roles[i].id+'">'+roles[i].name+'</option>';
              roles_next_option++;
              //alert(parent_child_data[i].name);
            }
            else if(sel_role==roles[i].id)
            {
              selected_id = roles[i].id;
              selected_value = roles[i].name;
            }
          });

         if(selected_value && selected_id)
         $(this).html('<option value="remove">Remove Role</option><option value="'+selected_id+'" selected>'+selected_value+'</option>');

      if(roles_next_option>0) 
      {  
         roles_select ='<select class="form-control input-lg btn-primary profile_select change_role" name="sub_role_'+parent_id+'[]" id="sub_role_'+parent_id+'" data-parent="'+parent_id+'">'+roles_option+'</select>';
         $("#div_role_"+parent_id).append(roles_select); 
      }
  });
  function auto_select_category()
  {
    $.each(req_parent_cat, function(k, v) {
     
      cate = v; inner = ''; inner_industry=''; inner_roles=''; temp_selected_cat_id = new Array(); temp_selected_ind_id = new Array(); temp_selected_role_id = new Array();
      /* Creative */
      if(req_child_cat[v])
      {
        $("#div_cat_"+cate).html('');
        $.each(req_child_cat[v], function(l, m) {
           selected_id = req_child_cat[v][l].id;
           selected_value = req_child_cat[v][l].name;
           temp_selected_cat_id.push(selected_id);
           option = '<option value="remove">Remove Skills</option><option value="'+selected_id+'" selected>'+selected_value+'</option>';
           select ='<select class="form-control input-lg btn-warning profile_select change_cat" name="sub_cat_'+cate+'[]" id="sub_cat_'+cate+'" data-parent="'+cate+'">'+option+'</select>';
           inner = inner+select;
        });
        $("#div_cat_"+cate).html(inner);
        //console.log(temp_selected_cat_id);

           parent_child_data = child_cat[cate]; option ='<option value="">Add Skills</option>';
           $.each(parent_child_data, function(i, item) {
           // alert($.inArray(parent_child_data[i].id,tempArray));
              if($.inArray(parent_child_data[i].id,temp_selected_cat_id)===-1)
              {
                option=option+'<option value="'+parent_child_data[i].id+'">'+parent_child_data[i].name+'</option>';
                //alert(parent_child_data[i].name);
              }
            });
           
           select ='<select class="form-control input-lg btn-warning profile_select change_cat" name="sub_cat_'+cate+'[]" id="sub_cat_'+cate+'" data-parent="'+cate+'">'+option+'</select>';

           $("#div_cat_"+cate).append(select); 
      }

      /* End Creative*/   

      /* Industry*/
      if(req_industry[v])
      {
        $("#div_ind_"+cate).html('');
        //console.log(req_industry[v]);
        $.each(req_industry[v], function(l, m) {
         // console.log(l);
           selected_id = industry[m].id;
           selected_value = industry[m].name;
           temp_selected_ind_id.push(selected_id);
           industry_option = '<option value="remove">Remove Industry</option><option value="'+selected_id+'" selected>'+selected_value+'</option>';
           industry_select = '<select class="form-control input-lg btn-success profile_select change_industry" name="sub_industry_'+cate+'[]" id="sub_industry_'+cate+'" data-parent="'+cate+'" data-selected-id="'+selected_id+'">'+industry_option+'</select>';
           inner_industry = inner_industry+industry_select;
        });

        $("#div_ind_"+cate).html(inner_industry);

            industry_option ='<option value="">Add Industry</option>';      

            $.each(industry, function(i, item) {
           // alert($.inArray(parent_child_data[i].id,tempArray));
                
              if($.inArray(industry[i].id,temp_selected_ind_id)===-1)
              {
                industry_option=industry_option+'<option value="'+industry[i].id+'">'+industry[i].name+'</option>';
                //alert(parent_child_data[i].name);
              }
            });

           
           industry_select = '<select class="form-control input-lg btn-success profile_select change_industry" name="sub_industry_'+cate+'[]" id="sub_industry_'+cate+'" data-parent="'+cate+'">'+industry_option+'</select>';

           $("#div_ind_"+cate).append(industry_select); 
      }    
      /* End Industry*/

      /*Roles*/
      if(req_roles[v])
      {
        $("#div_role_"+cate).html('');
        $.each(req_roles[v], function(l, m) {
           selected_id = roles[m].id;
           selected_value = roles[m].name;
           temp_selected_role_id.push(selected_id);
           roles_option = '<option value="remove">Remove Role</option><option value="'+selected_id+'" selected>'+selected_value+'</option>';
           roles_select = '<select class="form-control input-lg btn-primary profile_select change_role" name="sub_role_'+cate+'[]" id="sub_role_'+cate+'" data-parent="'+cate+'">'+roles_option+'</select>';
           inner_roles = inner_roles+roles_select;
        });

        $("#div_role_"+cate).html(inner_roles);

            roles_option ='<option value="">Add Role</option>';    
            $.each(roles, function(i, item) {
              if($.inArray(roles[i].id,temp_selected_role_id)===-1)
              {
                roles_option=roles_option+'<option value="'+roles[i].id+'">'+roles[i].name+'</option>';
                //alert(parent_child_data[i].name);
              }
            });

           roles_select ='<select class="form-control input-lg btn-primary profile_select change_role" name="sub_role_'+cate+'[]" id="sub_role_'+cate+'" data-parent="'+cate+'">'+roles_option+'</select>';
           $("#div_role_"+cate).append(roles_select); 
      }     
      /*End Roles*/

    });
  }
  auto_select_category();

  if($("#profile_step1").length)
  {
     $(document).on('click','#profile_step1',function(){
        location.href="{{url('/profile/step1/'.$profile_id)}}";
     }); 
  }

  if($("#profile_cancel").length)
  {
     $(document).on('click','#profile_cancel',function(){
        location.href="{{url('/profiles/'.$profile_id)}}";
     }); 
  }
</script>

@endsection
