@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('css/datepicker.css')}}" rel="stylesheet">

@endsection


@section('content')
<section class="main_content">
    <div class="container">
      <div class="no-breadcrumb"></div>
      <div class="row">
          <div class="col-md-12">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          
           @if (count($errors) > 0)
                <div class="alert alert-danger">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                 </button>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif 
          </div>
        </div>
      <div class="row talent_home">
        
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
            
            @if (Session::has('message'))

            <p>{{ Session::get('message') }}</p>

            @endif


 
 

       
          <div class="row talent_data mtop-0">
            <h1 class="heading ac-set-head">Account Settings</h1>
              <form class="" name="profile" id="account_settings"  method="post" action="{{ url('user/account_settings') }}">
          <div class="form">
      
     @foreach($user_info as $social_data)
            <div class="col-sm-12">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Full Name / Business Name" name="name" value="{{ isset($social_data->name) ? $social_data->name:'' }}">
              </div>
            </div>
               <?php 
                        $gender ="";
                        if(isset($social_data->gender))
                        {
                            
                            $gender = $social_data->gender;
                        }
                ?>
           <div class="clearfix"></div>
           
            <div class="col-sm-6">
              <div class="form-group">
                  <input type="text" class="form-control" placeholder="City" name="city" value="{{ isset($social_data->city) ? $social_data->city:'' }}">
              </div>
            </div>
              
            <div class="col-sm-6">
              <div class="form-group">
                  <input readonly type="text" class="form-control" placeholder="Email Address" name="email" value="{{ isset($social_data->email) ? $social_data->email:'' }}">
                   <input type="hidden" name="_token" value="{{ csrf_token() }}">
                   <input type="hidden" name="selected_profile" value="<?php if(isset($social_data->selected_profile))echo $social_data->selected_profile; ?>">
              </div>
            </div> 
           
            <div class="clearfix"></div>
            
            <div class="col-sm-6">
              <div class="form-group">
                  <input readonly type="text" class="form-control" placeholder="Username" name="username" value="{{ isset($social_data->username) ? $social_data->username:'' }}">
                 
              </div>
            </div>  
           @if(isset($social_data->selected_profile) && $social_data->selected_profile=='O')
            <div class="col-sm-6">
              <div class="form-group">
                  <select name="years_in_business" class="form-control" id="years_in_business">   
                       <option value="">Years In Business</option>
                       <?php foreach($business_years as $year): ?>
                       <option {{ (isset($social_data->years_in_business) && $social_data->years_in_business == $year->id) ? 'selected=selected' : '' }} value="{{$year->id}}">{{$year->years}}</option>
                       <?php endforeach; ?>
                   </select>
              </div>
            </div>
           @endif
           @if(isset($social_data->selected_profile) && $social_data->selected_profile=='T')
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Date of birth" name="dob" value="{{ isset($social_data->dob) ? date('m/d/Y', strtotime($social_data->dob)):'' }}" id="example1" readonly>
              </div>
            </div>
           
            <div class="clearfix"></div> 
              
            <div class="col-sm-6">
              <div class="form-group">
                 <select name="gender" class="form-control">
                     
                    <option value="">Gender</option>
                    <option value="M" {{ ($gender!="" && $gender=='M') ? 'selected':'' }}>Male</option>
                    <option value="F" {{ ($gender!="" && $gender=='F') ? 'selected':'' }}>Female</option>
                     
                </select>
              </div>
            </div>
            @endif
<!--            <div class="clearfix"></div>
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Facebook ID" name="fb_id" value="{{ isset($social_data->fb_id) ? $social_data->fb_id:'' }}">
              </div>
            </div>
             <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="LinkedIn ID" name="linked_id" value="{{ isset($social_data->linked_id) ? $social_data->linked_id:'' }}">
              </div>
            </div>-->
             @endforeach   

           <div class="col-sm-12">
                <div class="sm-update-btns">
               <div class="col-sm-3 pull-right xs-clear mtop5"> <button type="button" class="form-control btn btn-primary " id="profile_cancel" name="profile_cancel" value="cancel">Cancel</button></div>
              <div class="col-sm-3 pull-right xs-clear mtop5">  <button type="submit" class="form-control pull-right btn btn-primary" name="Update" id="signup_submit" value="Update">Update</button></div>
                </div>
                <div class="clearfix"></div>
                <div class="xs-update-btns">
                <div class="col-sm-3 pull-right xs-clear mtop5">  <button type="submit" class="form-control pull-right btn btn-primary" name="Update" id="signup_submit" value="Update">Update</button></div>
                   <div class="clearfix"></div>
                <div class="col-sm-3 pull-right xs-clear mtop5"> <button type="button" class="form-control btn btn-primary " id="profile_cancel" name="profile_cancel" value="cancel">Cancel</button></div>
             
                </div>
            </div>
          </div>
        </form>       
          </div>
       </div>
      </div>
    </div>
  </section>
  
  @endsection
  

@section('js')

<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
 <script src="{{asset('js/bootstrap-datepicker.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
$(document).on('click','#profile_cancel',function(){
        location.href="{{url('myaccount')}}";
     }); 
     
var date = new Date();
var currentMonth = date.getMonth();
var currentDate = date.getDate();
var currentYear = date.getFullYear();
$('#example1').datepicker({
    format: "mm/dd/yyyy",
maxDate: new Date(currentYear, currentMonth, currentDate-1),
}).on('changeDate', function (ev) {
    $(this).datepicker('hide');
});;

})
</script>
@endsection
