@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
  <div class="container">
  <ol class="breadcrumb cust-breadcrumb">
            <li><a href="{{url('/')}}">Home</a></li>
            <li class="active">My Views</li>
          </ol>
    <div class="row talent_home">
      @include("left_menu")
      <div class="col-md-9 col-sm-8"> 
       
       
        @if (Session::get('error_msg'))
        <div class="col-md-12">
          <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
            {{Session::get('error_msg')}}
          </div>
        </div>
        @endif
        <div class="row talent_data mtop-0" id="myviews-index">
         <h2 class="oraganization-view-head">My Views</h2>
          <div class="col-md-12">
         <div class="table-responsive visible-360">
            <table id="users-profileview-table" class="table table-bordered zui-table zui-table-rounded org_my-v-table ">
              <thead>
                <tr>
                  <th>Organization</th>
                  <th>Type</th>
                  <th>Country</th>
                  <th>IP</th>
                  <th>Page Views</th>
                </tr>
              </thead>
            </table>   </div>       
          </div>
          <div class="clearfix"></div><br /><br />
          <div class="col-md-12 chart-pane">
            <div class="col-md-4"><h4><span>{{$view_count_90}}</span> <strong>Profile Views</strong><br />Last 90 Days</h4></div>
            <div class="col-md-4"><h4><span>{{$view_count_60}}</span> <strong>Profile Views</strong><br />Last 60 Days</h4></div>
            <div class="col-md-4"><h4><span>{{$view_count_60}}</span> <strong>Profile Views</strong><br />Last 30 Days</h4></div>
            <div class="clearfix mtop5"></div>
            <div class="visitors-chart" style="height: 230px;width:100%;margin-top:15px; margin-bottom:15px;"></div>            
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
@endsection

@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>

<!-- Charts plugins -->
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.time.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.axislabels.js')}}"></script>    
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.grow.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.pie.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.resize.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.tooltip_0.4.4.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.orderBars.js')}}"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/charts/sparkline/jquery.sparkline.min.js')}}"></script><!-- Sparkline plugin -->
<script type="text/javascript" src="{{ asset('admin/plugins/charts/knob/jquery.knob.js')}}"></script><!-- Circular sliders and stats -->    

<script type="text/javascript">
    function gd(year, month, day) {
        return new Date(year, month - 1, day).getTime();
    }
    var chartColours = ['#88bbc8', '#ed7a53', '#9FC569', '#bbdce3', '#9a3b1b', '#5a8022', '#2c7282'];

    // document ready function
    $(document).ready(function() {
      
      //profile month wise data
      var mt_data = '[';
      @foreach ($chart_data as $prof_data)
        mt_data += '[gd( {{$prof_data->y }}, {{ $prof_data->m }}, 1 ), {{ $prof_data->total_views }}],';
      @endforeach
      mt_data += ']';


      var divElement = $('div'); //log all div elements

      //------------- Visitor chart -------------//
      if (divElement.hasClass('visitors-chart')) {

        var d1 = eval('(' + mt_data + ')');

        //define placeholder class
        var placeholder = $(".visitors-chart");
        //graph options
        var monthOfYear = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        var options = {
            grid: {
              show: true,
                aboveData: true,
                color: "#3f3f3f" ,
                labelMargin: 5,
                axisMargin: 0, 
                borderWidth: 0,
                borderColor:null,
                minBorderMargin: 5 ,
                clickable: true, 
                hoverable: true,
                autoHighlight: true,
                mouseActiveRadius: 20
            },
            series: {
              grow: {
                active: false,
                stepMode: "linear",
                steps: 50,
                stepDelay: true
              },
                lines: {
                  show: true,
                  fill: true,
                  lineWidth: 4,
                  steps: false
                  },
                points: {
                  show:true,
                  radius: 5,
                  symbol: "circle",
                  fill: true,
                  borderColor: "#fff"
                }
            },
            legend: { 
              position: "ne", 
              margin: [0,-25], 
              noColumns: 0,
              labelBoxBorderColor: null,
              labelFormatter: function(label, series) {
              // just add some space to labes
              return label+'&nbsp;&nbsp;';
           }
          },
          yaxis: { tickDecimals: 0 },
          //xaxis: {ticks:11, tickDecimals: 0},
          xaxes: [ { 
            mode: "time", 
            tickSize: [1, "month"], 
          }],
          colors: chartColours,
          shadowSize:1,
          tooltip: true, //activate tooltip
          tooltipOpts: {
            content: "%s : %y.0",
            shifts: {
              x: -30,
              y: -50
            }
          }
        };   
      
        $.plot(placeholder, [ 
        
          {
            label: "Views", 
            data: d1,
            lines: {fillColor: "#f2f7f9", fill: false},
            points: {fillColor: "#88bbc8"}
          }, 

        ], options);
              

      }//end if  


    $('#users-profileview-table').DataTable({
      "language": {
        "emptyTable":     "No messages in profile view"
    },
	  processing: true,
      serverSide: true,
      ajax: '/myviews/dt_profileviews',
      filter: false,
      columns: [
        {data: 'organization', name: 'Organization', width:'25%', orderable: false, searchable: false},
        {data: 'type', name: 'type', width:'25%', orderable: false, searchable: false},
        {data: 'country', name: 'Country', width:'25%', orderable: false, searchable: false},
        {data: 'ip', name: 'IP', width:'25%', orderable: false, searchable: false},
        {data: 'pageviews', name: 'Page Views', width:'25%', orderable: false, searchable: false}
      ]
    });

    });//End document ready functions   

    if($("#auth_profile").length)
    {
        $(document).on("change","#auth_profile",function(){
            $("#authProfileForm").submit();
        });
    }
</script>   
@endsection
