@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/mylikes')}}">My Likes</a></li>
              <li class="active">   
                                    @if($like_type=='P')
                                    Profiles
                                    @endif
                                    @if($like_type=='I')
                                    Pictures
                                    @endif
                                    @if($like_type=='V')
                                    Videos
                                    @endif
                                    @if($like_type=='R')
                                    Resumes
                                    @endif
                                </li>
            </ol>
              <div class="row">
          <div class="col-md-12">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
        </div>
		
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8 "> 
            
             <h1 class="heading mtop-0 mylikes-head">
                                    @if($like_type=='P')
                                    Profiles
                                    @endif
                                    @if($like_type=='I')
                                    Pictures
                                    @endif
                                    @if($like_type=='V')
                                    Videos
                                    @endif
                                    @if($like_type=='R')
                                    Resumes
                                    @endif
                                </h1>
            <div class="clearfix"></div>
            <div class="mtop-0" id="mylikes_div">
            
             @if($likes->count() > 0)
             @foreach($likes as $lik)
            <div class="col-md-4  findsiz mylike_nopad col-sm-6 mbot10">
             @if($lik->asset_type!='R')<div class=" mylikes-pic"><div class="col-sm-12">@endif
			 @if($lik->asset_type=='R')<div class=" row myresume-view-block resumw-margin"><div class="resume-bg-block">@endif
                      
					  
					 
                       @if($like_type=='P')
                        @if($lik->assets_path && is_file('../uploads/profile_images/'.$lik->assets_path))
                        <img class="pro_pic img-responsive" src="{{url('../uploads/profile_images/'.$lik->assets_path)}}" alt=""/>
                      @else                    
                        <img class="pro_pic img-responsive" src="{{url('../uploads/profile_images/default-profile.png')}}" alt=""/>
                      @endif
                      <input type="hidden" value="{{$like_type}}" class="like_type">
                      @endif
                      @if($lik->asset_type=='V')
                       <img src="{{$lik->thumb_img}}" iframe-src ="https://player.vimeo.com/video/{{$lik->assets_path}}" class="img-responsive popup">
                       <input type="hidden" value="{{$lik->asset_type}}" class="like_type">
                      @endif
                       @if($lik->asset_type=='I')
                     <a href="javascript:;"><img class="img-responsive view_btn" data-id="{{$lik->id}}"  data-title="{{$lik->assets_name}}" data-url="../images/{{$lik->assets_path}}" src="../images/{{$lik->assets_path}}"  alt=""/></a>
                      <input type="hidden" value="{{$lik->asset_type}}" class="like_type">
                       @endif
                       @if($lik->asset_type=='R')
                       <input type="hidden" value="{{$lik->asset_type}}" class="like_type">
                   {{--*/ $viewName = @end( @explode( '.', $lik->assets_path ) ) /*--}}
                      @if($viewName=='txt')
                      {{--*/ $addfile='../images/text.png' /*--}}
                      @endif
                      @if($viewName=='doc')
                      {{--*/ $addfile='../images/doc.png' /*--}}
                      @endif
                      @if($viewName=='docx')
                      {{--*/ $addfile='../images/docxs.png' /*--}}
                      @endif
                      @if($viewName=='pdf')
                      {{--*/ $addfile='../images/pdfs.png' /*--}}
                      @endif
                       @if($viewName=='xls')
                      {{--*/ $addfile='../images/xlss.png' /*--}}
                      @endif
                       @if($viewName=='xlsx')
                      {{--*/ $addfile='../images/xlsxs.png' /*--}}
                      @endif
                       @if($viewName=='rtf')
                      {{--*/ $addfile='../images/rtfs.png' /*--}}
                      @endif
                       <div class="resume-type-img"> <a href="{{URL::to('res_download', array($lik->asst_id))}}">  <img class="img-responsive" src="{{$addfile}}"  alt=""/></a></div>
                    @endif
                  </div>
                  <div class="clearfix"></div>
               <div class="row mylikes-icons-block"> <div class="col-sm-8 col-xs-6"> <h4 title="{{$lik->assets_name}}">{{ str_limit($lik->assets_name, $limit = 10, $end = '.....') }}</h4>
                      </div>
<div class="col-sm-4 col-xs-6"><div class="mylikes-pic-icons"><span><a href="{{ URL::to('profiles', array($lik->profile_id)) }}" title="View Profile"><i class="fa fa-eye"></i></a></span><span class="delete-icon"><a  href="javascript:void(0)" data-id="{{$lik->id}}"  class="chk_del" title="Delete Like"><i class="fa fa-trash-o"></i></a></span></div></div>
                               </div> </div>
            </div>
              @endforeach 
          @else 
             <div class="col-md-6 col-xs-6 findsiz mylike_nopad">
              <h4>No @if($like_type=='P') Profiles @else @if($like_type=='I') Pictures @else @if($like_type=='V') Videos @else @if($like_type=='R') Resumes @endif @endif @endif @endif Found</h4>
             </div>
          @endif
           
          </div>
            <div id="LoadingImage" style="display: none;">
                  <img class="img-responsive" src="../images/spin.gif" width="120" height="120" alt=""/>
                  </div>
                  <input type="hidden"  id="numrows" value="{{$numrows}}">
                  <input type="hidden"  id="maxlimit" value="{{$maxlimit}}">
                  <input type="hidden" name="_token" value="{{ Session::getToken() }}">
                 
        </div>
        
            <div class="col-md-3 col-sm-4"></div>
                <div class="col-md-9 col-sm-8 mtop10">
             @if($numrows>$maxlimit)
              <div class="col-sm-4 col-md-offset-4">
             <button  class="btn mypics-more-btn" id="picture_next">More</button>
              </div>
             @endif
                </div>
      
       
      </div>
    </div>
  </section>
@endsection

<!-- Modal -->
<div class="modal fade" id="popup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
         <iframe src="" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen width="600" height="400" id="modal-iframe"></iframe>
      <div class="modal-footer video-model-foot">
          
        <button type="button" class="btn-close btn delete-btn clear_form pull-right" id="modal-close" >Close</button>
      </div>
    </div>
  </div>
</div>

<div id="view_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title img-name"></h4>
                    </div>
                    <div class="modal-body">
                      <div class="form-horizontal">
                          <div class="form-group">
                               <div class="col-sm-12 text-center"><img src="" class="img-elem img-responsive"></div>
                          </div>
                          <div class="form-group">
                              <div class="col-md-12">
                                  <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                              </div>
                          </div>
                      </div>          
                   </div><!-- End of Modal body -->
            </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal --> 

@section('js')
@section('js')

<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>

<script type="text/javascript">
$(document).ready(function()
{
      
       
   $('#picture_next').click(function(){
       
       var numlikes=parseInt($("#numrows").val());
       var maxlimit=parseInt($("#maxlimit").val());
       if(numlikes<=maxlimit){$('#picture_next').css("display", "none");}
        
       $("#LoadingImage").show();
       
       var findsiz= parseInt($(".findsiz").length);
       var divsiz=maxlimit;
       var like_type=$('.like_type').val();//alert(like_type);
       if(numlikes<=divsiz){$('#picture_next').css("display", "none");}
       var dataString = 'likes_type='+ like_type + '&take='+ divsiz +'&skip='+ findsiz +'&_token=' + $("input[name=_token]").val();
           $.ajax({
                    type: "POST",
                    url : "/likeslimit",
                    data : dataString,
                    dataType: "JSON",
                    success : function(data){
                       var append_data = '';
                       var title='';
                       var image_path='';
                       var viewName='';
                       var addfile='';
                      $.each(data,function(key,val){
                        if(like_type=='P')
                          { 
                             var title='My Profiles';
                             if(val.assets_path!="")
                             {
                             var image_path='<img class="img-responsive" src="../uploads/profile_images/'+val.assets_path+'" alt=""/>';
                              }
                              else 
                              {
                              var image_path='<img class="img-responsive" src="../uploads/profile_images/default-profile.png" alt=""/>';
                              }
                          }  
                     if(like_type=='R')
                     {
                      var viewName=val.assets_path.split('.').pop();
                      if(viewName=='txt')addfile='../images/text.png';
                      if(viewName=='doc')addfile='../images/doc.png';
                      if(viewName=='docx')addfile='../images/docxs.png';
                      if(viewName=='pdf')addfile='../images/pdfs.png';
                      if(viewName=='xls')addfile='../images/xlss.png';
                      if(viewName=='xlsx')addfile='../images/xlsxs.png';
                      if(viewName=='rtf')addfile='../images/rtfs.png';
                      var title='My Resumes';
                      var image_path='<a href="{{url("res_download/")}}/'+val.asst_id+'"><img class="img-responsive" src="'+addfile+'"  alt=""/></a>';
                     
                     }
                          
                          if(like_type=='I')
                          { 
                             var title='My Pictures';
                             var image_path='<a href="javascript:;"><img class="img-responsive view_btn" data-id="'+val.id+'" data-title="'+val.assets_name+'" data-url="../images/'+val.assets_path+'" src="../images/'+val.assets_path+'" alt=""/></a>';
                          }
                          
                        if(like_type=='V')
                        { 
                            
    
                         var title='My Videos';
                         var image_path='<img src="'+val.thumb_img+'" iframe-src ="https://player.vimeo.com/video/'+val.assets_path+'" class="img-responsive popup">';
                     
                     }
                       
                       var txt_name = val.assets_name;
                       var pic_title=val.assets_name;
                        if(txt_name.length > 15)
                        {
                          txt_name = txt_name.substr(0,15) + "....";
                        }
                           
                        
                          append_data=append_data+'<div class="col-md-4  findsiz mylike_nopad col-sm-4 mbot10"><div class=" mylikes-pic"><div class="col-sm-12">'+image_path+'</div><div class="clearfix"></div><div class="row mylikes-icons-block"><div class="col-sm-8 col-xs-6"><h4 title="'+pic_title+'">'+txt_name+'</h4></div><div class="col-sm-4 col-xs-6"><div class="mylikes-pic-icons"><span><a href="{{url("profiles/")}}/'+val.profile_id+'" title="View Profile"><i class="fa fa-eye"></i></a></span><span class="delete-icon"><a  href="javascript:void(0)" data-id="'+val.id+'"  class="chk_del" title="Delete Like"><i class="fa fa-trash-o"></i></a></span></div></div></div></div></div>';
                         
                       });
                       if(!$(".findsiz").length)$('#mylikes_div').html('');
                       $('#mylikes_div').append(append_data);
                       if(numlikes>$(".findsiz").length){$('#picture_next').show();}else{$('#picture_next').hide();}
                       $("#LoadingImage").hide();
                    
                   }
                });
    
    });
    
   $("#modal-close").click(function(){
        $('#modal-iframe').attr('src',"");
        $('#popup').modal('hide');
    })
    
 $(document).on('click','.popup',function(){
       $('#modal-iframe').attr('src',$(this).attr('iframe-src'));
       $('#popup').modal('show');
 });
    
}); 
 $(document).on('click','.chk_del',function(){
    var pic_id = $(this).attr("data-id");//alert(pic_id);
   
    bootbox.confirm("Are you sure, you want to delete this?", function(result) {
      if(result)
      location.href = '{{url("mylikes/")}}/'+pic_id+"/delete";
    });  
  });

 $(function(){
    if($('.view_btn').length)
  {
    $(document).on('click','.view_btn',function(){
         var atr_val=$(this).attr('data-id');
         var atr_name=$(this).attr('data-title');
      $('#view_modal').modal('show');
       $('#view_modal .img-name').html(atr_name);
      $('#view_modal .img-elem').attr('src', $(this).attr('data-url'));
      $('#view_modal .assets_id_elem').val($(this).attr('data-id'));
        
         var dataString = 'atr_val='+ atr_val +  '&_token=' + $("input[name=_token]").val();
        
            $.ajax({
                              type: "POST",
                              url : "picture_view",
                              data : dataString,
                              success : function(data){//alert(data);
                              }
                          },"json");
                          
     
    });
  }
});
</script>
@endsection
