@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection

@section('content')

    <div class="container">
	<!---breadcurmb starts here-->
  <ol class="breadcrumb cust-breadcrumb">
  <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/messages')}}">Messages</a></li>
            @if (!$msg_details->folder=='Inbox') <li><a href="{{url('message/'.$msg_details->folder)}}">{{ucwords($msg_details->folder)}}</a></li>@endif
              <li class="active">View Message</li>
  </ol><!---breadcurmb ends here-->
   <div class="row">

  <div class="clearfix"></div>
  @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
</div>
  <section class="body-content"> 
  <div class="row">
  @include("left_menu")
	<div class="col-sm-9 light-pannel">
<div class="rt-panel-block">
<div class="my-profiles-block"> 
<div class="inbox-block">
<div class="row">

			   
<div class="col-sm-5 col-md-7 col-lg-8"><h1 class="innerpage-heading">{{ucwords($msg_details->title)}}</h1></div>
<div class="col-sm-7 col-md-5 col-lg-4">	
<div class="inbox-action-btns">
<button class="btn compose-btn" id="compose_message">Compose Message</button>
<button class="btn delete-btn delete" data-id="{{$msg_details->delete_id}}">
<i class="glyphicon glyphicon-trash"></i> Delete</button>
</div>
</div>
</div>
<div class="panel panel-default custom-panel">
  <div class="panel-heading">
    <h3 class="panel-title messenger-name">{{ucwords($msg_details->user_det)}}</h3>
  </div>
  <div class="panel-body">
   <p class="view-msg-subject"> <?php echo nl2br($msg_details->msg_content);?></p>
   <p class="mesg-time-stamp"><?php echo date('h:i a  M d, Y',strtotime($msg_details->created_at));?></p>
  </div>
  <div class="clearfix"></div>
</div>
@if($msg_details->folder=='inbox') 
<div class="inbox-action-btns">
<button id="reply_message" class="btn delete-btn mbot-10"><i class="fa fa-reply-all"></i> Reply</button>
</div>
@endif 
<!--view message block--->
</div><!---right panel inner block--->
 <div class="clearfix"></div>
 </div>
</div>
 </div>  
  
  </div><!---page row ends-->
  
  

<!-- Profile  Image Modal -->
    <div id="compose_message_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Compose Message</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="replyMessageForm" name="replyMessageForm" action="{{url('message/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
               <input type="hidden" name="msg_id" id="msg_id">
              <div class="form-group">
                <label class="col-sm-2 control-label" >To<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Subject<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Message<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <textarea name="message" id="message" class="form-control" rows="10"></textarea>
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-sm-2"></div>
                  <div class="col-md-10">
                      <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn compose-btn">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal -->        
    @if($msg_details->folder=='inbox')
<!-- Reply Message Modal -->
    <div id="reply_message_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Reply Message</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="composeMessageForm" name="composeMessageForm" action="{{url('message/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id" value="{{$msg_details->sender_profile_id}}">
              <input type="hidden" name="msg_id" id="msg_id" value="{{$msg_details->id}}">
              <div class="form-group">
                <label class="col-sm-2 control-label" >To<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <input type="text" name="to" id="to" class="form-control" data-bv-field="to" readonly="readonly" value="{{ucwords($msg_details->user_det)}}">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Subject<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject" value="<?php if (stristr($msg_details->title, "Re:")){echo '';}else{echo 'Re:';} ?>{{ucwords($msg_details->title)}}">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Message<span class="reqired-val">*</span></label>
                <div class="col-sm-10">
                    <textarea name="message" id="message" class="form-control" rows="10">
                      &#10; &#10;&#10;_____________________________________________________________________ &#10; On {{date('D, M d,Y @ h:i a',strtotime($msg_details->updated_at))}}, {{ucwords($msg_details->user_det)}} wrote:&#10;{{$msg_details->msg_content}}                      
                    </textarea>
                      <input type="hidden" name="update" value="update">
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-sm-2"></div>
                  <div class="col-md-10">
                      <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn compose-btn">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Reply Message Modal -->        
    @endif
	
	</div>
	</div>
	</div>	
  </section>
  
  <div>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/messages_js.js')}}"></script>
@endsection
