@extends('main')
@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection
@section('content')
<section class="main_content">
    <div class="container">
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8 talent_custom_search">
          <div id="render-this">
            <h1 class="heading pull-left">Mentor/Mentee</h1>         
            <div class="row">
            @if (Session::get('error_msg'))
                <div class="alert alert-danger clearfix">
                   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>                  
                </div>
            @endif
                @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
              <div class="col-md-12">
                  <div id="connectionmsg" >
                      @if(isset($_GET['data']))
                      <p class='alert alert-success clearfix'>                
                          {{$_GET['data']}}                
                      </p>
                      @endif
                  </div>
                  <div class="clearfix"><br></div>
                  
           <div class="table-responsive visible-360">
                    <table id="userstable" class="display responsive nowrap  table-bordered zui-table zui-table-rounded table my-conncetions-table m-mentor">
                  <thead>
                    <tr>
                      <th>Name</th>
                      <th>Subject</th>
                      <th>Date</th>
                    </tr>
                    @if(count($res_all)==0)
                    <tr>
                        <td colspan="3" align="center">No New Message</td>                      
                    </tr>
                    @endif
                    @foreach($res_all as $rows)                  
                    <tr>
                        @if($rows['status']=="0")
                        <td><a href="#"><img src="<?php if($rows['profile_image'] && is_file('uploads/profile_images/'.$rows['profile_image'])){?>uploads/profile_images/{{$rows['profile_image']}}<?php }else  {echo 'uploads/profile_images/default-profile.png';} ?>" class="img-circle menter-profil-pic"> <p class="invit_name"><?php if($rows['is_readed']=='N') echo "<strong> ". ucfirst($rows['name']). "</strong>"; else echo ucfirst($rows['name']); ?></p></a></td>
                        @else
                        <td><a href="{{url('profiles/'.$rows['sender_profile_id'])}}"><img src="<?php if($rows['profile_image'] && is_file('uploads/profile_images/'.$rows['profile_image'])){?>uploads/profile_images/{{$rows['profile_image']}}<?php }else  {echo 'uploads/profile_images/default-profile.png';} ?>" class="img-circle menter-profil-pic"><p class="invit_name"><?php if($rows['is_readed']=='N') echo "<strong> ". ucfirst($rows['name']). "</strong>"; else echo ucfirst($rows['name']); ?></p></a></td>
                        @endif
                         @if($rows['status']=="0")
                        <td><a href="{{url('mentor/details/'.$rows['id'])}}" class="invite_sub"><?php if($rows['is_readed']=='N') echo "<strong title='New Message'> ".ucfirst($rows['subject'])." </strong>"; else echo ucfirst($rows['subject']); ?></strong></a></td>
                      
                        @else                       
                        <td><a href="{{url('mentor/details/'.$rows['id'])}}"><?php if($rows['is_readed']=='N') echo "<strong title='New Message'> ".ucfirst($rows['subject'])." </strong>"; else echo ucfirst($rows['subject']); ?></strong></a></td>
                       
                        @endif  
                        @if($rows['status']=="0")
                        <td><p class="invite_date men_invit_date">{{date('d-m-Y',strtotime($rows['created_at']))}}</p><div class="clearfix visible-xs"></div><a class="btn btn-success ment-acc-btn"  href="{{url('mentorstatus/yes/'.$rows['sender_profile_id'])}}">Accept</a>&nbsp;<a class="btn btn-success ment-decl-btn"  href="{{url('mentorstatus/no/'.$rows['sender_profile_id'])}}" >Decline</a>&nbsp;<a class="btn btn-success ment-decl-btn" id="mentor_request" data-id="{{$rows['sender_profile_id']}}" href="javascript:void(0)" >Delete</a></td>
                        @else
                        <td><p class="invite_date men_invit_date">{{date('d-m-Y',strtotime($rows['created_at']))}}</p></td>
                        @endif        
                    </tr>                  
                    @endforeach
                  </thead>
              </table>
                     </div> 
                   
                  </div>
                  </div>
              </div>
            </div> 
          </div>         
        </div>      
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script>
$(document).on('click','#mentor_request',function(){
    var msg = 'Are you sure want to Delete ';
    var pic_id = $(this).attr("data-id");
    bootbox.confirm("Are you sure, you want to Decline Connection", function(result){   
     if(result)

   location.href = '{{url("mentorstatus/delete")}}/'+pic_id;
         return true;
//       $.ajax({
//              url: "{{url('statusdelete')}}",
//              type: 'get',
//              data: { 'pid':$pid,'_token': $('input[name=_token]').val() },
//              success:function(data){
//                         //$("#connectionmsg").append(data);
//                        window.location='connectionview?data='+data;
//                        }
//              });
    });
  });
        
 if($('#send_invitation').length)
{
  $(document).on('click','#send_invitation',function(){
    $('#send_invitation_modal').modal('show');
  });
}
if($('#sendInvitationForm').length)
{
  /*Compose To Address Profile Typeahead*/
  var bestPictures = new Bloodhound({
      datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
      queryTokenizer: Bloodhound.tokenizers.whitespace,
      //prefetch: '../data/films/post_1960.json',
      remote: {
        url: '{{url("profile_typeahead")}}?profile_name=%QUERY',
        wildcard: '%QUERY'
      }
    });

  $('#to').typeahead(null, {
      name: 'best-pictures',
      display: 'value',
      source: bestPictures,
      templates: {
        empty: [
          '<div class="empty-message">',
            'unable to find any prfofile name that match the current query',
          '</div>'
        ].join('\n'),
        suggestion: Handlebars.compile('<p><img src="{{url("uploads/profile_images/")}}/@{{#if profile_image}}@{{profile_image}}@{{else}}default-profile.png@{{/if}}" class="img-circle" width="50px" height="50px">&nbsp;<strong>@{{value}}</strong> – @{{username}}</p>')
      }

    }).on('typeahead:selected', function($e, datum){
        $("#sel_to_prof_id").val(datum['id']);
    });
  /* End To Address Profile Typeahead*/
  $(document).on('click','.clear_form',function(){
    window.location=window.location;
  });

  $("#composeMessageForm").bootstrapValidator({        
      message: 'This value is not valid',
      feedbackIcons: {
          valid: 'glyphicon glyphicon-ok',
          invalid: 'glyphicon glyphicon-remove',
          validating: 'glyphicon glyphicon-refresh'
      },
      fields: {
        'to': {
              validators: {
                  notEmpty: {
                      message: 'The To should not be empty'
                  },
                  remote: {
                      message : 'invalid to address',
                      url: "/invitation/check_username",
                      type: "get",
                      data: {
                      username: function() {
                                      return $("#username").val();
                                  }
                      }
                  }
              },
          },
        'subject': {
              validators: {
                  notEmpty: {
                      message: 'The Subject should not be empty'
                  },
              }
          },
        'message': {
              validators: {
                  notEmpty: {
                      message: 'The Message should not be empty'
                  },
              }
          },
      }
  });
}
/*if($('#users-table').length)
{
  $('#users-table').DataTable({
    //processing: true,
    serverSide: true,
    ajax: 'connectedlist?msg_type=I',
    columns: [
      {data: 'profile_image', name: 'profile_image', width:'25%', orderable: false, searchable: false},
      {data: 'name', name: 'name', width:'60%', orderable: false, searchable: false},
      {data: 'created_at', name: 'created_at', width:'15%'},
      {data: 'status', name: 'status', width:'60%', orderable: false, searchable: false},
      {data: 'sender_profile_id', name: 'sender_profile_id', width:'15%'}
    ],
  });
}*/
function statuschange($pid)
{
    $.ajax({
          url: "{{url('statuschange')}}",
          type: 'get',
          data: { 'pid':$pid,'_token': $('input[name=_token]').val() },
          success:function(data){
                //alert(data);
               window.location='connectionview?data='+data;
                    }
                });
}
function statusdelete($pid)
{  var msg = 'Are you sure want to Delete ';
    bootbox.confirm("Are you sure, you want to Decline Connection", function(result){   
     if(result)
       $.ajax({
              url: "{{url('statusdelete')}}",
              type: 'get',
              data: { 'pid':$pid,'_token': $('input[name=_token]').val() },
              success:function(data){
                         //$("#connectionmsg").append(data);
                        window.location='connectionview?data='+data;
                        }
              });
    });
}
$(document).ready(function(){
    
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
  var target = $(e.target).attr("href") // activated tab
  //alert(target);
});
});
</script>
@endsection
