@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
	 <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('messages')}}">Messages</a></li>
              <li><a href="{{url('mentorview')}}">Mentor/Mentee</a></li>
              <li class="active">View Message</li>
            </ol>   
            <div class="row">
     <div class="clearfix"></div>
              @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
          </div>      
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
          <div class="rt-panel-block">
          <div class="my-profiles-block"> 
		  <div class="row">
        <div class="col-xs-9 col-sm-9">  <h1 class="heading pull-left">{{ucwords($msg_details->subject)}}</h1></div>
           <div class="col-xs-3 col-sm-3"><button type="button" class="btn btn-primary pull-right mentor-pg-rply-btn" id="reply_message"><i class="fa fa-reply"></i> Reply</button>              
           <?php if($msg_details->sender_profile_id == Session::get('auth_selected_profile')){ ?>
           &nbsp;&nbsp;
               <button type="button" class="deletementor btn pull-right" data-id="{{$msg_details->id}}" style="margin-right: 10px;">
                   <i class="fa fa-trash-o"></i> Delete</button>
           <?php } ?></div></div>
		   <div class="clearfix"></div>
           <div class="row">
           
            <div class="col-md-12">
              <div class="panel panel-default view-msg-panel">
                <div class="panel-heading">{{ucwords($msg_details->name)}}</div>
                <div class="panel-body xs-overflow">
                  <?php echo nl2br($msg_details->msg_content);?>
                  <div class="clearfix"></div>
                 <div class="pull-right"><?php if($msg_details->created_at){ echo date('h:i a  M d, Y' ,strtotime($msg_details->created_at));} else { echo date('h:i a  M d, Y');} ?></div>
                </div>
              </div>
            </div>
          </div>  
          
          <p>&nbsp;</p> 
        </div>

		</div></div>
		<!-- Profile  Image Modal -->
    <div id="compose_message_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Compose Message</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="replyMessageForm" name="replyMessageForm" action="{{url('message/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
              <div class="form-group">
                <label class="col-sm-2 control-label" >To</label>
                <div class="col-sm-10">
                    <input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Subject</label>
                <div class="col-sm-10">
                    <input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Message</label>
                <div class="col-sm-10">
                    <textarea name="message" id="message" class="form-control" rows="10"></textarea>
                </div>    
              </div>
              <div class="form-group">
                 <div class="col-sm-2"></div>
                  <div class="col-md-10">
                      <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn compose-btn">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal -->        
  
<!-- Reply Message Modal -->
    <div id="reply_message_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Reply Message</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="composeMessageForm" name="composeMessageForm" action="{{url('mentor/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id" value="{{$msg_details->receiver_profile_id}}">
              <input type="hidden" name="sel_from_prof_id" id="sel_from_prof_id" value="{{$msg_details->sender_profile_id}}">
              <div class="form-group">
                <label class="col-sm-2 control-label" >To</label>
                <div class="col-sm-10">
                    <input type="text" name="to" id="to" class="form-control" data-bv-field="to" readonly="readonly" value="{{ucwords($msg_details->name)}}">
                    <input type="hidden" name="mentor_id" id="mentor_id" value="{{$msg_details->id}}">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Subject</label>
                <div class="col-sm-10">
                    <input type="text" name="subject" id="Subject" readonly="readonly" class="form-control" data-bv-field="subject" value="Re:{{ucwords($msg_details->subject)}}">
                </div>    
              </div>
              <div class="form-group" style="max-height: 450px; overflow-y: scroll;">
                <label class="col-sm-2 control-label" >Message</label>
                <div class="col-sm-10" >
                    <textarea name="message"  id="message" class="form-control" rows="10">
                      &#10; &#10;&#10;_____________________________________________________________________ &#10; On {{date('D, M d,Y @ h:i a',strtotime($msg_details->updated_at))}}, {{ucwords($msg_details->name)}} wrote:&#10;{{$msg_details->msg_content}}                      
                    </textarea>
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-sm-2"></div>
                  <div class="col-md-10">
                      <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn compose-btn">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Reply Message Modal -->        
    
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/messages_js.js')}}"></script>
@endsection
