@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection
@section('content')
     <div class="row out_of_bradcrom">
           <div class="col-md-3"></div>
         <div class="col-md-6">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
           @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
         </div></div>
   <div class="login-pannel-box">

		<div class="row">
			<div class="col-sm-10 col-md-10 col-md-offset-1 col-lg-7 col-lg-offset-3 mlt-sm">
				<div class="panel panel-default">
					<div class="panel-heading">
						<h1> Login</h1>
					</div>
					<div class="panel-body">
						
						<form name="login" id="loginForm" action="{{ url('/user/login') }}" method="post">
           <input type="hidden" name="_token" value="{{ csrf_token() }}">
							<fieldset>
								<div class="row">
								
									<div class="col-sm-12 col-md-10  col-md-offset-1 ">
										<div class="form-group">
										<input class="form-control" placeholder="User Name" name="username" type="text" autofocus>
										</div>
										<div class="form-group">
											<input class="form-control" placeholder="Password" name="password" type="password" value="">
											</div>
										<div class="form-group">
											<input type="submit" class="btn btn-lg btn-primary btn-block login-btn" name="signup" id="signup_submit" value="Login">
										</div>
                                        <div class="social-login-btns">
                           <a href="{{Config::get('constants.FACEBOOK_LOGIN_URL')}}" class="btn btn-lg btn-fb-login">
							
							
							<i class="fa fa-facebook"></i> Log in with Facebook</a>
                         <a href="{{Config::get('constants.LINKEDIN_LOGIN_URL')}}" class="btn btn-lg btn-linkedin-login pull-right"><i class="fa fa-linkedin"></i> Log in with Linked In</a>
                    
                            </div>

									</div>
								</div>
							</fieldset>
						</form>
					</div>
					<div class="panel-footer ">
						<div class="col-sm-12"><a href="{{url('user/forgotpwd')}}"  style="float: right;padding-top: 5px">Forgot Password?</a></div><div class="clearfix"></div></div>
					</div>
                </div>
			</div>
		</div>
  
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
@endsection
