@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li class="active">Invitations</li>
            </ol>
            <div class="row">
                 <div class="clearfix"></div>
                @if (Session::get('error_msg'))
                  <div class="col-md-12">
                    <div class="alert alert-danger">
                       <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                        {{Session::get('error_msg')}}
                    </div>
                  </div>
                @endif
                @if (Session::get('succ_msg'))
                  <div class="col-md-12">
                    <div class="alert alert-success">
                       <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span>
                       </button>
                        {{Session::get('succ_msg')}}
                    </div>
                  </div>  
                @endif
             </div>
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
           <div class="rt-panel-block">  
           <div class="my-profiles-block">  
          <div id="render-this">
            <h1 class="heading pull-left">Invitations</h1>
            <!--<button type="button" class="mtop20 mleft10 btn-primary pull-right" id="delete_invitation"><i class="fa fa-trash-o"></i> Delete</button>-->
            <?php if((Auth::User()->selected_profile!='T') && (Session::get('auth_selected_profile')!='')){  ?>
            <button type="button" class="mtop20 btn btn-primary pull-right invite-send-btn" id="compose_invitation">Send Invitation</button>
            <?php } ?>
			<div class="clearfix"></div>
            <div class="row">
            
              <div class="col-md-12">
			  <div class="table-responsive hide-768">
                @if(Auth::User()->selected_profile!='T')
				
                  <table id="users-invitation-all-table" class="table table-bordered zui-table zui-table-rounded invitation-pg-table">
                    <thead>
                      <tr>
                        <th>Date</th>
                        <th>Posted By</th>
                        <th>Subject</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                  </table>
                @else
				
                  <table id="users-invitation-table" class="table table-bordered zui-table zui-table-rounded invitation-pg-table">
                    <thead>
                      <tr>
                        <th>Date</th>
                        <th>Posted By</th>
                        <th>Subject</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                  </table>
                @endif  
				</div>
              </div>
			  
            </div>          
          </div>
          </div>
          </div>
        </div>
<!-- Profile  Image Modal -->
    <div id="compose_invitation_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Send invitation</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" role="form" method="post" id="composeInvitationForm" name="composeInvitationForm" action="{{url('invitation/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
              <div class="form-group">
                <label class="col-sm-3 control-label" >To</label>
                <div class="col-sm-9">
                    <!--<input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">-->
                    <select name="to[]" id="to" class="form-control" multiple="multiple" placeholder="Ex: Username">
                      
                    </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" >Title</label>
                <div class="col-sm-9">
                    <input type="text" name="title" id="title" class="form-control" data-bv-field="Title">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" >Company Name</label>
                <div class="col-sm-9">
                    <input type="text" name="company_name" id="company_name" class="form-control" data-bv-field="Company Name">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" >URL</label>
                <div class="col-sm-9">
                    <input type="text" name="url" id="url" class="form-control" data-bv-field="url">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" >Subject</label>
                <div class="col-sm-9">
                    <input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" >Message</label>
                <div class="col-sm-9">
                    <textarea name="message" id="message" class="form-control" rows="10"></textarea>
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-md-12">
                      <button data-dismiss="modal" class="btn-close btn-primary pull-right clear_form" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn-primary pull-left">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal -->        
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/invitations_js.js')}}"></script>
@endsection
