@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
	 <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/invitations')}}">Invitations</a></li>
              <li class="active">View Invitation</li>
            </ol> 
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
          <div class="rt-panel-block">
        <div class="my-profiles-block"> 
          <h1 class="heading pull-left">{{ucwords($msg_details->title)}}</h1>
          <!--<button type="button" class="mtop20 mleft10 delete btn-primary pull-right" data-id="{{$msg_details->delete_id}}"><i class="fa fa-trash-o"></i>Delete</button>-->
          @if(Auth::User()->selected_profile!='T')
          <button type="button" class="mtop-15 btn btn-primary pull-right view-mg-send-btn" id="compose_invitation">Send Invitation</button>
          @endif
          <div class="clearfix"></div>

          <div class="row mtop10">
              @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
             @if(Auth::User()->id==$msg_details->sender_profile_id)
              <div>
                <div class="col-md-4">
                  <div class="panel panel-default view-msg-panel">
                    <!-- Default panel contents -->
                    <div class="panel-heading">Interested Users</div>
                    <!-- List group -->
                    <ul class="list-group">
                      @if(count($inv_user_det['intr_prof']))
                        @foreach($inv_user_det['intr_prof'] as $u)
                          <li class="list-group-item">{{ucwords($u->username)}}</li>
                        @endforeach  
                      @else
                          <li class="list-group-item">No users</li>
                      @endif  
                    </ul>
                  </div>            
                </div>
                <div class="col-md-4">
                  <div class="panel panel-default view-msg-panel">
                    <!-- Default panel contents -->
                    <div class="panel-heading">Maybe users</div>
                    <!-- List group -->
                    <ul class="list-group">
                      @if(count($inv_user_det['maybe_prof']))
                        @foreach($inv_user_det['maybe_prof'] as $u)
                          <li class="list-group-item">{{ucwords($u->username)}}</li>
                        @endforeach  
                      @else
                          <li class="list-group-item">No users</li>
                      @endif  
                    </ul>
                  </div>            
                </div>
                <div class="col-md-4">
                  <div class="panel panel-default view-msg-panel">
                    <!-- Default panel contents -->
                    <div class="panel-heading">Rejected Users</div>
                    <!-- List group -->
                    <ul class="list-group">
                      @if(count($inv_user_det['rej_prof']))
                        @foreach($inv_user_det['rej_prof'] as $u)
                          <li class="list-group-item">{{ucwords($u->username)}}</li>
                        @endforeach  
                      @else
                          <li class="list-group-item">No users</li>
                      @endif  
                    </ul>
                  </div>            
                </div>
              </div> 
              <div class="clearfix"></div> 
             @endif 
            <div class="col-md-12">
              <div class="panel panel-default view-msg-panel">
                <div class="panel-heading">{{ucwords($msg_details->user_det)}}</div>
                <div class="panel-body">
                  <div class="row">
                    <div class="col-sm-4"> Title </div>
                    <div class="col-sm-8"> {{$msg_details->inv_title}} </div>
                  </div>
                  <div class="row">
                    <div class="col-sm-4"> Company Name </div>
                    <div class="col-sm-8"> {{$msg_details->company_name}} </div>
                  </div>
                  <div class="row">
                    <div class="col-sm-4"> URL </div>
                    <div class="col-sm-8"> {{$msg_details->company_url}} </div>
                  </div>
                  <p>&nbsp;</p>
                  <?php echo nl2br($msg_details->msg_content);?>
                  @if($msg_details->attachment)
                  <h4> Attachment : </h4>
                   <a href="{{url('download/inv_attachment/'.$msg_details->id)}}"><i class="fa fa-paperclip"></i> {{ ($msg_details->attachment_name != '') ? $msg_details->attachment_name : $msg_details->attachment }}</a>
                  @endif
                  <div class="clearfix"></div>
                  <div class="pull-right"><?php echo date('h:i a  M d, Y',strtotime($msg_details->updated_at));?></div>
                </div>
              </div>
            </div>
          <!--@if($msg_details->inv_reply)  
            <div class="col-md-12">
              <button type="button" class="btn-primary pull-right" id="reply_invitation"><i class="fa fa-reply"></i> Reply</button>
            </div>     
          @endif  -->
          </div>  
          <p>&nbsp;</p> 
        </div>

		</div></div>
		
		<!-- Invitation Modal -->
    <div id="compose_invitation_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Send invitation</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="composeInvitationForm" name="composeInvitationForm" action="{{url('invitation/compose')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
              <div class="form-group">
                <label class="col-sm-2 control-label" >To</label>
                <div class="col-sm-10">
                    <!-- <input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">-->
                    <select name="to[]" id="to" class="form-control" multiple="multiple" placeholder="Ex: Username">
                      
                    </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Subject</label>
                <div class="col-sm-10">
                    <input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject">
                </div>    
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label" >Message</label>
                <div class="col-sm-10">
                    <textarea name="message" id="message" class="form-control" rows="10"></textarea>
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-md-12">
                      <button data-dismiss="modal" class="btn-close btn-primary pull-right clear_form" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn-primary pull-left">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Invitation Modal -->        
    @if($msg_details->inv_reply)
<!-- Reply Invitation Modal -->
    <div id="reply_invitation_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Reply Invitation</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="replyInvitationForm" name="replyInvitationForm" action="{{url('invitation/reply')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="inv_id" id="inv_id" value="{{$msg_details->id}}">
              <div class="form-group">
                <label class="col-sm-2 control-label" >Message</label>
                <div class="col-sm-10">
                    <textarea name="message" id="message" class="form-control" rows="10">
                      &#10; &#10;&#10;_____________________________________________________________________ &#10; On {{date('D, M d,Y @ h:i a',strtotime($msg_details->updated_at))}}, {{ucwords($msg_details->reply_user)}} wrote:&#10;{{$msg_details->msg_content}}                      
                    </textarea>
                </div>    
              </div>
              <div class="form-group">
                  <div class="col-md-12">
                      <button data-dismiss="modal" class="btn-close btn-primary pull-right clear_form" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn-primary pull-left">Send</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Reply Invitation Modal -->        
    @endif
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/invitations_js.js')}}"></script>
@endsection
