@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/invitations')}}">Invitations</a></li>
              <li class="active">Send Invitation</li>
            </ol>
            <div class="row">
            <div class="clearfix"></div>
              @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-div="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-div="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
            </div>
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
         <div class="rt-panel-block">  
           <div class="my-profiles-block">  
          <h1 class="heading pull-left">Send Invitation</h1>

          <div class="row">
              
           
            <div class="col-md-10">
              <form class="form-horizontal" role="form" method="post" id="composeInvitationForm" name="composeInvitationForm" action="{{url('invitation/compose')}}" enctype="multipart/form-data">
                  <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
                  <div class="form-group">
                    <div class="col-sm-3 " >To <span class="reqired-val">*</span></div>
                    <div class="col-sm-9">
                        <!--<input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">-->
                        <select name="to[]" id="to" class="form-control" multiple="multiple" placeholder="Ex: Username">
                          
                        </select>
                    </div>
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >Title <span class="reqired-val">*</span></div>
                    <div class="col-sm-9">
                        <input type="text" name="title" id="title" class="form-control" data-bv-field="Title">
                    </div>    
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >Company Name <span class="reqired-val">*</span></div>
                    <div class="col-sm-9">
                        <input type="text" name="company_name" id="company_name" class="form-control" data-bv-field="Company Name">
                    </div>    
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >URL</div>
                    <div class="col-sm-9">
                        <input type="text" name="url" id="url" class="form-control" data-bv-field="url">
                    </div>    
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >Subject <span class="reqired-val">*</span></div>
                    <div class="col-sm-9">
                      <select name="subject" id="subject" class="form-control" data-bv-field="subject">
                        <option value="">Select Subject</option>
                        <option value="Invitation to an event">Invitation to an event</option>
                        <option value="Invitation to a job">Invitation to a job</option>
                      </select>
                        <!--<input type="text" name="subject" id="Subject" class="form-control" data-bv-field="subject">-->
                    </div>    
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >Message <span class="reqired-val">*</span></div>
                    <div class="col-sm-9">
                        <textarea name="message" id="message" class="form-control" rows="10"></textarea>
                    </div>    
                  </div>
                  <div class="form-group">
                    <div class="col-sm-3 " >Attachment</div>
                    <div class="col-sm-9">
                      <input type="file" name="attachments" id="attachements" class="form-control">
                    </div>    
                  </div>
                  <div class="form-group">
                      <div class="col-md-9 col-md-offset-3">
                          <button type="submit" value="Submit" class="btn btn-primary send-invite-btn">Send</button>
                          <button type="button" class="btn btn-close btn-primary cancel-invite-btn" id="cancel_inv">Cancel</button>
                      </div>
                  </div>
              </form>          
            </div>
          </div>          
        </div></div></div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/invitations_js.js')}}"></script>
@endsection
