@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('content')
<section class="main_content">
    <div class="container">
	<ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li><a href="{{url('/Inquiries')}}">Inquiries</a></li>
              <li class="active">View Inquiry</li>
            </ol>            
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-8">
<div class="rt-panel-block">
<div class="my-profiles-block"> 
          <h1 class="heading pull-left">{{ucwords($msg_details->title)}}</h1>
         
          <div class="clearfix"></div>

          <div class="row mtop10">
              @if (Session::get('error_msg'))
                <div class="col-md-12">
                  <div class="alert alert-danger">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('error_msg')}}
                  </div>
                </div>
              @endif
              @if (Session::get('succ_msg'))
                <div class="col-md-12">
                  <div class="alert alert-success">
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                       <span aria-hidden="true">&times;</span>
                     </button>
                      {{Session::get('succ_msg')}}
                  </div>
                </div>  
              @endif
             
            <div class="col-md-12">
              <div class="panel panel-default view-msg-panel">
                <div class="panel-heading">{{ucwords($user_det->name)}}</div>
                <div class="panel-body">
                  <div class="row">
                    <div class="col-sm-2"> Title </div>
                    <div class="col-sm-10"> {{$msg_details->title}} </div>
                  </div>
                  <div class="row">
                    <div class="col-sm-2"> Company Name </div>
                    <div class="col-sm-10"> {{$inq_details->company}} </div>
                  </div>
                  
                  <div class="row">
                    <div class="col-sm-2"> Description </div>
                    <div class="col-sm-10"> <?php echo nl2br($msg_details->msg_content);?></div>
                  </div>
                  
               
                  
                  <div class="clearfix"></div>
                  <div class="pull-right"><?php echo date('h:i a  M d, Y',strtotime($msg_details->updated_at));?></div>
                </div>
              </div>
            </div>
         
          </div>  
          <p>&nbsp;</p> 
        </div>
</div></div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/invitations_js.js')}}"></script>
@endsection
