  @extends('main')
@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
@endsection
@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li class="active">Connections</li>
            </ol>
 
            @if (Session::get('error_msg'))
              <div class="col-md-12">
                <div class="alert alert-danger">
                   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
                    <?php echo Session::get('error_msg') ?>
                </div>
              </div>
            @endif
            @if (Session::get('succ_msg'))
              <div class="col-md-12">
                <div class="alert alert-success">
                   <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                   </button>
                    <?php echo Session::get('succ_msg')?>
                </div>
              </div>  
            @endif
			 <div id="connectionmsg" >
                      @if(isset($_GET['data']))
                      <p class='alert alert-success clearfix'>                
                          {{$_GET['data']}}                
                      </p>
                      @endif
                  </div>
				  <div class="clearfix"></div>
         
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-9">
          <div class="rt-panel-block">  
           <div class="my-profiles-block"> 
          <div id="render-this">
            <h1 class="heading pull-left">My Connections</h1> 
            <a href="{{url('/getcontacts')}}" ><img src="/images/icons/My-Connections_icon.png" title="import contacts" width="50px" height="50px" style="float: right;
                             margin-top: 10px;"></a>
                             
            <div class="row">
             <div class="clearfix"></div>
              <div class="col-md-12">
                 
				  <div class="table-responsive visible-360">
                <table id="userstable" class="display responsive nowrap table-bordered zui-table zui-table-rounded table my-conncetions-table">
                  <thead>
                    <tr>
                      <th>Name</th>
                      <th>Message</th>
                      <th>Actions</th>
                      <th>Date</th>
                    </tr>
                    @if(count($results)==0)
                    <tr>
                        <td colspan="4" align="center">No New Connections</td>                      
                    </tr>
                    @endif
                    @foreach($results as $rows)                  
                    <tr>
                        <td class="menter-pic-block">@if($rows['profile_type']=='T' || Session::get('auth_selected_profile_type')!='T')<a href="{{url('profiles/'.$rows['sender_profile_id'])}}">@endif
                                <img src="<?php if($rows['profile_image'] && is_file('uploads/profile_images/'.$rows['profile_image'])) {echo 'uploads/profile_images/'.$rows['profile_image']; }else  {echo 'uploads/profile_images/default-profile.png';} ?>" class="img-circle menter-profil-pic">
                                &nbsp;
                                 @if($rows['is_read']=="No")
                                   <p class="menter-name-p"> <strong>{{$rows['name']}}</strong></p>
                                @else
                                   <p class="menter-name-p"> {{$rows['name']}}</p>
                                 @endif
                            
                            </a>
                        </td>
                        
                       @if($rows['status']=="Pending")
                        <td><a href="{{url('connections/details/'.$rows['id'])}}"><button class="btn btn-primary con-view-btn">View Message</button></a></td><td><a class="btn btn-success con-view-btn" onclick="statuschange({{$rows['sender_profile_id']}})" href="javascript:void(0)">Accept</a>&nbsp;<a class="btn btn-success con-del-send-btn " onclick="statusdelete({{$rows['sender_profile_id']}})" href="javascript:void(0)" >Delete</a></td>
                        @else
                        <td><a href="{{url('connections/details/'.$rows['id'])}}"><button class="btn btn-primary con-view-btn">View Message</button></a></td><td><button type="button" class="btn btn-primary send_message con-del-send-btn" user_id="{{$rows['id']}}">Send Message</button></td>
                        @endif
                        <td><p class="my-connect-date">{{date('d-m-Y',strtotime($rows['created_at']))}}</p></td>
                    </tr>                  
                    @endforeach
                  </thead>
              </table></div>
              </div>
                 
            </div>     
<div id="LoadingImage" style="display: none;">
                 <img class="img-responsive" src="images/spin.gif" width="120" height="120" alt=""/>
        </div>
            <input type="hidden" name="_token" value="{{{ Session::getToken() }}}">
            <!-- Reply Message Modal -->
            <div id="send_message_modal" class="modal fade" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            </div><!-- End of Reply Message Modal -->  

          </div>
          </div>
          </div>
        </div>  
      </div>
    </div>
  </section>
@endsection
@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
<script src="{{ asset('js/typeahead_0.11.js')}}"></script>
<script src="{{ asset('js/handlebars.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('js/messages_js.js')}}"></script>
<script>
 $( document ).ready(function() {   
   //$('#userstable').DataTable();
 });
        
 if($('#send_invitation').length)
{
  $(document).on('click','#send_invitation',function(){
    $('#send_invitation_modal').modal('show');
  });
}
if($('#sendInvitationForm').length)
{
  /*Compose To Address Profile Typeahead*/
  var bestPictures = new Bloodhound({
      datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
      queryTokenizer: Bloodhound.tokenizers.whitespace,
      //prefetch: '../data/films/post_1960.json',
      remote: {
        url: '{{url("profile_typeahead")}}?profile_name=%QUERY',
        wildcard: '%QUERY'
      }
    });

  $('#to').typeahead(null, {
      name: 'best-pictures',
      display: 'value',
      source: bestPictures,
      templates: {
        empty: [
          '<div class="empty-message">',
            'unable to find any prfofile name that match the current query',
          '</div>'
        ].join('\n'),
        suggestion: Handlebars.compile('<p><img src="{{url("uploads/profile_images/")}}/@{{#if profile_image}}@{{profile_image}}@{{else}}default-profile.png@{{/if}}" class="img-circle" width="50px" height="50px">&nbsp;<strong>@{{value}}</strong>  @{{username}}</p>')
      }

    }).on('typeahead:selected', function($e, datum){
        $("#sel_to_prof_id").val(datum['id']);
    });
  /* End To Address Profile Typeahead*/
  $(document).on('click','.clear_form',function(){
    window.location=window.location;
  });

  $("#composeMessageForm").bootstrapValidator({        
      message: 'This value is not valid',
      feedbackIcons: {
          valid: 'glyphicon glyphicon-ok',
          invalid: 'glyphicon glyphicon-remove',
          validating: 'glyphicon glyphicon-refresh'
      },
      fields: {
        'to': {
              validators: {
                  notEmpty: {
                      message: 'The To should not be empty'
                  },
                  remote: {
                      message : 'invalid to address',
                      url: "/invitation/check_username",
                      type: "get",
                      data: {
                      username: function() {
                                      return $("#username").val();
                                  }
                      }
                  }
              },
          },
        'subject': {
              validators: {
                  notEmpty: {
                      message: 'The Subject should not be empty'
                  },
              }
          },
        'message': {
              validators: {
                  notEmpty: {
                      message: 'The Message should not be empty'
                  },
              }
          },
      }
  });
}
/*if($('#users-table').length)
{
  $('#users-table').DataTable({
    //processing: true,
    serverSide: true,
    ajax: 'connectedlist?msg_type=I',
    columns: [
      {data: 'profile_image', name: 'profile_image', width:'25%', orderable: false, searchable: false},
      {data: 'name', name: 'name', width:'60%', orderable: false, searchable: false},
      {data: 'created_at', name: 'created_at', width:'15%'},
      {data: 'status', name: 'status', width:'60%', orderable: false, searchable: false},
      {data: 'sender_profile_id', name: 'sender_profile_id', width:'15%'}
    ],
  });
}*/
function statuschange($pid)
{$("#LoadingImage").show();
    $.ajax({
          url: "{{url('statuschange')}}",
          type: 'get',
          data: { 'pid':$pid,'_token': $('input[name=_token]').val() },
          success:function(data){
                //alert(data);
               window.location='connectionview?data='+data;
               $("#LoadingImage").hide();
                    }
                });
}
function statusdelete($pid)
{  var msg = 'Are you sure want to Delete ';
    bootbox.confirm("Are you sure, you want to Decline Connection", function(result){   
     if(result)
       $.ajax({
              url: "{{url('statusdelete')}}",
              type: 'get',
              data: { 'pid':$pid,'_token': $('input[name=_token]').val() },
              success:function(data){
                         //$("#connectionmsg").append(data);
                        window.location='connectionview?data='+data;
                        }
              });
    });
}
</script>
@endsection
