@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('plugins/select2/css/select2.min.css')}}" rel="stylesheet">
@endsection


@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li class="active">My Resumes</li>
            </ol>
  <div class="row">
          <div class="col-md-12">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success clearfix">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
  </div>
      <div class="row talent_home">
        
        @include("left_menu")
        <div class="col-md-9 col-sm-9"> 
           
           <div class="imagebanner-block">
           <img src="images/my-resumes_bg.png" class="img-responsive" alt="banner">
          <h1 class="banner-txt">My Resumes</h1>
               </div>
            @if (Session::has('message'))

            <p>{{ Session::get('message') }}</p>

            @endif



 

 <div class="row">
            <div class="col-sm-12 mbot10">
              <h1 class="mypics-head">Search Resumes</h1>
              <div class="picture-search-input">
                <input type="text" name="search" placeholder="Search Resume based on Title"  id="auto_search" value="" class="form-control">
              </div>    
            </div>
            <div class="col-sm-12">
              <div class="mbot10"><h1 class="mypics-head">Post Resumes</h1></div>
             
                 <form class="" name="" action="" method="post" id="resumesForm" enctype="multipart/form-data">
                    <div class="form-group col-sm-4 picture-search-input">
                        <input type="text" name="name" placeholder="Resume Title" value="" class="form-control">
                    </div>    
                    <div class="form-group col-sm-4 picture-search-input">
                        <input type="file" name="attachment" class="form-control" accept="doc/docx/pdf/txt/xls" value="">
                    </div>
                    <input type="hidden" name="_token" value="{{csrf_token()}}">
               <div class="col-sm-4 btn-no-pad">
                    <button type="submit" name="upload" id="checkvalid" value="push" class="btn pic-upload-btn">Upload Resumes</button>
					</div>
                </form>
              
            </div>  
        </div> 

           @if ($errors->any())
            <ul style="color:red;">

            {{ implode('', $errors->all(':message')) }}

            </ul>

            @endif

        
            <div class="row my-pics-block" id="new_pic">
           @if($data->count() > 0)
             @foreach($data as $pic)
             <div class="col-md-6 col-sm-6  col-lg-4 findlen">
              <div class="row myresume-view-block">  
              {{--*/ $addfile='images/text.png' /*--}}
                      @if($pic->access=='PUB')
                      {{--*/ $viewName = @end( @explode( '.', $pic->path ) ) /*--}}
                      @if($viewName=='txt')
                      {{--*/ $addfile='images/text.png' /*--}}
                      @endif
                      @if($viewName=='doc')
                      {{--*/ $addfile='images/doc.png' /*--}}
                      @endif
                      @if($viewName=='docx')
                      {{--*/ $addfile='images/docxs.png' /*--}}
                      @endif
                      @if($viewName=='pdf')
                      {{--*/ $addfile='images/pdfs.png' /*--}}
                      @endif
                       @if($viewName=='xls')
                      {{--*/ $addfile='images/xlss.png' /*--}}
                      @endif
                       @if($viewName=='xlsx')
                      {{--*/ $addfile='images/xlsxs.png' /*--}}
                      @endif
                       @if($viewName=='rtf')
                      {{--*/ $addfile='images/rtfs.png' /*--}}
                      @endif             
                      @endif
                <div class="resume-bg-block"><div class="resume-type-img"> 
                  @if($pic->path)
                  <a href="{{URL::to('res_download', array($pic->id))}}">  <img class="img-responsive" src="{{$addfile}}"  alt=""/></a>
                  @endif
                </div>
                      </div>      <div class="clearfix"></div>
                      <div  class="mypics-botm-links">            
                      <div class="col-sm-6 col-md-8 col-xs-6">  <h4 title="{{$pic->name}}">{{ str_limit($pic->name, $limit = 15, $end = '...') }} </h4></div>                 
                 <div class="col-sm-6 col-md-4 col-xs-6 my-pics-action-icons"> <div class="user-upload-action-icons">
                       @if($pic->access=='PUB')
                      {{--*/ $viewName = @end( @explode( '.', $pic->path ) ) /*--}}
					  
                    <span class="lock-icon">
                      <a href="javascript:;" class="share_btn" data-id="{{$pic->id}}" data-url="{{$addfile}}" title="Share"><i class="fa fa-share-alt"></i></a>
                    </span>
                    <span class="lock-icon">  <a href="{{url('pictures/'.$pic->id.'?access=lock')}}" title="Unlock"><i class="fa fa-unlock"></i></a></span>
                    @else
                    <span class="lock-icon">     <a href="{{url('pictures/'.$pic->id.'?access=unlock')}}" title="Lock"><i class="fa fa-lock"></i></a></span>
                    @endif
                    <span class="delete-icon"> <a  href="javascript:void(0)" data-id="{{$pic->id}}"  class="chk_del" title="Delete"><i class="fa fa-trash-o"></i></a></span></div>
                 </div>  
                 </div>      
             </div></div>
             @endforeach 
          @else 
             <div class="col-sm-4 findlen">
                                 <h4>No Resumes Found</h4>
             </div>
          @endif
        </div>
        <div id="LoadingImage" style="display: none;">
                 <img class="img-responsive" src="images/spin.gif" width="120" height="120" alt=""/>
        </div>
             <input type="hidden" name="_token" value="{{{ Session::getToken() }}}">
             <input type="hidden" name="numrows" id="numrows" value="{{$numrows}}">
             <input type="hidden"  id="maxlimit" value="{{$maxlimit}}">
           <div class="col-sm-4 col-md-offset-4">
             <button  class="btn mypics-more-btn" id="picture_next">More</button>
           </div>
        </div>
      </div>
    </div>

    <!-- Profile  Resume Modal -->
    <div id="share_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title">Share Resume</h4>
        </div>
        <div class="modal-body">
          <form class="form-horizontal" method="post" id="shareForm" name="shareForm" action="{{url('share/share_asset')}}">
              <input type="hidden" name="_token" value="{{ csrf_token() }}">
              <input type="hidden" name="sel_to_prof_id" id="sel_to_prof_id">
              <input type="hidden" name="assets_id" value="" class="assets_id_elem">
              <input type="hidden" name="asset_type" value="resume">
              <div class="form-group">
                <label class="col-sm-1 share_label">To<span class="reqired-val">*</span></label>
                <div class="col-sm-11">
                    <!--<input type="text" name="to" id="to" class="form-control .typeahead" data-bv-field="to">-->
                    <select name="to[]" id="to" class="form-control" multiple="multiple" placeholder="Ex: Username">
                      
                    </select>
                </div>
              </div>
              <div class="form-group">
                <div class="col-sm-12 text-center"><img src="" class="img-elem img-responsive"></div>
              </div>
              <div class="form-group">
                  <div class="col-md-12">
                      <button data-dismiss="modal" class="btn-close btn delete-btn clear_form pull-right" type="button">Close</button>
                      <button type="submit" value="Submit" class="btn-close btn delete-btn clear_form pull-left">Share</button>
                  </div>
              </div>
          </form>          
        </div><!-- End of Modal body -->
        </div><!-- End of Modal content -->
        </div><!-- End of Modal dialog -->
    </div><!-- End of Profile Image Modal -->     

  </section>
  @endsection
  

@section('js')

<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('plugins/select2/js/select2.min.js')}}"></script>
<script type="text/javascript">
    
  $(document).on('click','.chk_del',function(){
    var pic_id = $(this).attr("data-id");
    bootbox.confirm("Are you sure, you want to delete Resume?", function(result) {
      if(result)
      location.href = '{{url("myresume/")}}/'+pic_id+"/delete";
    });  
  });
  
   $(document).ready(function() {
       
@if($numrows<=$maxlimit)
$('#picture_next').hide();    
@endif   
        
 $('#picture_next').click(function(){
       load_more();
   });
   
  var ajax_request;
    
   function load_more()
       {
           if(ajax_request != null) ajax_request.abort(); //cancel previous request    
       var numproducts=parseInt($("#numrows").val());
       var maxlimit=parseInt($("#maxlimit").val());

      var current_prof_id = {{Session::get('auth_selected_profile')}};
      
       $("#LoadingImage").show(); 
       var findsiz= $(".findlen").length;
       var divsiz=maxlimit;
       var sea_key = $('#auto_search').val();
       if(numproducts<=maxlimit){$('#picture_next').css("display", "none");}
       
       var url = "{{url('filelimit')}}?take="+divsiz+"&skip="+findsiz+"&sea_key="+sea_key;
       //if(sea_key)
          //$('#auto_search').attr('readonly','readonly');
    
          ajax_request = $.ajax({
                    type: "get",
                    url : url,
                    dataType: "json",
                    success : function(data){
                         append_data = '';
                         var obj = data['likes'];
                         var arr = [];
                         for (elem in obj) {
                            arr.push(obj[elem]);
                          }
                           $.each(data['values'],function(i,v){
                        icon = '';icon_url='';permission='';
                        video_img='';popup='';iframe_src='';vid_likes='';
                        var image_path='';
                        
                        if(v.path!='')
                        {
                          var viewName = v.path.split('.').pop();
                          if(viewName == 'txt')addfile='images/text.png';
                          if(viewName == 'doc')addfile='images/doc.png';
                          if(viewName == 'docx')addfile='images/docxs.png';
                          if(viewName == 'pdf')addfile='images/pdfs.png';
                          if(viewName == 'xls')addfile='images/xlss.png';
                          if(viewName == 'xlsx')addfile='images/xlsxs.png';
                          if(viewName == 'rtf')addfile='images/rtfs.png';
                        }

                        if(current_prof_id==v.profile_id)
                        {
                            share = '<div class="user-upload-action-icons">';
                            if(v.access=='PUB')
                            {
                              icon = 'fa-unlock';
                              icon_url = "{{url('pictures')}}/"+v.id+"?access=lock";
                              icon_title = 'Unlock';

                              share =  '<span class="lock-icon">';
                              share += '<a href="javascript:;" class="share_btn" data-id="'+v.id+'" data-url="'+addfile+'" title="Share"><i class="fa fa-share-alt"></i></a>';
                              share += '</span>';
                            }
                            else
                            {
                             icon = 'fa-lock'; icon_url = "{{url('pictures')}}/"+v.id+"?access=unlock";
                             icon_title = 'Lock';
                            }
                     
                      
                            permission =  share + ' <span class="lock-icon"><a href="'+icon_url+'"><i class="fa '+icon+'"></i></a></span> <span class="delete-icon"><a href="javascript:void(0)" title="Delete" class="chk_del" data-id="'+v.id+'"><i class="fa fa-trash-o"></i></a></span></div>';
                       
                        }
                         else
                        { 
                          
                           
                            vid_likes='<div class="update_likes'+v.id+'">';
                            if($.inArray(v.id,arr)!=-1)
                            {
                            vid_likes=vid_likes+'<a href="javascript:void(0)" class="updt_pro like'+v.id+' unlike_col" data-id="'+v.id+'"><span class="glyphicon glyphicon-thumbs-down"></span> (Unlike)</a>';
                             }                        
                           else
                             {
                             vid_likes=vid_likes+'<a href="javascript:void(0)" class="updt_pro unlike'+v.id+'" data-id="'+v.id+'" ><span class="glyphicon glyphicon-thumbs-up"></span> (Like)</a>';
                              }
                            vid_likes=vid_likes+'</div>';
                        }
                       if(v.path!='')
                       {
                      var image_path='<div class="resume-type-img"><a href="{{url("res_download/")}}/'+v.id+'"><img class="img-responsive" src="'+addfile+'"  alt=""/></a></div>';      
                      } 
                        len=v.name.length;
                        var pic_title=v.name;
                        if(len > 15)
                        {
                          v.name=v.name.substr(0,15)+'...';
                        }
                  
                      append_data=append_data+'<div class="col-md-6 col-sm-6  col-lg-4 findlen"><div class="row myresume-view-block"><div class="resume-bg-block">'+image_path+'</div><div class="mypics-botm-links"><div class="col-sm-6 col-md-8 col-xs-6"><h4 title="'+pic_title+'">'+v.name+'</h4></div><div class="col-sm-6 col-md-4 col-xs-6 my-pics-action-icons">'+permission+vid_likes+'</div></div></div></div>';
                
                      });
                       if(append_data) append_data=append_data+'<div class="clearfix"></div>';
                  //  if(sea_key)
                       // $('#auto_search').removeAttr('readonly');
                       if(!$(".findlen").length)$('#new_pic').html('');
                   
                       $('#new_pic').append(append_data);
                        if(! append_data)$('#new_pic').html('No Records Found');
                        
                        if(parseInt(data['count'])>$(".findlen").length){$('#picture_next').show();}else{$('#picture_next').hide();}
                      $("#LoadingImage").hide();
                    }
                },"json");
    
      }
   
    $("#auto_search").keyup(function(){
        $("#LoadingImage").show();
        var curval=$(this).val();
        if(curval=='')
       { 
         $('#new_pic').html('<a href="javascript:void(0)"><i class="fa fa-circle-o-notch fa-spin"></i> loading results</a>');
         load_more();
       }
       else
        { 
        $('#new_pic').html('');
          $( document ).ajaxStop(function() {
          });  
          load_more();

        }
      
        
    });

});

//for mylikes script
     $(document).on('click','.updt_pro',function(){
    var data_id = $(this).attr("data-id");//alert(data_id);
     // location.href = '{{url("pictures/likes")}}/'+data_id;
      $("#LoadingImage").show();
      //for mylikes ajax
 var dataString = 'like_id='+ data_id +  '&_token=' + $("input[name=_token]").val();
  $.ajax({
                    type: "POST",
                    url : "/myresume/likes",
                    data : dataString,
                    success : function(data){
                       $("#LoadingImage").hide();
                      var Unlike='<a href="javascript:void(0)" class="updt_pro like'+data_id+' unlike_col" data-id="'+data_id+'" ><span class="glyphicon glyphicon-thumbs-down"></span> (Unlike)</a>';
                      var Like='<a href="javascript:void(0)" class="updt_pro unlike'+data_id+'" data-id="'+data_id+'" ><span class="glyphicon glyphicon-thumbs-up"></span> (Like)</a>';
                       if(data=='Like'){ $('.like'+data_id).replaceWith(Like);}
                       if(data=='Unlike'){ $('.unlike'+data_id).replaceWith(Unlike);}}
                },"json");
   
  });

  // Share js code
  $(document).ready(function(){

    if($('.share_btn').length)
    {
      $(document).on('click','.share_btn',function(){
        $('#share_modal').modal('show');
        $('#share_modal .img-elem').attr('src', $(this).attr('data-url'));
        $('#share_modal .assets_id_elem').val($(this).attr('data-id'));
      });
    }

      $("#to").select2({
        ajax: {
          url: "/invitation_typeahead",
          dataType: 'json',
          delay: 250,
          data: function (params) {
            return {
              user_name: params.term, // search term
            };
          },
          processResults: function (data) {
            //alert('hi');
            // parse the results into the format expected by Select2.
            // since we are using custom formatting functions we do not need to
            // alter the remote JSON data
            var results = [];
           // console.log(data);
            $.each(data, function(index, item){
              results.push({
                id: item.id,
                text: item.value
              });
            });
            return {
                results: results
            };
          },
          cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        //minimumInputLength: 1,
        maximumSelectionLength: 5
        //templateResult: formatRepo, // omitted for brevity, see the source of this page
        //templateSelection: formatRepoSelection // omitted for brevity, see the source of this page
      });  
  })
 </script>
@endsection
