@extends('admin')
   
@section('css')
<style>
    .org_enq {
        width: 200px;
        height: 41px;
    }
</style>
    <link href="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.css')}}" type="text/css" rel="stylesheet" />
    <link href="{{ asset('admin/plugins/tables/dataTables/TableTools.css')}}" type="text/css" rel="stylesheet" />
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"> <h3>Subscribers</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>  
   <div class="row">
                         
   
        <div class="col-sm-2 col-md-offset-9" >
            <button  type="button" class="form-control pull-right btn-primary" id="add_new"><strong>Send Mail</strong></button>
         </div>                     
    
         <div class="col-lg-10 col-md-offset-1">
                      
                            <div class="panel panel-default gradient">
                                <div class="panel-heading">
                                    <h4>
                                        <span>Subscribers List</span>
                                    </h4>
                                </div>
                                <div class="panel-body noPad clearfix">
                                    <table cellpadding="0" cellspacing="0" border="0" class="tableTools display table table-bordered" width="100%">
                                        <thead>
                                           <tr> 
                                                <th>S.No</th>
						                                  
                                                <th>Email</th>
                                               
                                                <th>Status</th>
                                                <th>Options</th>
					 </tr>
                                        </thead>
                                        <tbody>
                                          
                                        @if(count($data) > 0)
                                          {{--*/ $i = 1 /*--}}
                                            @foreach($data as $pic)
                                             <tr>
                                             <td>{{$i}}</td>
                                            
                                             <td> {{$pic['email']}}</td>
                                           
                                             <td>@if($pic['status']=='0')
                                                 <a  class="btn btn-primary btn-xs" href="{{url("admin/subscribe_status/".$pic['id']."/approve")}}" style="cursor:pointer">Pending</a>
                                                 @else  
                                              <a  class="btn btn-success btn-xs" href="{{url("admin/subscribe_status/".$pic['id']."/pending")}}" style="cursor:pointer">Approve</a> 
                                                 @endif
                                             </td>
                                            <td>@if($pic['status']=='1')<a href="<?php echo URL::to('/admin/reply_subscribe/'.$pic['id'].''); ?>" title="Edit"><span><i class="icon-edit"></i></span></a>@endif
                                                 <a  href="javascript:void(0)" data-id="{{$pic['id']}}"  class="chk_del" title="Delete"><i class="icon-remove-sign"></i></a></td>
                                             </tr>
                                              {{--*/ $i++ /*--}}
                                             @endforeach 
                                        @endif
					
                                        </tbody>
                                       
                                    </table>
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span12 -->

        
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   
  <script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
    <script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
    <script src="{{ asset('js/bootbox.js')}}"></script>

    
    <script type="text/javascript" language="javascript">


$(document).ready(function() {
	$('#userinfo').dataTable();
 $(document).on('click','#add_new',function()
        {location.href = '{{url("admin/reply_mail")}}';
        });
      
        
          $(document).on('click','.chk_del',function()
        {
          var pic_id = $(this).attr("data-id");
          bootbox.confirm("Are you sure, you want to delete Contact?", function(result)
          {
            if(result)location.href = '{{url("admin/remove_subscribe/")}}/'+pic_id+"/delete";
          });  
        });
        
 } );
        </script>
      
   <script type="text/javascript" src="{{ asset('admin/plugins/misc/nicescroll/jquery.nicescroll.min.js')}}"></script>
 
    <!-- Table plugins -->
    <script type="text/javascript" src="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.min.js')}}"></script>
   
   
    <script type="text/javascript" src="{{ asset('admin/plugins/tables/responsive-tables/responsive-tables1.js')}}"></script><!-- Make tables responsive -->

    <!-- Init plugins -->
   
    <script type="text/javascript" src="{{ asset('admin/js/datatable.js')}}"></script><!-- Init plugins only for page -->
   
    @endsection