@extends('admin')
   
@section('css')
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>My Category</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
                
                   @foreach($skill_info as $social_data)
                <div class="row">
                       
                        <div class="col-md-6 col-md-offset-3">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Skill</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="signup" role="form" method="post" id="userForm">
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="fullname">Primary Skill:</label>
                                            <div class="col-lg-9">
                                                <select name="main_skill" class="form-control">
                                          <option value="">Primary Skills</option>
                                          @foreach($cat_info as $cat_data)
                                      
                                          
                            <option value="{{ $cat_data->id }}" {{ ($social_data->ref_cat_id==$cat_data->id) ? 'selected="selected"':'' }}>{{$cat_data->name}}</option>
                         
                                          @endforeach
                                         </select>
                                            </div>
                                        </div><!-- End .form-group  -->
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="city">Type:</label>
                                            <div class="col-lg-9">
                                               <select name="type" class="form-control">

                                         <option value="">Type</option>
                                         <option value="T" {{ ($social_data->type=='T') ? 'selected="selected"':'' }}>Talent</option>
                                         <option value="O" {{ ($social_data->type=='O') ? 'selected="selected"':'' }}>Organization</option>

                                     </select>
                                            </div>
                                        </div><!-- End .form-group  -->
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="dataofbirth">Skill:</label>
                                            <div class="col-lg-9">
                                                <input type="text" class="form-control" placeholder="Skill" name="name" value="{{ isset($social_data->name) ? $social_data->name:'' }}">
                                                 <input type="hidden" name="_token" value="{{ csrf_token() }}">
                  <input type="hidden" name="role_id" value="{{ isset($social_data->id) ? $social_data->id:'' }}">
                                            </div>
                                        </div><!-- End .form-group  -->
                                    

                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="Update" value="Store">Save</button>
                                            
                                               <a href = "{{ URL::to('admin/category') }}" class = 'btn btn-warning'>Cancel</a>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->

                    </div><!-- End .row -->  
                @endforeach 
               
       
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   
  <script type="text/javascript">
    $(document).ready(function(){ 
           $("#userForm").validate({
                rules: {
                    name: {
                        required: true,
                        //minlength: 4
                    },
                  
                },
                messages: {
                    name: {
                        required: "Enter Skill",
                       // minlength: "User is bigger"
                    },
 
                }   
            }); 
    });
    </script>
 
      
   
    @endsection