@extends('admin')
   
@section('css')
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('css/datepicker.css')}}" rel="stylesheet">
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>My Profile</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
          
                  @foreach($user_info as $social_data)
                <div class="row">
                       
                        <div class="col-md-6 col-md-offset-3">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Admin fields</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="signup" role="form" method="post" id="userForm">
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="fullname">Full Name / Business Name:</label>
                                            <div class="col-lg-9">
                                                <input type="text" class="form-control"  placeholder="Please Enter Full Name / Business Name" name="name" value="{{ isset($social_data->name) ? $social_data->name:'' }}">
                                            </div>
                                        </div><!-- End .form-group  -->
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="city">City:</label>
                                            <div class="col-lg-9">
                                                <input type="text" class="form-control" placeholder="Please Enter City" name="city" value="{{ isset($social_data->city) ? $social_data->city:'' }}">
                                            </div>
                                        </div><!-- End .form-group  -->
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="dataofbirth">DateOfBirth</label>
                                            <div class="col-lg-9">
                                                <input readonly type="text" class="form-control" placeholder="Please Enter Date of birth" name="dob"  value="{{ isset($social_data->dob) ? date('m/d/Y', strtotime($social_data->dob)):'' }}" id="example1">
                                            </div>
                                        </div><!-- End .form-group  -->
                                            
                                   <?php $gender=""; ?>

                                        @if(isset($social_data->gender))
                                        <?php $gender = $social_data->gender; ?>
                                        @endif
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="gender">Gender:</label>
                                            <div class="col-lg-9">
                                                <select name="gender" class="form-control">
                                                   <option value="">Gender</option>
                                                   <option value="M" {{ ($social_data->gender=='M') ? 'selected="selected"':'' }}>Male</option>
                                                   <option value="F" {{ ($social_data->gender=='F') ? 'selected="selected"':'' }}>Female</option>
                                                </select>
                                            </div>
                                        </div><!-- End .form-group  -->
                                        
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="email">Email:</label>
                                            <div class="col-lg-9">
                                                <input type="text" class="form-control tip"  name="email" value="{{ isset($social_data->email) ? $social_data->email:'' }}">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                             <input type="hidden" name="user_id" value="{{ isset($social_data->id) ? $social_data->id:'' }}">
                                            </div>
                                        </div><!-- End .form-group  -->
                                        

                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="Update" value="Store">Save</button>
                                                  <a href = "{{ URL::to('admin/dashboard') }}" class = 'btn btn-warning'>Cancel</a>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->

                    </div><!-- End .row -->  
                @endforeach   

                
           
       
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
    
    <script src="{{'js/bootstrap-datepicker.js'}}"></script>
    <script type="text/javascript">
    $(document).ready(function(){ 
           $("#userForm").validate({
                rules: {
                    name: {
                        required: true,
                        //minlength: 4
                    },
                   city:
                        {
                         required: true,
                        // minlength: 4
                        },
                   dob:
                        {
                         required: true,
                       //  minlength: 4
                        },
                  email:
                        {
                         required: true,
                        // minlength: 4
                        }
                 
                },
                messages: {
                    name: {
                        required: "Enter Username",
                       // minlength: "User is bigger"
                    },
                   city: {
                        required: "Enter City",
                      // minlength: "City is bigger"
                         },
                   dob:
                        {
                        required: "Enter Date Of Birth",
                      //  minlength: "Date Of Birth is bigger" 
                        },
                  email:
                        {
                        required: "Enter Email Address",
                       // minlength: "Date Of Birth is bigger" 
                        }
                 
                }   
            }); 
             
                 var date = new Date();
var currentMonth = date.getMonth();
var currentDate = date.getDate();
var currentYear = date.getFullYear();
$('#example1').datepicker({
    format: "dd/mm/yyyy",
maxDate: new Date(currentYear, currentMonth, currentDate-1)
});
    });
    </script>
 
    @endsection