@extends('admin')
   
@section('css')
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">

 <link rel="stylesheet" type="text/css" href="{{ asset('css/easyui.css')}}">
	        <script type="text/javascript" src="{{ asset('js/jquery.min.js')}}"></script>
	<script type="text/javascript" src="{{ asset('js/jquery.easyui.min.js')}}"></script>

@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>My Category</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
                
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                 </button>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif   

                <div class="row">  <!--user form start-->
               <div class="col-md-6 col-md-offset-3">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Skills</span>
                                    </h4>
                                </div>
                                <div class="panel-body easyui-tabs">
                                  <div title="Skills" style="padding:10px" class="col-md-6"> 
                                    <form class="form-horizontal" id="userForm1" name="signup" role="form" method="post">
                                      
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="type">Skill Type:</label>
                                            <div class="col-lg-9">
                                                <select name="type" class="form-control" id="type">
                                             <option value="">Type</option>
                                             <option value="T">Talent</option>
                                             <option value="O">Organization</option>
                                         </select>
                                              <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            </div>
                                        </div><!-- End .form-group  -->
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="skill">Skill:</label>
                                            <div class="col-lg-9">
                                                 <input type="text" class="form-control" placeholder="Enter Skill" name="name">
                                            </div>
                                        </div><!-- End .form-group  -->
                                       
                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary btn-primary" name="skill1" value="add1">Save</button>
                                                <button type="reset" class="btn btn-reset">reset</button>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                  </div>
                                    <div title="Subskills" style="padding:10px" class="col-md-6">
                                        <form class="form-horizontal" id="userForm2" name="signup" role="form" method="post">
                                      
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="primary skill">Primary Skills:</label>
                                            <div class="col-lg-9">
                                                <select name="main_skill" class="form-control" id="main_skill">
                                          <option value="">Parent Skills</option>
                                          @foreach($skill_info as $social_data)
                                           <option value="{{ $social_data->id }}">{{$social_data->name}}</option>
                                          @endforeach
                                         </select>

                                         <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            
                                            </div>
                                        </div><!-- End .form-group  -->
                                        
                                          <div class="form-group">
                                            <label class="col-lg-3 control-label" for="city">Skill Type:</label>
                                            <div class="col-lg-9">
                                                <select name="type" class="form-control" id="type">
                                             <option value="">Type</option>
                                             <option value="T">Talent</option>
                                             <option value="O">Organization</option>
                                         </select>
                                             
                                            </div>
                                        </div><!-- End .form-group  -->
                                        
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="dataofbirth">Skill:</label>
                                            <div class="col-lg-9">
                                                 <input type="text" class="form-control" placeholder="Enter Skill" name="name">
                                            </div>
                                        </div><!-- End .form-group  -->
                                       
                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="skill2" value="add2">Save</button>
                                                <button type="reset" class="btn btn-reset">reset</button>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                    </div>
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->  
           
                </div>
                
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   <script type="text/javascript">
    $(document).ready(function(){ 
           $("#userForm1").validate({
                rules: {
                  
                   type:
                        {
                        //  required: true,
                        // minlength: 4
                        },
                   name:
                        {
                         required: true,
                       //  minlength: 4
                        },
                 
                 
                },
                messages: {
                  
                   type: {
                       // required: "Choose Type",
                      // minlength: "City is bigger"
                         },
                   name:
                        {
                        required: "Enter Skill",
                      //  minlength: "Date Of Birth is bigger" 
                        },
                  
                }   
            }); 
            

            $("#userForm2").validate({
                rules: {
                    main_skill: {
                        //required: true,
                        //minlength: 4
                    },
                   type:
                        {
                        // required: true,
                        // minlength: 4
                        },
                   name:
                        {
                         required: true,
                       //  minlength: 4
                        },
                 
                 
                },
                messages: {
                    main_skill: {
                        required: "Choose Primary Skill",
                       // minlength: "User is bigger"
                    },
                   type: {
                        required: "Choose Type",
                      // minlength: "City is bigger"
                         },
                   name:
                        {
                        required: "Enter Skill",
                      //  minlength: "Date Of Birth is bigger" 
                        },
                  
                }   
            }); 
    });
    </script>

   
    @endsection