@extends('admin')
   
@section('css')
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
<link href="{{ asset('css/datepicker.css')}}" rel="stylesheet">
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>Legal Links</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
                  
                <div class="row">
                       
                        <div class="col-md-10">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Legal Links</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="pageEditForm" role="form" method="post" id="pageEditForm">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="fullname">Title:</label>
                                            <div class="col-lg-9">
                                                <div class="input-group">
                                                    <span class="input-group-addon">{{url('')}}/</span>
                                                    <input type="text" class="form-control uniform-input text" name="title" id="page_name" value="">
                                                </div>
                                            </div>
                                        </div><!-- End .form-group  -->
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="city">Subject:</label>
                                            <div class="col-lg-9">
                                                <input type="text" class="form-control" placeholder="Title" name="subject" value="">
                                            </div>
                                        </div><!-- End .form-group  -->
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="dataofbirth">Description:</label>
                                            <div class="col-lg-9">
                                               <textarea class="tinymce" name="content"></textarea> 
                                            </div>
                                        </div><!-- End .form-group  -->
                                        
                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="legal" value="Insert">Save</button>
                                              <a href = "{{ URL::to('admin/legal') }}" class = 'btn btn-warning'>Cancel</a>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->

                    </div><!-- End .row -->  
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   <script src="{{'js/bootstrap-datepicker.js'}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/forms/tiny_mce/tinymce.min.js')}}"></script>
   <script type="text/javascript">
    $(document).ready(function(){ 
           $("#pageEditForm").validate({
                rules: {
                  title:
                        {
                         required: true,
                        // minlength: 4
                        },
                   subject: {
                        required: true,
                        //minlength: 4
                    },
                  description:
                        {
                         required: true,
                        // minlength: 4
                        }
                 
                },
                messages: {
                    title: {
                        required: "Title Required",
                       // minlength: "User is bigger"
                    },
                   subject: {
                        required: "Subject Required",
                      // minlength: "City is bigger"
                         },
                   description:
                        {
                        required: "Description Required",
                      //  minlength: "Date Of Birth is bigger" 
                        },
                }   
            });


      /* Tinymce Editor*/
        tinymce.init({
            selector: "textarea.tinymce",
        language:"en",
            resize: false,
            menubar:false,
            plugins: [
                "advlist autolink lists link image charmap print preview anchor",
                "searchreplace visualblocks code fullscreen",
                "insertdatetime media table contextmenu paste textcolor"
            
            ],
            toolbar: " code | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | forecolor | backcolor | image"
        });
      /* END Tinymce Editor*/
    });
    </script>
 
    @endsection