@extends('admin')
   
@section('css')
 <link href="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.css')}}" type="text/css" rel="stylesheet" />
    <link href="{{ asset('admin/plugins/tables/dataTables/TableTools.css')}}" type="text/css" rel="stylesheet" />
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"> <h3>My Industry</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger ">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success ">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
                <div class="row">
               <div class="col-md-6">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>New Industry Form</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="signup"   method="post" id="userForm">
                                      <div class="form-group">
                                            <label class="col-lg-3 control-label" for="Industry">Industry:</label>
                                            <div class="col-lg-9">
                                              
                                                 <?php  if(!empty($user_info)){?>
                                    
                                   @foreach($user_info as $social_data) 
                                    <input type="text" class="form-control" placeholder="Industry" name="name" value="{{ isset($social_data->name) ? $social_data->name:'' }}">
                                    <input type="hidden" name="role_id" value="{{ isset($social_data->id) ? $social_data->id:'' }}">
                                         @endforeach 
                                                 <?php }else {?>
                                                <input type="text" class="form-control" placeholder="Please Enter Industry" name="name" value="">
                                                 <?php }?>
                                                 <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                
                                            </div>
                                        </div><!-- End .form-group  -->

                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                               <?php  if(!empty($user_info)){?>
                                                 <button type="submit" class="btn btn-primary" name="Update" value="Store">Update</button>
                                                   <a href = "{{ URL::to('admin/industry') }}" class = 'btn btn-warning'>Cancel</a>
                                                 <?php }else {?>
                                                   <button type="submit" class="btn btn-primary" name="Insert" value="Store">Save</button>
                                                          <button type="reset" class="btn btn-reset">Reset</button>
                                                 <?php }?>
                                         
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->
              
     <div class="col-md-6">
                            <div class="panel panel-default gradient">
                                <div class="panel-heading">
                                    <h4>
                                        <span>Industry List</span>
                                    </h4>
                                </div>
                                <div class="panel-body noPad clearfix">
                                    <table cellpadding="0" cellspacing="0" border="0" class="tableTools display table table-bordered" width="100%">
                                        <thead>
                                           <tr>
                                               <th>S.No</th>
                                               <th>Name</th>
						<th>Actions</th>
					</tr>
                                        </thead>
                                        <tbody>
                                            @if($data->count() > 0)
                                             {{--*/ $i = 1 /*--}}
                                            @foreach($data as $pic)
                                             <tr>
                                              <td>{{$i}}</td>
                                             <td>{{$pic->name}}</td>
                                              <td><a href="<?php echo URL::to('/admin/industry_edit/'.$pic->id.''); ?>" title="Edit"><span><i class="icon-edit"></i></span></a>
                                                 <a  href="javascript:void(0)" data-id="{{$pic->id}}"  class="chk_del" title="Delete"><i class="icon-remove-sign"></i></a>
                                               </td>
                                            </tr>
                                             {{--*/ $i++ /*--}}
                                             @endforeach 

                                        @endif
					
                                        </tbody>
                                       
                                    </table>
                                </div>

                            </div><!-- End .panel -->

                        </div>
        
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   

    <script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
    <script src="{{ asset('js/bootbox.js')}}"></script>
    
    
    <script type="text/javascript" language="javascript">


$(document).ready(function() {

//for delete users

        $(document).on('click','.chk_del',function()
        {
          var pic_id = $(this).attr("data-id");
          bootbox.confirm("Are you sure, you want to delete Industry?", function(result)
          {
            if(result)location.href = '{{url("admin/industry/")}}/'+pic_id+"/delete";
          });  
        });
 //end of delete users
 
 
           $("#userForm").validate({
                rules: {
                    name: {
                        required: true,
                        //minlength: 4
                    },
                 
                },
                messages: {
                    name: {
                        required: "Enter Industry",
                       // minlength: "User is bigger"
                    },
                   
                }   
            }); 
    });
 
 
 
        </script>
      <script type="text/javascript" src="{{ asset('admin/plugins/misc/nicescroll/jquery.nicescroll.min.js')}}"></script>
 
    <!-- Table plugins -->
    <script type="text/javascript" src="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.min.js')}}"></script>

    <script type="text/javascript" src="{{ asset('admin/plugins/tables/responsive-tables/responsive-tables.js')}}"></script><!-- Make tables responsive -->

    <!-- Init plugins -->
   
    <script type="text/javascript" src="{{ asset('admin/js/datatable.js')}}"></script><!-- Init plugins only for page -->
   
    @endsection