@extends('admin')
   
@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>My Growth Per Year</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
               <div class="row">
               <div class="col-md-6">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Growth Rate</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="signup"   method="post">
                                      <div class="form-group">
                                            <label class="col-lg-3 control-label" for="normalInput">Percentage(%):</label>
                                            <div class="col-lg-9">
                                                 @if($data->count() > 0)
                                            @foreach($data as $pic)
                                            <input type="text" class="form-control" placeholder="Please Enter Growth" name="name" value="{{$pic->percentage}}" id="growth">
                            <input type="hidden" name="per_id" value="{{$pic->id}}">
                                         @endforeach 

                                        @endif
                                                
                                                 <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            </div>
                                        </div><!-- End .form-group  -->

                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="Insert" value="Store">Save</button>
                                                <button type="reset" class="btn btn-reset">Reset</button>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div>
                
                
               
 
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   
 
    <script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
    <script src="{{ asset('js/validation.js')}}"></script>
    
    <script type="text/javascript">
        $(document).ready(function() {
    $("#growth").keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
             // Allow: Ctrl+A, Command+A
            (e.keyCode == 65 && ( e.ctrlKey === true || e.metaKey === true ) ) || 
             // Allow: home, end, left, right, down, up
            (e.keyCode >= 35 && e.keyCode <= 40)) {
                 // let it happen, don't do anything
                 return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });
});
    </script>
   
    @endsection