@extends('admin')
   
@section('css')
<style>
    .org_enq {
        width: 200px;
        height: 41px;
    }
</style>
    <link href="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.css')}}" type="text/css" rel="stylesheet" />
    <link href="{{ asset('admin/plugins/tables/dataTables/TableTools.css')}}" type="text/css" rel="stylesheet" />
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"> <h3>My Funding Business</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
             
   <div class="row">
                         
   
                <div class="col-lg-12">
                      
                            <div class="panel panel-default gradient">
                                <div class="panel-heading">
                                    <h4>
                                        <span>Organization List</span>
                                    </h4>
                                </div>
                                <div class="panel-body noPad clearfix">
                                    <table cellpadding="0" cellspacing="0" border="0" class="tableTools display table table-bordered" width="100%">
                                        <thead>
                                           <tr> 
                                                <th>S.No</th>
						<th>Organization Name</th>
                                                <th>Organization Type</th>
                                                <th>Enquiry</th>
                                                <!--   <th>Status</th>-->
                                                <th>Action</th>
					 </tr>
                                        </thead>
                                        <tbody>
                                           @if($fund->count() > 0)
                                            {{--*/ $i = 1 /*--}}
                                            @foreach($fund as $pic)
                                             <tr>
                                             <td>{{$i}}</td>
                                             <td>{{$pic->name}}</td>
                                             <td>{{$pic->status_business}}</td>
                                             <td>
                                                 <form method="post" action="fundenquiry"><input type="hidden" name="p_id" id="p_id" value="{{$pic->id }}"><input type="hidden" name="_token" value="{{ csrf_token() }}"> <textarea id="org_enq" name="org_enq" class="org_enq"></textarea>&nbsp;<button type="submit" class="btn btn-primary" value="Send">Send</button>
                                                 </form></td>
                                             <!--<td>@if($pic->is_approve=='YES'){{"Approved"}}@else{{"Pending"}}@endif</td>-->
                                             <td>@if($pic->is_approve=='NO')<a  class="btn btn-primary btn-xs" href="{{url("admin/fund_approve/".$pic->id."/approve")}}">Pending</a>@else  <a  class="btn btn-success btn-xs" href="{{url("admin/fund_approve/".$pic->id."/pending")}}" style="cursor:default">Approved</a> @endif</td>
                                            </tr>
                                              {{--*/ $i++ /*--}}
                                             @endforeach 

                                        @endif
					
                                        </tbody>
                                       
                                    </table>
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span12 -->

        
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
   
  <script src="{{ asset('plugins/datatables/js/jquery.dataTables.js')}}"></script>
    <script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
    <script src="{{ asset('js/bootbox.js')}}"></script>

    
    <script type="text/javascript" language="javascript">


$(document).ready(function() {
	$('#userinfo').dataTable();
 
        
 } );
        </script>
      
   <script type="text/javascript" src="{{ asset('admin/plugins/misc/nicescroll/jquery.nicescroll.min.js')}}"></script>
 
    <!-- Table plugins -->
    <script type="text/javascript" src="{{ asset('admin/plugins/tables/dataTables/jquery.dataTables.min.js')}}"></script>
   
   
    <script type="text/javascript" src="{{ asset('admin/plugins/tables/responsive-tables/responsive-tables1.js')}}"></script><!-- Make tables responsive -->

    <!-- Init plugins -->
   
    <script type="text/javascript" src="{{ asset('admin/js/datatable.js')}}"></script><!-- Init plugins only for page -->
   
    @endsection