@extends('admin')
   
@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
   
    @include('admin_header')
    
    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>My Dashboard</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
        
            <div class="row">           

            <div class="col-lg-8">
              <div class="panel panel-default chart gradient">
                <div class="panel-heading">
                    <h4>
                      <span class="icon16 icomoon-icon-bars"></span>
                      <span>Users Chart</span>
                    </h4>
                    <a href="#" class="minimize">Minimize</a>
                </div>
                <div class="panel-body" style="padding-bottom:0;">
                   <div class="visitors-chart" style="height: 230px;width:100%;margin-top:15px; margin-bottom:15px;"></div>
                   <ul class="chartShortcuts">
                        <li>
                            <a href="#">
                                <span class="head">Total Users</span>
                                <span class="number">{{$total_users}}</span>
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <span class="head">Talents</span>
                                <span class="number">{{$total_talents}}</span>
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <span class="head">Organizations</span>
                                <span class="number">{{$total_orgs}}</span>
                            </a>
                        </li>
                    </ul>
                   
                </div>

              </div><!-- End .panel -->
            </div>
            <div class="col-lg-4">
              <div class="panel panel-default gradient">

                  <div class="panel-heading">
                      <h4>
                          <span class="icon16 icomoon-icon-pie"></span>
                          <span>Organization overview</span>
                      </h4>
                      <a href="#" class="minimize">Minimize</a>
                  </div>
                  <div class="panel-body">
                     <div class="pieStats" style="height: 240px; width:100%;">

                      </div>
                  </div>

              </div><!-- End .panel -->
 
              <div class="sparkStats">
                  <h4>{{$this_month_users}} users this month <a href="#" class="icon tip" title="Configure"><span class="icon16 icomoon-icon-cog-2"></span></a></h4>
                  <ul class="list-unstyled">
                      <li><span class="sparkLine1 "></span> Users: <span class="number">{{$total_users}}</span></li>
                      <li>
                          <span class="sparkLine2"></span>
                          This month: 
                          <span class="number">{{$this_month_users}}</span>
                      </li>
                  </ul>
              </div><!-- End .sparkStats -->

              <div class="clearfix"></div>
     
            </div>    

            </div>     
                
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')

    <script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
    <script src="{{ asset('js/bootbox.js')}}"></script>
    <script src="{{ asset('js/validation.js')}}"></script>
    
   
      
        
    <!-- Charts plugins -->
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.time.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.axislabels.js')}}"></script>    
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.grow.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.pie.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.resize.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.tooltip_0.4.4.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/flot/jquery.flot.orderBars.js')}}"></script>
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/sparkline/jquery.sparkline.min.js')}}"></script><!-- Sparkline plugin -->
    <script type="text/javascript" src="{{ asset('admin/plugins/charts/knob/jquery.knob.js')}}"></script><!-- Circular sliders and stats -->    
    
   
    <script type="text/javascript">
    function gd(year, month, day) {
        return new Date(year, month - 1, day).getTime();
    }

    // document ready function
    $(document).ready(function() {
      
      //profile month wise data
      var mt_data = '[';
      @foreach ($monthly_talents as $prof_data)
        mt_data += '[gd( {{$prof_data->y }}, {{ $prof_data->m }}, 1 ), {{ $prof_data->total_profiles }}],';
      @endforeach
      mt_data += ']';

      var mo_data = '[';
      @foreach ($monthly_orgs as $prof_data)
        mo_data += '[gd( {{$prof_data->y }}, {{ $prof_data->m }}, 1 ), {{ $prof_data->total_profiles }}],';
      @endforeach
      mo_data += ']';

      //Users month wise data
      var u_mw_data = '[';
      @foreach ($users_monthwise as $u_data)
        u_mw_data += '[gd( {{$u_data->y }}, {{ $u_data->m }}, 1 ), {{$u_data->total_users}} ],';
      @endforeach
      u_mw_data += ']';


      var divElement = $('div'); //log all div elements

      //------------- Visitor chart -------------//
      if (divElement.hasClass('visitors-chart')) {

        var d1 = eval('(' + mt_data + ')');
        var d2 = eval('(' + mo_data + ')');
        var d3 = eval('(' + u_mw_data + ')');

        //define placeholder class
        var placeholder = $(".visitors-chart");
        //graph options
        var monthOfYear = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        var options = {
            grid: {
              show: true,
                aboveData: true,
                color: "#3f3f3f" ,
                labelMargin: 5,
                axisMargin: 0, 
                borderWidth: 0,
                borderColor:null,
                minBorderMargin: 5 ,
                clickable: true, 
                hoverable: true,
                autoHighlight: true,
                mouseActiveRadius: 20
            },
            series: {
              grow: {
                active: false,
                stepMode: "linear",
                steps: 50,
                stepDelay: true
              },
                lines: {
                  show: true,
                  fill: true,
                  lineWidth: 4,
                  steps: false
                  },
                points: {
                  show:true,
                  radius: 5,
                  symbol: "circle",
                  fill: true,
                  borderColor: "#fff"
                }
            },
            legend: { 
              position: "ne", 
              margin: [0,-25], 
              noColumns: 0,
              labelBoxBorderColor: null,
              labelFormatter: function(label, series) {
              // just add some space to labes
              return label+'&nbsp;&nbsp;';
           }
          },
          yaxis: { min: 0 },
          //xaxis: {ticks:11, tickDecimals: 0},
          xaxes: [ { 
            mode: "time", 
            tickSize: [1, "month"], 
          }],
          colors: chartColours,
          shadowSize:1,
          tooltip: true, //activate tooltip
          tooltipOpts: {
            content: "%s : %y.0",
            shifts: {
              x: -30,
              y: -50
            }
          }
        };   
      
              $.plot(placeholder, [ 

                { 
                  label: "Users", 
                  data: d3,
                  lines: {fillColor: "#fff8f2", fill: false},
                  points: {fillColor: "#ed7a53"}
                },                
                {
                  label: "Talents", 
                  data: d1,
                  lines: {fillColor: "#f2f7f9", fill: false},
                  points: {fillColor: "#88bbc8"}
                }, 
                { 
                  label: "Organizations", 
                  data: d2,
                  lines: {fillColor: "#fff8f2", fill: false},
                  points: {fillColor: "#ed7a53"}
                } 

              ], options);
              

        }//end if      


        //pie visits graph
        if (divElement.hasClass('pieStats')) {

           var data = [
              { label: "%{{$percent_returning}} Raise Funding Users",  data: {{$percent_returning}}, color: "#88bbc8"},
              { label: "%{{$percent_new}} Funds Businesses Users",  data: {{$percent_new}}, color: "#ed7a53"},
              { label: "%{{$percent_invalid}} Total Organization Users", data: {{$percent_invalid}}, color: "#E3E3E3"}
          ];
          
          $.plot($(".pieStats"), data, 
          {
            series: {
              pie: { 
                show: true,
                highlight: {
                  opacity: 0.1
                },
                stroke: {
                  color: '#fff',
                  width: 3
                },
                startAngle: 2,
                label: {
                  radius:1
                }
              },
              grow: { active: false}
            },
            legend: { 
                  position: "ne", 
                  labelBoxBorderColor: null
              },
            grid: {
                    hoverable: true,
                    clickable: true
                },
                tooltip: true, //activate tooltip
            tooltipOpts: {
              content: "%s : %y.1",
              shifts: {
                x: -30,
                y: -50
              }
            }
          });

        }//end if


      //sparklines (making loop with random data for all 7 sparkline)
      for (i=1; i<3; i++) {
        var data = eval('('+u_mw_data+')');
        placeholder = '.sparkLine' + i;
        $(placeholder).sparkline(data, { 
          width: 100,//Width of the chart - Defaults to 'auto' - May be any valid css width - 1.5em, 20px, etc (using a number without a unit specifier won't do what you want) - This option does nothing for bar and tristate chars (see barWidth)
          height: 30,//Height of the chart - Defaults to 'auto' (line height of the containing tag)
          lineColor: '#88bbc8',//Used by line and discrete charts to specify the colour of the line drawn as a CSS values string
          fillColor: '#f2f7f9',//Specify the colour used to fill the area under the graph as a CSS value. Set to false to disable fill
          spotColor: '#467e8c',//The CSS colour of the final value marker. Set to false or an empty string to hide it
          maxSpotColor: '#9FC569',//The CSS colour of the marker displayed for the maximum value. Set to false or an empty string to hide it
          minSpotColor: '#ED7A53',//The CSS colour of the marker displayed for the mimum value. Set to false or an empty string to hide it
          spotRadius: 3,//Radius of all spot markers, In pixels (default: 1.5) - Integer
          lineWidth: 2//In pixels (default: 1) - Integer
        });
      }

    });//End document ready functions   
    </script>   
    @endsection