@extends('admin')
   
@section('css')
<link href="{{ asset('plugins/datatables/css/jquery.dataTables.css')}}" rel="stylesheet">
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection

@section('content')
   @include('admin_header')

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 minia-icon-list-3"></span></a>
        </div>
        
        <!--Left Sidebar collapse button-->  
        <div class="collapseBtn leftbar">
             <a href="#" class="tipR" title="Hide Left Sidebar"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
       @include('admin_left_menu')
            <div id="content" class="clearfix">
                
            
          <div class="col-md-12">
              <div class="heading"><h3>Change Password</h3></div>
          </div>
                 <div class="col-md-12 reul_msg">
          @if (Session::get('error_msg'))
              <div class="alert alert-danger">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('error_msg')}}
              </div>
          @endif
          @if (Session::get('succ_msg'))
              <div class="alert alert-success">
                 <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                   <span aria-hidden="true">&times;</span>
                 </button>
                  {{Session::get('succ_msg')}}
              </div>
          @endif
          </div>
                
                     @if (count($errors) > 0)
                <div class="alert alert-danger">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                 </button>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif 
          
                  @foreach($user_info as $social_data)
                <div class="row">
                       
                        <div class="col-md-7 col-md-offset-3">

                            <div class="panel panel-default">

                                <div class="panel-heading">
                                    <h4> 
                                        <span>Password Details</span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                   
                                    <form class="form-horizontal" name="signup" role="form" method="post" id="userForm">
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="fullname">Current Password:</label>
                                            <div class="col-lg-9">
                                                <input type="password" class="form-control"  placeholder="Please Enter Current Password" name="cur_pswd" value="">
                                            </div>
                                        </div><!-- End .form-group  -->
                                        <div class="form-group">
                                            <label class="col-lg-3 control-label" for="city">New Password:</label>
                                            <div class="col-lg-9">
                                                <input type="password" class="form-control" placeholder="Please Enter New Password" name="password" value="" id="password">
                                            </div>
                                        </div><!-- End .form-group  -->
                                         <div class="form-group">
                                            <label class="col-lg-3 control-label" for="dataofbirth">Confirm Password:</label>
                                            <div class="col-lg-9">
                                                <input type="password" class="form-control" placeholder="Please Enter Confirm Password" name="password_confirmation" id="dob" value="">
                                                 <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                             <input type="hidden" name="user_id" value="{{ isset($social_data->id) ? $social_data->id:'' }}">
                                            </div>
                                        </div><!-- End .form-group  -->

                                        <div class="form-group">
                                            <div class="col-lg-offset-3 col-lg-9">
                                                <button type="submit" class="btn btn-primary" name="Update" value="Store">Save</button>
                                                <a href = "{{ URL::to('admin/dashboard') }}" class = 'btn btn-warning'>Cancel</a>
                                            </div>
                                        </div><!-- End .form-group  -->                   

                                    </form>
                                 
                                </div>

                            </div><!-- End .panel -->

                        </div><!-- End .span6 -->

                    </div><!-- End .row -->  
                @endforeach   

                
           
       
            </div>
    </div><!-- End #wrapper -->
    @endsection
    @section('js')
    <script type="text/javascript">
    $(document).ready(function(){ 
           $("#userForm").validate({
                rules: {
                    cur_pswd: {
                        required: true,
                        //minlength: 4
                    },
                   password:
                        {
                         required: true,
                         minlength: 6
                        },
                   password_confirmation:
                        {
                         required: true,
                         equalTo : "#password"
                       //  minlength: 6
                        },
         
                },
                messages: {
                    cur_pswd: {
                        required: "Enter Current Password",
                       // minlength: "User is bigger"
                    },
                   password: {
                        required: "Enter New Password",
                        minlength: "Password is Small"
                         },
                   password_confirmation:
                        {
                        required: "Enter Confirm Password",
                       // minlength: "Date Of Birth is bigger" 
                        },
                 
                }   
            }); 
    });
    </script>
 
    @endsection