@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection


@section('content')
<section class="main_content">
    <div class="container">
  <ol class="breadcrumb cust-breadcrumb">
                    <li><a href="{{url('/')}}">Home</a></li>
                    <li><a href="{{url('jobspec/')}}">Job Specification</a></li>
                    <li class="active">Create Job Spec</li>
                   </ol>
                   <div class="row">
                    <div class="col-md-12">
                        @if (Session::get('error_msg'))
                            <div class="alert alert-danger clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('error_msg')}}
                            </div>
                        @endif
                        @if (Session::get('succ_msg'))
                            <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('succ_msg')}}
                            </div>
                        @endif
                        
                          @if ($errors->any())
                              <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                    <ul style="color:red;">

                                    {{ implode('', $errors->all(':message')) }}

                                    </ul>
                              </div>
                         @endif
                    </div>
                </div>
      <div class="row talent_home">
        
        @include("left_menu")
        <div class="col-md-9  col-sm-9 create-job-specific-page"> 
                  <div class="rt-panel-block">  
           <div class="my-profiles-block mbot-20"> 
                <h1 class="heading">Edit Job Spec</h1>
                @if (Session::has('message'))

                <p>{{ Session::get('message') }}</p>

                @endif


                
 

                
                <form method="post"  name="jobspec" id="jobspecification">
                   <!--heading1-->
                   <div class="row talent_data mtop-0 job-specific-form-edit">
                    <div class="col-sm-12 mbot10">
                      <div class="col-sm-12 mbot10"><h2 class="job-specific-head">Basic Information</h2></div>    
                    </div>
                  
                    <!--ending heading1-->
                   
                    <div class="row" id="new_pic">
                        <div class="col-md-12">
                          <div class="form-group">
                             <label class="col-sm-3 control-label">Title :<span class="red-cl">*</span></label>
                             <div class="col-sm-7">
                                 <input type="text" class="form-control" placeholder="Title" name="title" id="title" value="{{$job_spec->title}}">
                             </div> 
                          </div>
                        </div>
                    </div>
                    <div class="row " id="new_pic">
                        <div class="col-md-12">
                          <div class="form-group">
                             <label class="col-sm-3 control-label">Company Name :<span class="red-cl">*</span></label>
                             <div class="col-sm-7">
                                 <input type="text" class="form-control" placeholder="company" name="company_name" id="company_name" value="{{$job_spec->company_name}}">
                             </div> 
                          </div>
                        </div>
                   </div>
                    <div class="row" id="new_pic">
                       <div class="col-md-12">
                         <div class="form-group">
                            <label class="col-sm-3 control-label">Link to Website :<span class="red-cl">*</span></label>
                            <div class="col-sm-7">
                                <input type="text" class="form-control" placeholder="Link to Website" name="link_to_website" id="link_to_website" value="{{$job_spec->link_to_website}}">
                            </div> 
                         </div>
                       </div>
                   </div>
                   <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Apply Website Link :</label>
                         <div class="col-sm-7">
                             <input type="text" class="form-control" placeholder="Apply Website Link" name="website_link" id="website_link" value="{{$job_spec->website_link}}">
                         </div> 
                      </div>
                    </div>
                  </div>
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">INDUSTRY :</label>
                         <div class="col-sm-7">
                              <?php 
                            $industry = explode(",", $job_spec->industry);  ?>
                            @foreach($industry_data as $ind)
                            @if(in_array($ind->id, $industry))<span value="{{$ind->id}}" class="well well-sm">{{$ind->name}}</span>&nbsp;
                            @endif
                            @endforeach
                         </div> 
                      </div>
                    </div>
                 </div>
                   <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Add Industry :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                         
                        <?php
                          // print_r($industry);
                            $option='<option value="" disabled>Add Industry</option>';
                            foreach($industry_data as $ind):
                                if(in_array($ind->id, $industry)) $select = "selected='selected'"; 
                                else $select = " "; 
                              $option .='<option '.$select.' value="'.$ind->id.'">'.$ind->name.'</option>'; 
                            endforeach;
                        ?>
                        <select class="form-control industry" name="industry[]" id="industry" multiple>
                           <?php echo $option; ?>   
                        </select>
                         </div> 
                      </div>
                    </div>
                   </div>
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">FUNCTION : </label>
                         <div class="col-sm-7">
                             <?php 
                            $function = explode(",", $job_spec->function);  ?>
                            @foreach($roles_data as $r)
                            @if(in_array($r->id, $function))<span value="{{$r->id}}" class="well well-sm">{{$r->name}}</span>&nbsp;
                            @endif
                            @endforeach
                         </div> 
                      </div>
                    </div>
                 </div>
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Add Function :</label>
                         <div class="col-sm-7">
                      
                           <?php
                            $option='<option value="">Add Function</option>';
                            foreach($roles_data as $r):
                                if(in_array($r->id, $function)) $select = "selected='selected'"; 
                                else $select = " "; 
                              $option .='<option '.$select.' value="'.$r->id.'">'.$r->name.'</option>'; 
                            endforeach;
                        ?>
                             <select class="form-control function" name="function[]" id="function" multiple>
                           <?php echo $option; ?>   
                        </select>
                         </div> 
                      </div>
                    </div>
                 </div>
                 <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Company description :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="company_desc" style="width:100%">{{$job_spec->company_desc}}</textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                 <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Position description :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="position_desc" style="width:100%">{{$job_spec->position_desc}}</textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                <!--heading2-->
                <div class="row">
                 <div class="col-sm-12 mbot10">
                   <h2 class="job-specific-edit-sub-head">Location</h2>    
                 </div>
                </div>
                <!--ending heading2-->
                
                 <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Country :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                               <select name="country" id="countryId" class="form-control countries">
                                <option value="">Select</option>
                               
                              </select> 
                             <input type="hidden" value="{{$job_spec->country}}" id="country">
                         </div> 
                      </div>
                    </div>
                 </div>
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Province :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                             <input type="text" class="form-control" placeholder="Province" name="province" id="province" value="{{$job_spec->province}}"> 
                         </div> 
                      </div>
                    </div>
               </div>
               <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">State :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                             <select name="state[]"  class="form-control states" id="stateId" multiple>
                                 <option value="" disabled="">Select State</option>
                               
                              </select>
                             <input type="hidden" value="{{$job_spec->state}}" id="state">
                         </div> 
                      </div>
                    </div>
               </div>
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">City :</label>
                         <div class="col-sm-7">
                             <input type="text" class="form-control" placeholder="City" name="city"  value="{{$job_spec->city}}"> 
                         </div> 
                      </div>
                    </div>
               </div>
                
                <!--heading3-->
                <div class="row">
                 <div class="col-sm-12 mbot10">
                   <h2 class="job-specific-edit-sub-head">Compensation</h2>    
                 </div>
                </div>
                <!--ending heading3-->
                
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Base Salary Range :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                             <input type="text" class="form-control" placeholder="Base Salary Range" name="sal_range" id="sal_range" value="{{$job_spec->sal_range}}"> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 col-xs-7 control-label">Hide Salary</label>
                         <div class="col-sm-7 col-xs-5">
                             <div class="search_input cr-job-chek-in"><input type="checkbox" name="hide_sal" value="1" @if ($job_spec->hide_sal == '1'){{'checked="checked"'}}@endif><label></label></div>
                         </div> 
                      </div>
                    </div>
                 </div>
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Additional Elements :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="additional_elements" style="width:100%">{{$job_spec->additional_elements}}</textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                 <!--heading4-->
                <div class="row">
                 <div class="col-sm-12 mbot10">
                   <h2 class="job-specific-edit-sub-head">Preferred Candidate</h2> 
                 </div>
                </div>
                <!--ending heading4-->
                
                  <div class="row job-spec-edit-check-box-block" id="new_pic">
                    <div class="col-md-8">
                      <div class="form-group">
                         <label class="col-sm-12 control-label weight-label">Likely Skill Level<span class="red-cl">*</span></label> 
                      </div>
                    </div>
                     <?php 
                     $array = explode(",", $job_spec->skill_level);   
                  
                     ?>
                  
                 
                      <div class="col-md-12">
                            <div class="form-group col-sm-12">
                               <label class="control-label col-sm-3 col-xs-4">Analyst</label>
                                   <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek"> <input type="checkbox" name="skill_level[]" value="Analyst" {{ (in_array("Analyst", $array)) ? 'checked="checked" ' : '' }}>
                                   <label><a  class="tooltip" title="Analyst"><span class="glyphicon glyphicon-question-sign"></span></a>
                                     </label>
									 </div>
                                   </div>
                            </div>
                            <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Associate</label>
                             <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek">
                                    
                                     <input type="checkbox" name="skill_level[]" value="Associate" {{ (in_array("Associate", $array)) ? 'checked="checked" ' : '' }}>
                                      <label> <a  class="tooltip" title="Associate"><span class="glyphicon glyphicon-question-sign"></span></a>
                                     </label>
									 </div>
                               </div>
                          </div>
                             <div class="clearfix"></div>
                          
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Manager</label>
                              <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek">
                                
                                <input type="checkbox" name="skill_level[]" value="Manager" {{ (in_array("Manager", $array)) ? 'checked="checked" ' : '' }}>
                                <label> <a  class="tooltip" title="Manager"><span class="glyphicon glyphicon-question-sign"></span></a>
                                </label>
								</div>
                               </div>
                          </div>
                        
                          <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Director</label>
                            <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek">
                               
                             <input type="checkbox" name="skill_level[]" value="Director" {{ (in_array("Director", $array)) ? 'checked="checked" ' : '' }}>
                               <label><a  class="tooltip" title="Director"><span class="glyphicon glyphicon-question-sign"></span></a>
                                </label>
								</div>
                             </div>
                          </div>
						  <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Vice President</label>
                            <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek">
                              
                                  <input type="checkbox" name="skill_level[]" value="VicePresident" {{ (in_array("VicePresident", $array)) ? 'checked="checked" ' : '' }}>
                                <label>  <a  class="tooltip" title="VicePresident"><span class="glyphicon glyphicon-question-sign"></span></a>
                               </label>
							   </div>
                             </div> 
                          </div>
						  <div class="clearfix"></div>
                          <div class="vissu form-group col-sm-12">
                           <label class="control-label col-sm-3 col-xs-4">SVP & Above</label>
                              <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek">
                                
                                 <input type="checkbox" name="skill_level[]" value="SVP&Above" {{ (in_array("SVP&Above", $array)) ? 'checked="checked" ' : '' }}>
                                <label><a  class="tooltip" title="SVP&Above"><span class="glyphicon glyphicon-question-sign"></span></a>
                                </label>
								</div>
                             </div> 
                           </div>
                       </div>
                  </div>
                    
                  
                
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Job Type :</label>
                         <div class="col-sm-7">
                             <select name="jobtype" id="jobtype" class="form-control">
                                <option value="">Select</option>
                                <option value="Full Time Position" @if ($job_spec->jobtype == 'Full Time Position'){{"selected='selected'"}}@endif>Full Time Position</option>
                                <option value="Half Time Position" @if ($job_spec->jobtype == 'Half Time Position'){{"selected='selected'"}}@endif>Half Time Position</option>
                                <option value="Permanent" @if ($job_spec->jobtype == 'Permanent'){{"selected='selected'"}}@endif>Permanent</option>
                                <option value="Temporary" @if ($job_spec->jobtype == 'Temporary'){{"selected='selected'"}}@endif>Temporary</option>
                                <option value="Contract" @if ($job_spec->jobtype == 'Contract'){{"selected='selected'"}}@endif>Contract</option>
                              </select> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Experience :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="experience" style="width:100%">{{$job_spec->experience}}</textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                 
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-sm-3 control-label">Qualification :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="qualification" style="width:100%">{{$job_spec->qualification}}</textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                 <!--heading5-->
                <div class="row">
                 <div class="col-sm-12 mbot10">
                  <h2 class="job-specific-edit-sub-head">Contact Info</h2>  
                 </div>
                </div>
                <!--ending heading5-->
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-xs-9 control-label">Keep anonymous</label>
                       <div class="col-sm-2 col-xs-2">
                           <div class="search_input kep-an-chk-box"><input type="checkbox" class="form-control" name="anonymous" id="anonymous" value="1" @if ($job_spec->anonymous == '1'){{'checked="checked"'}}@endif><label></label></div>
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Province :</label>
                       <div class="col-sm-7  form-group">
                           <input type="text" class="form-control" name="contact_province" id="contact_province" value="{{$job_spec->contact_province}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Name :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="username" id="username" value="{{$job_spec->username}}">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Zip :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="zip" id="zip" value="{{$job_spec->zip}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Email :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="email" id="email" value="{{$job_spec->email}}">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Phone Number :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="phone" id="phone" value="{{$job_spec->phone}}">
                       </div>
                    </div>
                  </div>
                 </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Apply to :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="apply" id="apply" value="{{$job_spec->apply}}">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Fax Number :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="fax" id="fax" value="{{$job_spec->fax}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Company Name :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="contact_company" id="contact_company" value="{{$job_spec->contact_company}}">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Comment :</label>
                       <div class="col-sm-7 form-group">
                           <textarea name="comment" class="form-control">{{$job_spec->comment}}</textarea>
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 
                  <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Street :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="street" id="street" value="{{$job_spec->contact_company}}">
                       </div>
                    </div>
                  </div>
                   <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">City :</label>
                       <div class="col-sm-7 form-group">
                            <input type="text" class="form-control" name="contact_city" id="contact_city" value="{{$job_spec->contact_city}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">Country :</label>
                       <div class="col-sm-7 form-group">
                            <select name="contact_country" id="contact_country" class="form-control countries1">
                                <option value="">Select Country</option>
                                
                              </select> 
                            <input type="hidden" value="{{$job_spec->contact_country}}" id="country1">
                       </div>
                    </div>
                  </div>
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5 col-md-5 control-label">State :</label>
                       <div class="col-sm-7 form-group">
                            <select name="contact_state" id="contact_state" class="form-control states1">
                                <option value="">Select State</option>
                               
                              </select> 
                           <input type="hidden" value="{{$job_spec->contact_state}}" id="state1">
                           <input type="hidden" name="_token" value="{{csrf_token()}}">
                           <input type="hidden" name="job_id" value="{{$job_spec->id}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 
                 <div class="col-md-12">
                    <div class="form-group">
                        
                          <div class="job-spec-edit-pg-btns-blk">
                             <button type="submit" class="btn btn-primary1 job-spe-edit-btn" name="signup" value="update" id="job_spec">Update</button>
                            <a href = "{{ URL::to('jobspec') }}" class = 'btn btn-warning job-spe-edit-can-btn'>Cancel</a>
                         </div>
                    </div>
                 </div>
                </div>
         </div>
             </form>   
           </div>
        </div></div></div>
      </div>
    
  </section>
  @endsection
  

@section('js')

<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/location.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/main.js')}}" type="text/javascript"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/forms/tiny_mce/tinymce.min.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function(){ 
      /* Tinymce Editor*/
   
      
        tinymce.init({
            selector: "textarea.tinymce",
            language:"en",
            menu : { // this is the complete default configuration
        file   : {title : 'File'  , items : 'newdocument'},
        edit   : {title : 'Edit'  , items : 'undo redo | cut copy paste pastetext | selectall'},
        insert : {title : 'Insert', items : 'link media | template hr'},
        view   : {title : 'View'  , items : 'visualaid'},
        format : {title : 'Format', items : 'bold italic underline strikethrough superscript subscript | formats | removeformat'},
        table  : {title : 'Table' , items : 'inserttable tableprops deletetable | cell row column'},
        tools  : {title : 'Tools' , items : 'spellchecker code'}
                }
        });
      /* END Tinymce Editor*/
    $('#job_spec').click(function(){
      var checkedNum = $('input[name="skill_level[]"]:checked').length;
        if (!checkedNum) {
         $('.vissu small.help-block').css('display', 'block');
        }
       
      });
      $('input[name="skill_level[]"]').click(function(){
        var checkedNum = $('input[name="skill_level[]"]:checked').length;
        if (checkedNum) {
         $('.vissu small.help-block').css('display', 'none');
        }
        else
        {
        $('.vissu small.help-block').css('display', 'block');  
        }
      });
    });
    </script>

@endsection
