@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection


@section('content')
<section class="main_content">
    <div class="container">
	<ol class="breadcrumb cust-breadcrumb">
                    <li><a href="{{url('/')}}">Home</a></li>
                    <li><a href="{{url('jobspec/')}}">Job Specification</a></li>
                    <li class="active">Create Job Spec</li>
                   </ol>   
                   <div class="row">
                    <div class="col-md-12">
                        @if (Session::get('error_msg'))
                            <div class="alert alert-danger clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('error_msg')}}
                            </div>
                        @endif
                        @if (Session::get('succ_msg'))
                            <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('succ_msg')}}
                            </div>
                        @endif
                        
                          @if ($errors->any())
                              <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                    <ul style="color:red;">

                                    {{ implode('', $errors->all(':message')) }}

                                    </ul>
                              </div>
                         @endif
                    </div>
                </div>  
      <div class="row talent_home">
        
        @include("left_menu")
        <div class="col-md-9 col-sm-9 create-job-specific-page"> 
          <div class="rt-panel-block">  
           <div class="my-profiles-block mbot-20"> 
                <h1 class="heading">Create Job Spec</h1>
                @if (Session::has('message'))

                <p>{{ Session::get('message') }}</p>

                @endif


                
 

                
                <form method="post"  name="jobspec" id="jobspecification">
                   <!--heading1-->
                   <div class="row talent_data mtop-0 job-specific-form-edit ">
                    <div class="col-sm-12">
                      <div class="col-sm-12 mbot10"><h2 class="job-specific-head">Basic Information</h2></div>    
                    </div>
                   
                    <!--ending heading1-->
                   
                    <div class="row" id="new_pic">
                        <div class="col-md-12">
                          <div class="form-group">
                             <label class="col-md-3 col-sm-5 control-label">Title :<span class="red-cl">*</span></label>
                             <div class="col-md-7 col-sm-7">
                              <input type="text" class="form-control" placeholder="Title" name="title" id="title">
                             </div> 
                          </div>
                        </div>
                    </div>
                    <div class="row" id="new_pic">
                        <div class="col-md-12">
                          <div class="form-group">
                             <label class="col-md-3 col-sm-5 control-label">Company Name :<span class="red-cl">*</span></label>
                             <div class="col-sm-7">
                              <input type="text" class="form-control" placeholder="company" name="company_name" id="company_name">
                             </div> 
                          </div>
                        </div>
                   </div>
                    <div class="row " id="new_pic">
                       <div class="col-md-12">
                         <div class="form-group">
                            <label class="col-md-3 col-sm-5 control-label">Link to Website :<span class="red-cl">*</span></label>
                            <div class="col-sm-7">
                             <input type="text" class="form-control" placeholder="Link to Website" name="link_to_website" id="link_to_website">
                            </div> 
                         </div>
                       </div>
                   </div>
                   <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Apply Website Link :</label>
                         <div class="col-sm-7">
                          <input type="text" class="form-control" placeholder="Apply Website Link" name="website_link" id="website_link">
                         </div> 
                      </div>
                    </div>
                  </div>
                 
                   <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Add Industry :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                         
                               <?php
                            $option='<option value="" disabled>Add Industry</option>';
                            foreach($industry_data as $ind):
                              $option .='<option value="'.$ind->id.'">'.$ind->name.'</option>'; 
                            endforeach;
                        ?>
                             <select class="form-control industry" name="industry[]" id="industry" multiple>
                           <?php echo $option; ?>   
                        </select>
                         </div> 
                      </div>
                    </div>
                   </div>
                 
                  <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Add Function :</label>
                         <div class="col-sm-7">
                      
                           <?php
                            $option='<option value="" disabled>Add Function</option>';
                            foreach($roles_data as $r):
                              $option .='<option value="'.$r->id.'">'.$r->name.'</option>'; 
                            endforeach;
                        ?>
                        <select class="form-control function" name="function[]" id="function" multiple>
                           <?php echo $option; ?>   
                        </select>
                         </div> 
                      </div>
                    </div>
                 </div>
                 <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Company description :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="company_desc" style="width:100%"></textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                 <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Position description :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="position_desc" style="width:100%"></textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                <!--heading2-->
                <div class="row">
                 <div class="col-sm-12 ">
                  <h2 class="job-specific-edit-sub-head">Location</h2>  
                 </div>
                </div>
                <!--ending heading2-->
                
                 <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Country :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                               <select name="country" id="countryId" class="form-control countries">
                                <option value="">Select</option>
                               
                              </select> 
                         </div> 
                      </div>
                    </div>
                 </div>
                <div class="row " id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Province :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                               <input type="text" class="form-control" placeholder="Province" name="province" id="province"> 
                         </div> 
                      </div>
                    </div>
               </div>
               <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">State :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                             <select name="state[]"  class="form-control states" id="stateId" multiple>
                                 <option value="" disabled="">Select State</option>
                               
                              </select> 
                         </div> 
                      </div>
                    </div>
               </div>
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">City :</label>
                         <div class="col-sm-7">
                              <input type="text" class="form-control" placeholder="City" name="city" > 
                         </div> 
                      </div>
                    </div>
               </div>
                
                <!--heading3-->
                <div class="row ">
                 <div class="col-sm-12 ">
                   <h2 class="job-specific-edit-sub-head">Compensation</h2>
                 </div>
                </div>
                <!--ending heading3-->
                
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Base Salary Range :<span class="red-cl">*</span></label>
                         <div class="col-sm-7">
                              <input type="text" class="form-control" placeholder="Base Salary Range" name="sal_range" id="sal_range"> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                  <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 col-xs-7 control-label">Hide Salary</label>
                         <div class="col-sm-7 col-xs-5">
                             <div class="search_input cr-job-chek-in"><input type="checkbox" name="hide_sal" value="1" class="Keep-anonymous-radio hide-salraly-check"><label></label></div>
                         </div> 
                      </div>
                    </div>
                 </div>
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Additional Elements :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="additional_elements" style="width:100%"></textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                 <!--heading4-->
                <div class="row">
                 <div class="col-sm-12 ">
                   <h2 class="job-specific-edit-sub-head">Preferred Candidate</h2>   
                 </div>
                </div>
                <!--ending heading4-->
                
                  <div class="row job-specific-radio-btns" id="new_pic">
                    <div class="col-md-8">
                      <div class="form-group">
                         <label class="col-sm-12 control-label">Likely Skill Level<span class="red-cl">*</span></label> 
                      </div>
                    </div>
                      <div class="col-md-12">
                            <div class="form-group col-sm-12">
                               <label class="control-label col-sm-3 col-xs-4">Analyst</label>
                                   <div class="checkbox col-xs-3">
                                    
                                     <div class="search_input preff-can-chek"><input type="checkbox" name="skill_level[]" value="Analyst"><label>
                                     <a  class="tooltip" title="Analyst">  <span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                                 
                                   </div>
                            </div>
                          <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Associate</label>
                              <div class="checkbox col-xs-3">
                                     
                                     <div class="search_input preff-can-chek"> <input type="checkbox" name="skill_level[]" value="Associate">
                                  <label>   <a  class="tooltip" title="Associate"> <span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                                    
                               </div>
                          </div>
                             
                          <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Manager</label>
                               <div class="checkbox col-xs-3">
                                
                               <div class="search_input preff-can-chek"> <input type="checkbox" name="skill_level[]" value="Manager">
                               <label> <a  class="tooltip" title="Manager"> <span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                               
                               </div>
                          </div>
                        
                          <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Director</label>
                            <div class="checkbox col-xs-3">
                              
                             <div class="search_input preff-can-chek"> <input type="checkbox" name="skill_level[]" value="Director">
                            <label>  <a  class="tooltip" title="Director"><span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                              
                             </div>
                          </div>
						  <div class="clearfix"></div>
                          <div class="form-group col-sm-12">
                            <label class="control-label col-sm-3 col-xs-4">Vice President</label>
                            <div class="checkbox col-xs-3">
                              
                               <div class="search_input preff-can-chek">   <input type="checkbox" name="skill_level[]" value="VicePresident">
                                 <label>  <a  class="tooltip" title="VicePresident"><span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                               
                             </div> 
                          </div>
						  <div class="clearfix"></div>
                          <div class="vissu form-group col-sm-12">
                           <label class="control-label col-sm-3 col-xs-4">SVP & Above</label>
                            <div class="checkbox col-xs-3">
                                
                               <div class="search_input preff-can-chek">   <input type="checkbox" name="skill_level[]" value="SVP&Above">
                                <label> <a  class="tooltip" title="SVP&Above"><span class="glyphicon glyphicon-question-sign"></span></a></label></div>
                             
                             </div> 
                           </div>
                       </div>
                  </div>
                    
                  
                
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Job Type :</label>
                         <div class="col-sm-7">
                             <select name="jobtype" id="state" class="form-control">
                                <option value="">Select</option>
                                <option value="Full Time Position">Full Time Position</option>
                                <option value="Half Time Position">Half Time Position</option>
                                <option value="Permanent">Permanent</option>
                                <option value="Temporary">Temporary</option>
                                <option value="Contract">Contract</option>
                              </select> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Experience :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="experience" style="width:100%"></textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                 
                <div class="row" id="new_pic">
                    <div class="col-md-12">
                      <div class="form-group">
                         <label class="col-md-3 col-sm-5 control-label">Qualification :</label>
                         <div class="col-sm-7">
                             <textarea class="tinymce" name="qualification" style="width:100%"></textarea> 
                         </div> 
                      </div>
                    </div>
                 </div>
                
                 <!--heading5-->
                <div class="row">
                 <div class="col-sm-12 ">
                   <h2 class="job-specific-edit-sub-head">Contact Info</h2>
                 </div>
                </div>
                <!--ending heading5-->
				<div class="crt-btm-forms">
                <div class="row ">
                  <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-sm-5  col-xs-9 control-label">Keep anonymous</label>
                       <div class="col-sm-2 col-xs-3">
                           <div class="search_input kep-an-chk-box"><input type="checkbox" class="form-control Keep-anonymous-radio" name="anonymous" id="anonymous" value="1"><label></label></div>
                       </div>
                    </div>
                  </div>
				  <div class="clearfix"></div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Province :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="contact_province" id="contact_province">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Name :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="username" id="username">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Zip :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="zip" id="zip">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Email :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="email" id="email">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Phone Number :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="phone" id="phone">
                       </div>
                    </div>
                  </div>
                 </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Apply to :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="apply" id="apply">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Fax Number :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="fax" id="zip">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Company Name :<span class="red-cl">*</span></label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="contact_company" id="apply">
                       </div>
                    </div>
                  </div>
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Comment :</label>
                       <div class="col-sm-7 form-group">
                           <textarea name="comment" class="form-control"></textarea>
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 
                  <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Street :</label>
                       <div class="col-sm-7 form-group">
                           <input type="text" class="form-control" name="street" id="street">
                       </div>
                    </div>
                  </div>
                   <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">City :</label>
                       <div class="col-sm-7 form-group">
                            <input type="text" class="form-control" name="contact_city" id="contact_city">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">Country :</label>
                       <div class="col-sm-7 form-group">
                            <select name="contact_country" id="contact_country" class="form-control countries1">
                                <option value="">Select Country</option>
                                
                              </select> 
                       </div>
                    </div>
                  </div>
                <div class="col-md-6">
                    <div class="form-group">
                       <label class="col-md-5 col-sm-5 control-label">State :</label>
                       <div class="col-sm-7 form-group">
                            <select name="contact_state" id="contact_state" class="form-control states1">
                                <option value="">Select State</option>
                               
                              </select> 
                           <input type="hidden" name="_token" value="{{csrf_token()}}">
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                 
                 <div class="col-md-12">
                    <div class="form-group">
                         <label class="col-sm-3 control-label"></label>
                         <div class="job-spec-edit-pg-btns-blk">
                             <button type="submit" class="btn btn-primary1 job-spe-edit-btn" name="signup" value="insert" id="job_spec">Submit</button>
                  <a href = "{{ URL::to('jobspec') }}" class = 'btn btn-warning job-spe-edit-can-btn'>Cancel</a>
                         </div>
                    </div>
                 </div>
                </div>
				</div>
             </form> 
           </div>			 
           </div></div></div>
        </div>
      </div>
    
  </section>
  @endsection
  

@section('js')

<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/location.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/validation.js')}}"></script>
<script src="{{ asset('js/main.js')}}" type="text/javascript"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/forms/tiny_mce/tinymce.min.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function(){ 
      /* Tinymce Editor*/
        tinymce.init({
            selector: "textarea.tinymce",
            language:"en",
            menu : { // this is the complete default configuration
        file   : {title : 'File'  , items : 'newdocument'},
        edit   : {title : 'Edit'  , items : 'undo redo | cut copy paste pastetext | selectall'},
        insert : {title : 'Insert', items : 'link media | template hr'},
        view   : {title : 'View'  , items : 'visualaid'},
        format : {title : 'Format', items : 'bold italic underline strikethrough superscript subscript | formats | removeformat'},
        table  : {title : 'Table' , items : 'inserttable tableprops deletetable | cell row column'},
        tools  : {title : 'Tools' , items : 'spellchecker code'}
                }
        });
      /* END Tinymce Editor*/
      $('#job_spec').click(function(){
      var checkedNum = $('input[name="skill_level[]"]:checked').length;
        if (!checkedNum) {
         $('.vissu small.help-block').css('display', 'block');
        }
       
      });
      $('input[name="skill_level[]"]').click(function(){
        var checkedNum = $('input[name="skill_level[]"]:checked').length;
        if (checkedNum) {
         $('.vissu small.help-block').css('display', 'none');
        }
        else
        {
        $('.vissu small.help-block').css('display', 'block');  
        }
      });
    });
    </script>

@endsection
