@extends('main')

@section('css')
<link href="{{ asset('/css/bootstrapValidator.min.css')}}" rel="stylesheet">
@endsection
<!-- hai hello -->
@section('content')
<section class="main_content">
    <div class="container">
    <ol class="breadcrumb cust-breadcrumb">
              <li><a href="{{url('/')}}">Home</a></li>
              <li class="active">Job Specification</li>
            </ol>
            <div class="row">
                    <div class="col-md-12">
                        @if (Session::get('error_msg'))
                            <div class="alert alert-danger clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('error_msg')}}
                            </div>
                        @endif
                        @if (Session::get('succ_msg'))
                            <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                {{Session::get('succ_msg')}}
                            </div>
                        @endif
                        
                          @if ($errors->any())
                              <div class="alert alert-success clearfix">
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                                    <ul style="color:red;">

                                    {{ implode('', $errors->all(':message')) }}

                                    </ul>
                              </div>
                         @endif
                    </div>
                </div>
      <div class="row talent_home">
        @include("left_menu")
        <div class="col-md-9 col-sm-9"> 
             <div class="rt-panel-block">  
           <div class="my-profiles-block"> 
             <h1 class="heading">Job Specification <a href="{{url('jobspec/view/')}}" class="btn btn-history add-new-job-spe">Add New Job Spec</a> </h1>
         
           
            <div class="row" id="mylikes_div">
            
               
             <div class="col-sm-12 findsiz">
              <div class="row">    
               <div class="table-responsive visible-360 job-spec-page-table">
                 
                  <table id="profile" class="table table-bordered zui-table zui-table-rounded job-specific-table" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>Title</th>
                        <th>Company name</th>
                        <th>Link to website </th>
                        <th>Options</th>
                      </tr>
                   </thead>
 
                 <tbody>
                  @if($jobs->count() > 0)
                   @foreach($jobs as $views)
                  <tr>
                  <td>{{$views->title}}</td>
                  <td>{{$views->company_name}}</td>
                  <td>{{$views->link_to_website}}</td>
                  <td><div class="job-spe-btn-blocks"><a href="{{url('jobspec/edit/'.$views->id)}}" class="btn btn-history job-specifi-edit-btn">Edit</a></div><div class="job-spe-btn-blocks"><a href="javascript:void(0)" title="Delete" class="btn btn-danger delete_job job-specifi-remove-btn" data-id="{{$views->id}}">Remove</a></div></td>
               
                 </tr>
                  @endforeach
                   @endif
                </tbody>
               </table>
             </div>
              </div>
            </div>  
             <!-- profile end-->   
              
          </div>
            
        </div></div></div>
      </div>
    </div>
 
    
  </section>
@endsection

@section('js')
<script src="{{ asset('js/bootstrapValidator.min.js')}}"></script>
<script src="{{ asset('js/maskedinput/jquery.maskedinput.min.js')}}"></script>
<script src="{{ asset('js/bootbox.js')}}"></script>
<script src="{{ asset('js/jquery.dataTables.min.js')}}"></script>
<script src="{{ asset('js/dataTables.bootstrap.js')}}"></script>
<script type="text/javascript">

  //history delete functionality
   $(document).on('click','.delete_job',function(){
    var job_id = $(this).attr("data-id");
    bootbox.confirm("Are you sure, you want to delete this?", function(result) {
      if(result)
      location.href = '{{url("jobspec/delete")}}/'+job_id;
    });  
  });
  
  //jquery data table
  $(document).ready(function() {
    $('#profile').DataTable( {
		"language": {
        "emptyTable":     "No messages in Job Specification"
    },
        responsive: true,
        "aLengthMenu": [[3, 6, 9, 12, 15, 25, 50, 75,-1], [3, 6, 9, 12, 15, 25, 50, 75, "All"]],
        "iDisplayLength": 3
    } );

} );

</script>
@endsection
