

/* Talent Profile Datatables Load*/
if($('#users-recruitment-table').length)
{
  $('#users-recruitment-table').DataTable({
	  "language": {
        "emptyTable":     "No recruitment found"
    },
    processing: true,
    serverSide: true,
    ajax: '/recruit/ajax_recruit',
    filter: false,
    columns: [
      {data: 'id', name: 'id', width:'10%'},
      {data: 'sender', name: 'sender', width:'20%', orderable: false, searchable: false},
      {data: 'purpose', name: 'purpose', width:'35%', orderable: false, searchable: false},
      {data: 'title', name: 'title', width:'35%', orderable: false, searchable: false},
      {data: 'action', name: 'action', width:'40%',orderable: false, searchable: false}
    ],
    createdRow: function ( row, data, index ) {
          //$(row).attr('data-id',data['id']);
          $('td',row).attr('data-id',data['id']);
          $(row).addClass('invitation_det');
          //$('td',row).addClass('invitation_det');
          $('td:eq(0),td:eq(1),td:eq(2),td:eq(3)',row).addClass('recruit_view_det');
        },
    "order": [[ 0, "desc" ]]
  });
}

$(document).on("click",".recruit_view_det",function(){
  var recruit_id = $(this).attr('data-id');
  location.href = '/recruit/details/'+recruit_id;
});

$(document).on("click",".delete",function(){
  var recruit_id = $(this).attr('data-id');
  bootbox.confirm("Are you sure, you want to delete Recruit?", function(result) {
    if(result)
    location.href = '/recruit/delete/'+recruit_id;
  });  
});


