
/* User Organiazation Profile Datatables Load*/
if($('#users-invitation-all-table').length)
{
  $('#users-invitation-all-table').DataTable({
	  "language": {
        "emptyTable":     "No inquiries found"
    },
    processing: true,
    serverSide: true,
    ajax: '/inquiry/ajax_inquiries',
    filter: false,
    columns: [
      {data: 'updated_at', name: 'updated_at', width:'10%'},
      {data: 'sender', name: 'sender', width:'20%', orderable: false, searchable: false},
      {data: 'title', name: 'title', width:'40%', orderable: false, searchable: false},
//      {data: 'action', name: 'action', width:'20%', orderable: false, searchable: false}
    ],
    createdRow: function ( row, data, index ) {
          //$(row).attr('data-id',data['id']);
          $('td',row).attr('data-id',data['id']);
          $(row).addClass('invitation_det');
          $('td:eq(0),td:eq(1),td:eq(2)',row).addClass('inquiry_view_det');
        },
    "order": [[ 0, "desc" ]]
  });
}

$(document).on("click",".inquiry_view_det",function(){
  var Inquiry_id = $(this).attr('data-id');
  location.href = '/inquiries/details/'+Inquiry_id;
});

$(document).on("click","#delete_invitation",function(){
  var Invitation_id = $(this).attr('data-id');
  var checked_num = $('input[name="msg_check[]"]:checked').length;
  if(checked_num)
  {
    bootbox.confirm("Are you sure, you want to delete Invitation?", function(result) {
      if(result)
      $('#deleteInvitationForm').submit();
    });  
  }  
  else
  {
    bootbox.alert("Select atleast one Invitation");
  }
});

$(document).on("click",".delete",function(){
  var Invitation_id = $(this).attr('data-id');
  bootbox.confirm("Are you sure, you want to delete Invitation?", function(result) {
    if(result)
    location.href = '/Invitations/delete/'+Invitation_id;
  });  
});

