<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Users_likes extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'users_likes';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['like_user_id','owner_id','likes_id','likes_type','status','created_at','updated_at'];
        
        protected function getMylikes($user_id,$like_type,$take,$skip=0)
        {
                return $result= $this->select('users_likes.id as id','assets_data.thumb_img as thumb_img','assets.processed as processed','assets.id as asst_id','assets.profile_id as profile_id','assets.name as assets_name','assets.asset_type as asset_type','assets_data.path as assets_path')
                                ->leftJoin('assets', 'assets.id', '=', 'users_likes.likes_id')
                                ->leftJoin('assets_data', 'assets_data.asset_id', '=', 'assets.id')
				->where("like_user_id",'=',$user_id)
                              ->where("likes_type",'=',$like_type)
                             ->orderBy('users_likes.id', 'desc')
                              ->skip($skip)
                              ->take($take)->get();
        }

        protected function getvideolikes($like_type,$take,$skip=0)
        {
                return $result= $this->select('users_likes.id as id','profiles.name as pro_name','assets_data.thumb_img as thumb_img','assets.processed as processed','assets.id as asst_id','assets.profile_id as profile_id','assets.name as assets_name','assets.asset_type as asset_type','assets_data.path as assets_path')
                                ->leftJoin('assets', 'assets.id', '=', 'users_likes.likes_id')
                                ->leftJoin('assets_data', 'assets_data.asset_id', '=', 'assets.id')
                                ->leftJoin('profiles', 'assets.profile_id', '=', 'profiles.id')        
                              ->where("likes_type",'=',$like_type)
                              ->where('profiles.profile_type','=','T')
                             ->orderBy('users_likes.id', 'desc')
                              ->skip($skip)
                              ->take($take)->get();
        }
         protected function getvideolikescnt($like_type)
        {
                 $result= $this->select('users_likes.id as id','profiles.name as pro_name','assets_data.thumb_img as thumb_img','assets.processed as processed','assets.id as asst_id','assets.profile_id as profile_id','assets.name as assets_name','assets.asset_type as asset_type','assets_data.path as assets_path')
                                ->leftJoin('assets', 'assets.id', '=', 'users_likes.likes_id')
                                ->leftJoin('assets_data', 'assets_data.asset_id', '=', 'assets.id')
                                ->leftJoin('profiles', 'assets.profile_id', '=', 'profiles.id')        
                              ->where("likes_type",'=',$like_type)
                              ->where('profiles.profile_type','=','T')
                             ->orderBy('users_likes.id', 'desc')->get();
                 return  $result->count();
        }

       protected function getRows($user_id,$likes_type)
        {
           $result= $this->select('assets_data.thumb_img as thumb_img','assets.processed as processed','assets.id as asst_id','assets.profile_id as profile_id','assets.name as assets_name','assets.asset_type as asset_type','assets_data.path as assets_path')
                                ->leftJoin('assets', 'assets.id', '=', 'users_likes.likes_id')
                                ->leftJoin('assets_data', 'assets_data.asset_id', '=', 'assets.id')
				->where("like_user_id",'=',$user_id)->where("likes_type",'=',$likes_type)->orderBy('users_likes.id', 'desc')->get();
             return  $result->count();
        }
       protected function getProlikes($user_id,$like_type,$take,$skip=0)
        {
                return $result= $this->select('users_likes.id as id','profiles.id as asst_id','profiles.name as assets_name','profiles.profile_image as assets_path','profiles.id as profile_id')
                                ->leftJoin('profiles', 'profiles.id', '=', 'users_likes.likes_id')
				->where("like_user_id",'=',$user_id)
                              ->where("likes_type",'=',$like_type)
                             ->orderBy('users_likes.id', 'desc')
                              ->skip($skip)
                              ->take($take)->get();
        }
        
       protected function getProRows($user_id,$likes_type)
        {
           $result= $this->select('users_likes.id as id','profiles.id as asst_id','profiles.name as assets_name','profiles.profile_image as assets_path','profiles.id as profile_id')
                               ->leftJoin('profiles', 'profiles.id', '=', 'users_likes.likes_id')
				->where("like_user_id",'=',$user_id)->where("likes_type",'=',$likes_type)->orderBy('users_likes.id', 'desc')->get();
             return  $result->count();
        }

}

