<?php namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use DB;

class User extends Model implements AuthenticatableContract, CanResetPasswordContract {

	use Authenticatable, CanResetPassword;

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'users';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['username','name','years_in_business','selected_profile','email','password','gender','dob','city','linked_id','fb_id','fb_access_token','profile_completed'];

	/**
	 * The attributes excluded from the model's JSON form.
	 *
	 * @var array
	 */
	protected $hidden = ['password', 'remember_token'];

    protected function getThisMonthUsers()
    {
    	$result = DB::select("SELECT * FROM users WHERE MONTH(created_at) = MONTH(NOW())");
    	return count($result);
    }

    protected function getTotalReturning()
    {
    	$result = DB::select("SELECT * FROM users WHERE DATE(created_at) < DATE(last_login)");
    	return count($result);
    }

    protected function getTotalNewUsers()
    {
    	$result = DB::select("SELECT * FROM users WHERE DATE(created_at) = DATE(last_login)");
    	return count($result);
    }

    protected function getMonthwiseTotal()
    {
    	$result = DB::select("SELECT YEAR(created_at) AS y, MONTH(created_at) AS m, MONTHNAME(created_at) AS m_name, COUNT(DISTINCT id) total_users FROM `users` where user_type!='admin' GROUP BY y, m");
    	return $result;
    }
     protected function getTotalUsers()
    {
    	$result = DB::select("SELECT * FROM users where user_type!='admin'");
    	return count($result);
    }
    protected function getUserinfo($user_id)
    {
           return $result= $this->select('users.id','users.name','users.email','users.gender','users.city','users.dob','users.selected_profile','users.years_in_business','users.profile_completed','users.user_type','users.created_at','users.updated_at','profiles.id as profile_id')
                                ->leftJoin('profiles', 'profiles.user_id', '=', 'users.id')
				->where("users.id",'=',$user_id)->get();  
    }
}
