<?php namespace App\Services;

use Auth;
use App\Profile;
use Session;
use URL;
class ResizeImage {

	public static function resizeImage($image,$width,$height,$scale) {
		$size = getimagesize($image);
		$newImageWidth = ceil($width * $scale);
		$newImageHeight = ceil($height * $scale);
		$newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
		if($size['mime']=="image/jpeg"){
			$source = imagecreatefromjpeg($image);
			imagecopyresampled($newImage,$source,0,0,0,0,$newImageWidth,$newImageHeight,$width,$height);
			imagejpeg($newImage,$image,90);
			chmod($image, 0777);
			return $image;
		} else if($size['mime']=="image/gif"){
			
			$source = imagecreatefromgif($image);
			imagecopyresampled($newImage,$source,0,0,0,0,$newImageWidth,$newImageHeight,$width,$height);
			imagegif($newImage,$image,90);
			chmod($image, 0777);
			return $image;
		}else if($size['mime']=="image/png"){
			
			$source = imagecreatefrompng($image);
			imagecopyresampled($newImage,$source,0,0,0,0,$newImageWidth,$newImageHeight,$width,$height);
			imagepng($newImage,$image,9);
			chmod($image, 0777);
			return $image;
		}
	}

	//You do not need to alter these functions
	public static function imageCrop($filename, $x = 0 , $y = 0, $width = 200, $height = 200){
		$targ_w = $width;
		$targ_h = $height;
		$jpeg_quality = 95;
		
		$src = './uploads/profile_images/'.$filename;
		$dst_r = imagecreatetruecolor( $targ_w, $targ_h );
		//$img_r = imagecreatefromjpeg($src);
		
		if(!$info=getimagesize($src))
          return false;
		switch ($info['mime']) 
        {
            case 'image/jpeg':
                $img_r = imagecreatefromjpeg($src);
                break;
            case 'image/gif':
                $img_r = imagecreatefromgif($src);
                break;
            case 'image/png':
                $img_r = imagecreatefrompng($src);
                break;
			case 'image/x-png':
                $img_r = imagecreatefrompng($src);
                break;
            default:
                return false;
        }
		
		imagecopyresampled($dst_r,$img_r,0,0,$x,$y,$targ_w,$targ_h,$width,$height);
		
		
		 switch ($info['mime'])
        {
            case 'image/jpeg':
				header('Content-type: image/jpeg');
                imagejpeg($dst_r,$src,$jpeg_quality); //100 is the quality settings, values range from 0-100.
				chmod($src, 0777);
                break;
            case 'image/gif':
				header('Content-type: image/gif');
                imagegif($dst_r,$src,$jpeg_quality); //100 is the quality settings, values range from 0-100.
				chmod($src, 0777);
                break;
            case 'image/png':
				//header('Content-type: image/png');
                imagepng($dst_r,$src); //100 is the quality settings, values range from 0-100.
				chmod($src, 0777);
                break;
			case 'image/x-png':
				//header('Content-type: image/png');
                imagepng($dst_r,$src); //100 is the quality settings, values range from 0-100.
				chmod($src, 0777);
                break;
        } 
		//imagedestroy($src);
        //imagedestroy($dst_r);
		
	}

	//to resize images with fixed sizes
	public static function resizeimagefixed($_image_name = "",$_image_path="",$w="",$h=""){
		$image_location= $_image_path."/".$_image_name;
		list($width, $height)= getimagesize($image_location);
		$w=200;
		$h=200;
		if ($height > $h){
			$scale = $h/$height;
			$uploaded = self::resizeImage($image_location,$width,$height,$scale);
		} else {
			$scale = 1;
			$uploaded = self::resizeImage($image_location,$w,$h,$scale);
		}
		
	}
	
}
