<?php namespace App\Services;

use Auth;
use App\Profile;
use Session;
use URL;
use App\MessageUsers;
use App\Connections;
use App\Actions;
use App\Mentor;
use App\MentorUsers;
use App\InvitationUsers;
use App\AssetsShared;
use App\ConnectionUsers;

class CustomLoad {

	public static function AuthProfiles($user_id)
	{
		$result = Profile::where('user_id','=',$user_id)->get();
		if(isset($result[0])):
			if(!Session::get('auth_selected_profile')):
				Session::put('auth_selected_profile',$result[0]->id);
				Session::put('auth_selected_profile_type',$result[0]->profile_type);	
			endif;	
			return $result;
		else:
			return 0;
		endif;		
	}

	public static function SessionProfile()
	{
		/*echo URL::previous();
		exit;*/
		return Session::get('auth_selected_profile');
	}

	public static function InboxCount($user_id)
	{
		$result = MessageUsers::where('profile_id','=',$user_id)->where('is_readed','=','N')->where('folder','=','I')->count();
		return $result;
	}

	public static function InvitationCount($user_id)
	{
		$result = InvitationUsers::where('profile_id','=',$user_id)->where('is_readed','=','N')->where('status','=','1')->count();
		return $result;
	}
	

	public static function ShareCount($profile_id)
	{
		// for profile
		$action_count = Actions::where('profile_id','=',$profile_id)->where('is_readed','=','N')->where('status','=','1')->count();

		//for assets
		$assets_count = AssetsShared::where('to_id','=',Auth::user()->id)->where('is_read', '=', 'N')->count();

		return ($action_count + $assets_count);
	}

    public static function ConnectionCount($userid)
	{
		//$result = Connections::findconnections(Session::get('auth_selected_profile'));
//                    $result = Connections::select('connetions.id')
//                                         ->join('profiles', 'profiles.id', '=', 'connections.receiver_profile_id')
//                                        ->where('status','=','Pending')
//                                        ->where('connections.receiver_profile_id',$userid)->count();
//		return $result;
                $result = ConnectionUsers::where('profile_id','=',$userid)->where('is_read','=','No')->count();
		return $result;
	}
         public static function MentorCount($userid)
	{ 
               /* echo $userid;
                exit;
		*/
               if(empty($userid))
               {
                  return 0;
               }
                $result = MentorUsers::select('id')
                                        /*->where('is_read','=','N')
                                        ->where('sender_profile_id',$userid)
                                        ->orWhere('receiver_profile_id',$userid)*/
                                      // ->whereRaw("is_readed = 'N' AND (profile_id=".$userid.") AND status='0'")
                                        ->whereRaw("is_readed = 'N' AND (profile_id=".$userid.") AND is_readed='N'")
                                        ->count();
		return $result;
	}
}
