<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Search extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'search';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','name','search_terms'];

	protected function getList()
	{
		$result = $this->select('id','profile_id','search_terms')->orderBy('id', 'dessc')->get();
		$result_array = array();
		foreach($result as $res):
			$result_array[$res->id] = array('id'=>$res->id,'profile_id'=>$res->profile_id,'search_data'=>unserialize($res->search_terms));
		endforeach;	

		return $result_array;
	}
        
        protected function getSearchList($pid)
	{
		$result = $this->select('id','name','profile_id','search_terms')->where('profile_id','=',$pid)->orderBy('id', 'dessc')->get();
		$result_array = array();
		foreach($result as $res):
			$result_array[$res->id] = array('id'=>$res->id,'name'=>$res->name,'profile_id'=>$res->profile_id,'search_data'=>unserialize($res->search_terms));
		endforeach;	

		return $result_array;
	}


}
