<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class ProfileLinks extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'profile_links';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','link_type','url'];

	protected function save_update($data,$profile_id)
	{
		foreach($data['link'] as $key=>$value)
		{
			$check = $this->where('link_type','=',$key)->where('profile_id','=',$profile_id)->get();
			if(isset($check[0])):
				$check_find = $this->find($check[0]->id);	
				$check_find->url = $value;
				$check_find->save();
			else:
				$save_data = array();
				$save_data['profile_id'] = $profile_id;
				$save_data['link_type'] = $key;
				$save_data['url'] = $value;
				$save = $this->create($save_data);
			endif;
		}
	}

	protected function getlistByProfile($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)->get();

		$result_array = array();
		foreach($result as $res)
		{
			$result_array[$res->link_type] = $res->url;
		}
		return $result_array;
	}
}
