<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class ProfileCategories extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'profile_categories';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','category_id'];

	protected function getCategoriesByProfileID($profile_id,$cat_array=false)
	{
		$result = $this->select('categories.id','categories.name','categories.ref_cat_id')
				->join('categories', 'profile_categories.category_id', '=', 'categories.id')
				->where('profile_id','=',$profile_id)
				->orderBy('categories.name', 'asc')
				->get();

		if($cat_array==true):
			$return_value=array('parent'=>array(),'child'=>array());
			//$return_value=array();
				foreach($result as $res):
					if($res->ref_cat_id==0)	
						$return_value['parent'][] =$res->id;
					else
						$return_value['child'][$res->ref_cat_id][] = array('id'=>$res->id,'name'=>$res->name);
				endforeach;
		else:
			$return_value='';
				foreach($result as $r):
					if($return_value)
						$return_value=$return_value.', '.$r->name;
					else
						$return_value = $r->name;
				endforeach;		
		endif;	
		return $return_value;
	}


}
