<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Mentor extends Model { 

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'mentor';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['sender_profile_id','receiver_profile_id','subject'];

	protected function create_record($details)
        {
              //print_r($details); exit;
            return $this->create($details);

         }
         
         protected function create_compose($details)
        {
              //print_r($details); exit;
            return $this->create($details);

         }
         
         protected function getrecords($receiver_profile_id)
         {   
             $first = $this->select('sender_profile_id','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('mentor.status','0')
                            //->orWhere('status','Accept')
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.sender_profile_id')->get()->toArray();
             
             $result = $this->select('sender_profile_id','mentor.status','mentor.id','subject','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('mentor.status','1')
                            //->orWhere('status','Accept')
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.sender_profile_id')
                            ->get()->toArray();
             
             $resultnew = $this->select('receiver_profile_id as sender_profile_id','mentor.id','mentor.status','subject','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.receiver_profile_id')
                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('mentor.status','=','1')                            
                            ->where('mentor.sender_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.receiver_profile_id')
                            ->get()->toArray();
             
            
             $result = array_merge($first,$result,$resultnew);
             //print_r($resultnew);exit;
            return $result;
         }
         
          protected function getrecordsActive($receiver_profile_id)
         {   
             $first = $this->select('sender_profile_id','profile_type','receiver_profile_id','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.receiver_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')                            
                            ->where('mentor.status','1')
                            //->orWhere('status','Accept')
                             ->where('mentor.sender_profile_id',$receiver_profile_id)
                            ->where('mentor_users.profile_id',$receiver_profile_id)
                            ->get()->toArray();
             
//             $result = $this->select('sender_profile_id','mentor.status','mentor.id','subject','mentor.created_at','name','profile_image','is_readed')                            
//                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
//                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
//                            ->where('profiles.id', '!=', $receiver_profile_id)
//                            ->where('mentor.status','1')
//                            //->orWhere('status','Accept')
//                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
//                            ->groupBy('mentor.sender_profile_id')
//                            ->get()->toArray();
             
             /*$resultnew = $this->select('receiver_profile_id as sender_profile_id','mentor.id','mentor.status','subject','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.receiver_profile_id')
                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('mentor.status','=','1')                            
                            ->where('mentor.sender_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.receiver_profile_id')
                            ->get()->toArray();*/
             
            
             $result = array_merge($first);
             //print_r($resultnew);exit;
            return $result;
         }
         
          protected function getrecordsInactive($receiver_profile_id)
         {   
             //echo $receiver_profile_id; exit;
              $first = $this->select('sender_profile_id','profile_type','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')                           
                            ->where('mentor.status','1')
                            //->orWhere('status','Accept')
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.sender_profile_id')->get()->toArray();
              
              $second = $this->select('sender_profile_id','profile_type','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')                           
                            ->where('mentor.status','0')
                            //->orWhere('status','Accept')
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.sender_profile_id')->get()->toArray();
             
             //print_r($first); exit;
             
//             $result = $this->select('sender_profile_id','mentor.status','mentor.id','subject','mentor.created_at','name','profile_image','is_readed')                            
//                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
//                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
//                            ->where('profiles.id', '!=', $receiver_profile_id)
//                            ->where('mentor.status','0')
//                            //->orWhere('status','Accept')
//                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
//                            ->groupBy('mentor.sender_profile_id')
//                            ->get()->toArray();
             
             /*$resultnew = $this->select('receiver_profile_id as sender_profile_id','mentor.id','mentor.status','subject','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.receiver_profile_id')
                             ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('mentor.status','=','0')                            
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('mentor.receiver_profile_id')
                            ->get()->toArray();*/
             
            
             $result = array_merge($first,$second);
             //print_r($result);exit;
            return $result;
         }
         protected function getinactivementor($receiver_profile_id)
         {     
             //echo $receiver_profile_id; exit;
              $result = $this->select('sender_profile_id','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.sender_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')                           
                            //->where('mentor.status','0')
                            //->orWhere('status','Accept')
                             ->where('mentor_users.profile_id','=',$receiver_profile_id)
                            ->where('mentor_users.is_readed','=','N')
                            ->where('mentor.receiver_profile_id',$receiver_profile_id)->get()->toArray();
               if(empty($result)):
                       $result = $this->select('sender_profile_id','mentor.status','subject','mentor.id','mentor.created_at','name','profile_image','is_readed')                            
                            ->join('profiles', 'profiles.id', '=', 'mentor.receiver_profile_id')
                            ->join('mentor_users', 'mentor_users.mentor_id', '=', 'mentor.id')                           
                           // ->where('mentor.status','0')
                            //->orWhere('status','Accept')
                           ->where('mentor_users.profile_id','=',$receiver_profile_id)
                            ->where('mentor_users.is_readed','=','N')
                            ->where('mentor.sender_profile_id',$receiver_profile_id)->get()->toArray();
                           
                       endif;
             return $result;
         }
         protected function getfindresult($id,$sessionId)
         {
             $record = $this->select('*')->where('id',$id)->first();
             
            if($record->sender_profile_id == $sessionId)
               $searchid = 'mentor.receiver_profile_id'; 
            else
                $searchid = 'mentor.sender_profile_id'; 
           
             $restult = $this->select('mentor.id','mentor.created_at','mentor.updated_at','sender_profile_id','receiver_profile_id','subject','msg_content','profiles.name','status')
                        ->join('profiles', 'profiles.id', '=', $searchid)
                        ->where('mentor.id',$id)
                        ->first();
              
             return $restult;
         }

}
