<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Location extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'location';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['profile_id','name','number','street','city','country','description','state','zip'];

	protected function getExperienceByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('id', 'desc')
				->get();
		$return_value=array();				
		foreach($result as $r)			
		{
			$from = explode('-',$r->from_date);	
			$to = explode('-',$r->to_date);	
			$return_value[$r->id] = array(
					'id' =>$r->id,
					'loc_name'=>$r->name,
					'loc_number' => $r->number,
					'loc_street' =>$r->street,
					'loc_city' =>$r->city,
					'loc_country' =>$r->country,
					'loc_description' =>$r->description,
					'loc_state' =>$r->state,
					'loc_zip' => $r->zip
				); 
		}	
		return $return_value;
	}

}
