<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Invitations extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'invitations';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['sender_profile_id','receiver_profile_id','title','msg_content','invitation_type','inv_title','company_name','company_url','attachment', 'attachment_name'];

	protected function getinvitation($profile_id,$folder)
	{
		if($folder!='T' && $folder):
			$result = $this->select(['invitation_users.id','permission_type','sender_profile_id','receiver_profile_id','title','invitations.created_at','invitations.updated_at','folder','is_readed','invitations.attachment'])
					->leftjoin('invitation_users','invitation_users.invitation_id','=','invitations.id')
					->where('invitation_users.profile_id','=',$profile_id)
					->where('invitation_users.folder','=',$folder)
					->where('invitation_users.is_deleted','=','N')
					->where('invitation_users.status','=','1');
		elseif($folder=='T'):			
			$result = $this->select(['invitation_users.id','permission_type','sender_profile_id','receiver_profile_id','title','invitations.created_at','invitations.updated_at','folder','is_readed','invitations.attachment'])
					->leftjoin('invitation_users','invitation_users.invitation_id','=','invitations.id')
					->where('invitation_users.profile_id','=',$profile_id)
					->where('invitation_users.is_deleted','=','Y');
		else:
			$result = $this->select(['invitation_users.id','permission_type','sender_profile_id','receiver_profile_id','title','invitations.created_at','invitations.updated_at','folder','is_readed','invitations.attachment'])
					->leftjoin('invitation_users','invitation_users.invitation_id','=','invitations.id')
					->where('invitation_users.profile_id','=',$profile_id)
					->where('invitation_users.is_deleted','=','N')
					->where('invitation_users.status','=','1');
		endif;	
		return $result;
	}

}
