<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use users;
class InvitationUsers extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'invitation_users';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','invitation_id','folder','permission_type','status','is_readed','is_deleted'];

  protected function create_record($profile_id,$invitation_id,$folder='I',$permission_type='N',$is_readed='N',$is_deleted='N')
  {
  	$create = array();
  	$create['profile_id'] = $profile_id;
  	$create['invitation_id'] = $invitation_id;
	$create['folder'] = $folder;
  	$create['permission_type'] = $permission_type;
  	$create['is_readed'] = $is_readed;
  	$create['is_deleted'] = $is_deleted;

  	$save = $this->create($create);
  }	

  protected function permissionProfiles($invitation_id,$permission_type)
  {
  	$result = $this->select(['users.username'])
  					->leftjoin('users','users.id','=','invitation_users.profile_id')
  					->where('invitation_id','=',$invitation_id)
  					->where('permission_type','=',$permission_type)
  					->where('folder','=','I')
  					->get();
  	return $result;				
  }	
}
