<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Inquiry extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'inquiry';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['company','msg_ids','sender_profile_id'];
       
        protected function checkMessage($sender_id)
        {   
              
              if($sender_id)
              $where ="FIND_IN_SET('".$sender_id."',msg_ids)";
              else
              $where = "";
              
            return $result = $this->select(['inquiry.company','inquiry.id','messages.sender_profile_id','inquiry.updated_at'])
                                   ->join('messages', 'messages.sender_profile_id', '=', 'inquiry.sender_profile_id')
                                   ->whereRaw($where)->first();
        }
}
