<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Industry extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'industry';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['name'];

	protected function getListAll()
	{
		$result = $this->select('id','name')->orderBy('name', 'asc')->get();
		return $result;
	}

	protected function getList()
	{
		$result = $this->select('id','name')->orderBy('name', 'asc')->get();
		$result_array = array();
		foreach($result as $res):
			$result_array[$res->id] = $res;
		endforeach;	

		return $result_array;
	}


}
