<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::post('newsignup','UserController@newsignup');
Route::filter('maxUploadFileSize', function()
{
    // Check if upload has exceeded max size limit
    if (! (Request::isMethod('POST') or Request::isMethod('PUT'))) { return; }
    // Get the max upload size (in Mb, so convert it to bytes)
    $maxUploadSize = 1024 * 1024 * ini_get('post_max_size');
    $contentSize = 0;
    if (isset($_SERVER['HTTP_CONTENT_LENGTH']))
    {
        $contentSize = $_SERVER['HTTP_CONTENT_LENGTH'];
    } 
    elseif (isset($_SERVER['CONTENT_LENGTH']))
    {
        $contentSize = $_SERVER['CONTENT_LENGTH'];
    }
    // If content exceeds max size, throw an exception
    if ($contentSize > $maxUploadSize)
    {
        throw new GSVnet\Core\Exceptions\MaxUploadSizeException;
    }
});
Route::get('/', 'HomeController@index');
Route::get('home', 'HomeController@index');

/* Forgot password routes*/
Route::get('user/forgotpwd','UserController@forgotpwd');
Route::post('user/forgotpwd','UserController@forgotmail');
/*End Forgot password routes*/

/* change password routes*/
Route::any('user/changepwd','MyaccountController@pswd_view');
Route::post('user/changepwd','MyaccountController@pswd_update');
/*End change password routes*/

/* change profile routes*/
Route::any('user/account_settings','MyaccountController@profile_view');
Route::post('user/account_settings','MyaccountController@profile_update');
/*End change profile routes*/

/* user login routes*/
Route::get('user/login', 'UserController@getLogin');
Route::post('user/login', 'UserController@postLogin');
    /* User login with linkedin*/
    Route::get('user/login/linkedin','UserController@linkedin');
    /*END User login with linkedin*/

/* END user login routes*/

/* user logout routes*/
Route::get('user/logout', 'UserController@getLogout');
/* END user logout routes*/

/* username and email unique routes*/
Route::any('user/check_username','UserController@check_username');
Route::any('user/check_email','UserController@check_email');
/* end username and email unique routes*/
/*user signup routes*/
Route::any('user/signup','UserController@signup' );

Route::get('user/signup/facebook', function ($facebook = "facebook")
{
    // User denial at the last moment from FB page 
    if (Input::has('error') && Request::input('error_reason') == 'user_denied')
    {
        return Redirect::to('user/signup')->with('error_description', Request::input('error_description'));
        exit;
    }

    // Get the provider instance
    $provider = Socialize::with($facebook);

    // Check, if the user authorised previously.
    // If so, get the User instance with all data,
    // else redirect to the provider auth screen.
    if (Input::has('code'))
    {
        $data = $provider->user();
        return Redirect::to('user/signup')->with('social_data',$data);
        
    } else {
        return $provider->redirect();
    }
});

/*Route::get('user/newsignup', function ($newsignup = "newsignup")
{
    // User denial at the last moment from FB page 
    if (Input::has('error') && Request::input('error_reason') == 'user_denied')
    {
        return Redirect::to('user/signup')->with('error_description', Request::input('error_description'));
        exit;
    }

    print_r($_POST); exit;

    // Check, if the user authorised previously.
    // If so, get the User instance with all data,
    // else redirect to the provider auth screen.
    if (Input::has('code'))
    {
        $data = $provider->user();
        return Redirect::to('user/signup')->with('social_data',$data);
        
    } else {
        return $provider->redirect();
    }
});
*/


/* User Signup with linkedin*/
Route::get('user/signup/linkedin','UserController@linkedin');
/*END User Signup with linkedin*/

/*End user signup routes*/

Route::get('mail','UserController@mail');


/*Route::controllers([
    'user' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);
*/

/* user Profile Routes*/
Route::any('profiles','ProfileController@index');
Route::any('profile/likes','ProfileController@pro_likes');
Route::any('profile/checkbusiness','ProfileController@pro_check');
Route::any('profiles/{id}','ProfileController@talent');
Route::any('profiles/{id}/delete/{type}/{type_id}','ProfileController@talent_about_delete');
Route::any('profiles/{id}/edit/{type}/{type_id}','ProfileController@talent_about_edit');
//Route::any('profile/talent','ProfileController@talent');
Route::any('profile/step1','ProfileController@step1');
Route::any('profile/step1/{profile_id}','ProfileController@editstep1');
Route::any('profile/step2','ProfileController@step2');
Route::any('profile/step2/{profile_id}','ProfileController@editstep2');
Route::any('profile/step3','ProfileController@step3');
Route::post('profile_selected','ProfileController@AuthProfile');
Route::any('profile/do_ajaxupload','ProfileController@do_ajaxupload');
Route::any('profile_permision/{profile_id}','ProfileController@permission');
Route::any('profile_typeahead','ProfileController@typeahead');
//Funding
Route::post('profiles/{id}/funding/{type_id}','ProfileController@funding_save');
//Route::post('profile/pplajaxupload','ProfileController@pplajaxupload');
//Route::delete('profile/pplajaxupload','ProfileController@pplajaxupload');
Route::post('profile/pplajaxupload/{param_name}','ProfileController@pplajaxupload');
Route::delete('profile/pplajaxupload/{param_name}','ProfileController@pplajaxupload');
//Route::any('download/{driver}/{filename}/{orgname}','ProfileController@funding_download');
Route::any('funding_permision/{profile_id}/{funding_id}','ProfileController@funding_permision');
Route::any('funding_assets_permision/{asset_id}','ProfileController@funding_assets_access_update');
Route::any('fb_permision/{profile_id}/{funding_id}','ProfileController@funding_permision'); //fb => funding business
Route::any('fb_assets_permision/{asset_id}','ProfileController@funding_assets_access_update'); //fb => funding business
//Ajax Create Video//
Route::post('profile/ajaxvideo','ProfileController@AjaxCreateVideo');
//Delete assets files for funding
Route::any('funding_docs_delete/{funding_id}/{doc_type}','ProfileController@funding_docs_delete');
Route::any('funding_assets_delete/{funding_business_id}','ProfileController@funding_assets_delete');
Route::any('fb_docs_delete/{funding_id}/{doc_type}','ProfileController@funding_docs_delete'); //fb => funding business
Route::any('fb_assets_delete/{funding_business_id}','ProfileController@funding_assets_delete'); //fb => funding business
/* END user Profile Routes*/

/*Uploading files*/
Route::any('upload','UploadController@index');
Route::any('file_upload','UploadController@upload');
/*EOF uloading files*/
Route::get('send_mail','UserController@send_mail');

/* My profile routes*/
Route::any('myaccount','DashboardController@index');
Route::any('dashboard','DashboardController@index');
/* END My profile routes*/

/* Mylikes rotues*/
Route::any('mylikes','MylikesController@index');
Route::any('mylikes/{likes_type}','MylikesController@showlikes');
Route::any('mylikes/{likes_id}/delete','MylikesController@delete_like');

Route::any('likeslimit','MylikesController@findlimit');
/*End Mylikes toures */

/*Start Histroy*/
Route::any('history','HistoryController@index');//this is for history
Route::any('history_delete/{history_id}','HistoryController@delete');//this is for history

/*end Histroy */

/* My Admin routes*/
Route::group([
 'namespace' => 'Admin',
 'middleware' => 'guest.admin',
], function () {
Route::any('administrator','AdminController@index');


});
Route::post('administrator', 'UserController@postadminlogin');

Route::group(array('prefix' => 'admin'), function()
{
    Route::get('/', 'Admin\AdminController@index');
});

Route::group([
 'namespace' => 'Admin',
 'middleware' => 'admin',
], function () {
    Route::any('admin/fundenquiry','AdminController@fundOrgEnquiry');
 Route::resource('admin/dashboard', 'AdminController@dashboard');
 
 Route::any('admin/users','AdminController@users_view');
Route::any('admin/users/{user_id}/delete','AdminController@user_delete');


Route::get('admin/user_edit/{user_id}', 'AdminController@user_edit');
Route::post('admin/user_edit/{user_id}', 'AdminController@user_update');

Route::any('admin/roles','AdminController@roles_view');
Route::post('admin/roles','AdminController@roles_add');
Route::any('admin/roles/{user_id}/delete','AdminController@roles_delete');

Route::get('admin/role_edit/{role_id}', 'AdminController@role_edit');
Route::post('admin/role_edit/{role_id}', 'AdminController@role_update');

Route::any('admin/industry','AdminController@industry_view');
Route::post('admin/industry','AdminController@industry_add');
Route::any('admin/industry/{indu_id}/delete','AdminController@industry_delete');

Route::get('admin/industry_edit/{indus_id}', 'AdminController@industry_edit');
Route::post('admin/industry_edit/{indus_id}', 'AdminController@industry_update');

//category details
Route::any('admin/category','AdminController@skills_view');
Route::any('admin/category/{skill_id}/delete','AdminController@skill_delete');
Route::get('admin/category_edit/{skill_id}', 'AdminController@skill_edit');
Route::post('admin/category_edit/{skill_id}', 'AdminController@skill_update');
Route::get('admin/new_category', 'AdminController@new_skills');
Route::post('admin/new_category', 'AdminController@skill_add');

//currency details
Route::any('admin/currency','AdminController@currency_view');
Route::any('admin/currency/{cur_id}/delete','AdminController@currency_delete');
Route::post('admin/currency','AdminController@currency_add');

Route::get('admin/currency_edit/{cur_id}', 'AdminController@currency_edit');
Route::post('admin/currency_edit/{cur_id}', 'AdminController@currency_update');

//currency units details
Route::any('admin/currency_units','AdminController@units_view');
Route::any('admin/currency_units/{unit_id}/delete','AdminController@units_delete');
Route::post('admin/currency_units','AdminController@units_add');

Route::get('admin/units_edit/{unit_id}', 'AdminController@units_edit');
Route::post('admin/units_edit/{unit_id}', 'AdminController@units_update');

//Growth per year
Route::any('admin/growth','AdminController@growth_view');
Route::post('admin/growth','AdminController@growth_add');

Route::get('admin/profile', 'AdminController@profile_view');
Route::post('admin/profile', 'AdminController@profile_update');

Route::get('admin/changepwd', 'AdminController@pswd_view');
Route::post('admin/changepwd', 'AdminController@pswd_update');

//Content Pages 
Route::any('admin/pages','AdminController@pages');
Route::any('admin/page_edit/{page_id}','AdminController@page_edit');

//text pages
Route::any('admin/text','AdminController@text');
Route::any('admin/text_edit/{page_id}','AdminController@text_edit');

//contact pages
Route::any('admin/contact', 'AdminController@contact');
Route::any('admin/contact/{cont_id}/delete','AdminController@contact_del');

//legal pages
Route::any('admin/legal', 'AdminController@list_legal');
Route::any('admin/legal/{leg_id}/delete','AdminController@legal_del');
Route::any('admin/legal/{leg_id}/edit', 'AdminController@edit_legal');
Route::any('admin/legal_view', 'AdminController@view_legal');

//funding approval
Route::any('admin/funding', 'AdminController@funding');
Route::any('admin/fund_approve/{pro_id}/{status}','AdminController@fund_approve');

//import contacts
Route::any('admin/importes', 'AdminController@importes');
Route::any('admin/import_status/{imp_id}/{status}','AdminController@import_status');
Route::any('admin/add_contacts', 'AdminController@add_contacts');
Route::any('admin/importes/{imp_id}/delete','AdminController@import_delete');
Route::get('admin/import_edit/{imp_id}', 'AdminController@import_edit');
Route::post('admin/import_edit/{imp_id}', 'AdminController@import_update');

Route::any('admin/subscribers', 'AdminController@subscribers');
Route::get('admin/reply_subscribe/{imp_id}', 'AdminController@reply_subscribe');
Route::post('admin/reply_subscribe/{imp_id}', 'AdminController@send_reply');
Route::post('admin/reply_mail', 'AdminController@send_mail');
Route::get('admin/reply_mail', 'AdminController@reply_mail');

Route::any('admin/subscribe_status/{imp_id}/{status}','AdminController@subscribe_status');
Route::any('admin/remove_subscribe/{imp_id}/delete', 'AdminController@remove_subscribe');


});


/* END My Admin routes*/

/*Videos*/
    Route::any('videos','VideoController@index');
    Route::any('videos/likes','VideoController@vid_likes');
    Route::any('videoProcessedStatus','VideoController@videoProcessedStatus');
    Route::get('vidoes_loadmore','VideoController@loadmore');
    Route::any('videos/{video_id}','VideoController@update_access');
    Route::any('videos_delete/{video_id}','VideoController@delete');
    Route::any('videosearch/','VideoController@videosearch');
    Route::any('video_view','VideoController@add_view');//this is history
/*EOF Videos*/

/* Profie Search routes*/
Route::any('search','SearchController@index');
Route::get('search_ajax','SearchController@ajax');
Route::any('search/history','SearchController@history');
Route::get('search/ajax_history','SearchController@ajax_history');
Route::any('savedsearch','SearchController@savedsearch');
Route::any('deletesearch/{searchid}','SearchController@deletesearch');
Route::any('searchresult/{searchid}','SearchController@searchresult');
/* END Profie Search routes*/

//Route::any('test','VideoController@test');


/*Pictures*/
Route::any('pictures','PicturesController@index');

Route::any('pictures/likes','PicturesController@pic_likes');
Route::any('checklimit','PicturesController@findlimit');

Route::any('datasearch','PicturesController@picturesearch');

Route::any('pictures/{pic_id}','PicturesController@update_access');

Route::any('pictures/{pic_id}/delete','PicturesController@pic_delete');
Route::any('picture_view','PicturesController@add_view');//this is for history
/*End Pictures*/

/*Resumes*/
Route::any('myresume','ResumeController@index');
Route::any('myresume/likes','ResumeController@res_likes');
Route::any('filelimit','ResumeController@findlimit');

Route::any('filesearch','ResumeController@picturesearch');

Route::any('myresume/{pic_id}','ResumeController@update_access');

Route::any('myresume/{pic_id}/delete','ResumeController@pic_delete');

Route::any('res_download/{pic_id}','ResumeController@getDownload');
/*End Resumes*/

/*My Views*/
Route::any('myviews', 'ViewsController@index');
Route::any('myviews/dt_profileviews', 'ViewsController@dt_profileviews');
/*End My Views*/

/* Message routes*/
Route::any('messages','MessageController@inbox');
Route::any('message/inbox','MessageController@inbox');
Route::any('message/sent','MessageController@sent');
Route::any('message/trash','MessageController@trash'); //03062015
Route::any('message/check_username','MessageController@check_username');
Route::post('message/compose','MessageController@compose');
Route::any('message/ajax_messages','MessageController@ajax_messages');
Route::any('username_typeahead','MessageController@typeahead');
Route::any('messages/details/{msg_id}','MessageController@message_details');
Route::any('messages/delete/{msg_id}','MessageController@message_delete');/* End Message routes*/

/* Connection routes */
Route::get('send_connection','SearchController@connection');
Route::get('ajax_connection','SearchController@ajax_connection');
Route::get('ajax_invite','SearchController@ajax_invite');
Route::get('invite_join','SearchController@invite_join');
Route::get('connectedlist','SearchController@connectedlist');
Route::any('connections/details/{msg_id}','SearchController@connect_details');
Route::any('connection/message/','SearchController@message');
Route::any('connections/send_msg','SearchController@msg_details');
Route::get('connectionview','SearchController@connectionview');
Route::get('statuschange','SearchController@statuschange');
Route::get('statusdelete','SearchController@statusdelete');
Route::get('findconnections','SearchController@findconnections');
/* End Connection routes */

/* Download Routes*/
Route::any('download/funding/{funding_id}/{file_type}','DownloadController@funding_download');
Route::any('download/funding_assets/{funding_id}','DownloadController@funding_assets_download');
Route::any('download/fb_assets/{funding_id}','DownloadController@funding_assets_download'); // Funding Business docs Dowmload
Route::any('download/inv_attachment/{inv_id}','DownloadController@inv_attachment_download'); // Invitation attachment Dowmload
/* End Download Routes*/

/*Share Routes*/
Route::any('share','ShareController@index');
Route::post('share/request','ShareController@request');
Route::get('share/ajax_list','ShareController@ajax_list');
Route::get('profiles/{profile_id}/S/{share_id}','ShareController@share_view');
Route::get('day/share_expiry','DayController@ShareFiveDaysExpire'); //cron share profile link expire more than 5days list
Route::post('share/share_asset','ShareController@share_asset');
Route::get('share/assets_ajx_list','ShareController@assets_ajx_list');
Route::any('share/update_count/{asset_id}','ShareController@update_count');
/* End Share Routes*/

/* Mentor Routes */
Route::any('mentor','MentorController@index');
Route::any('mentorview','MentorController@mentorview');
Route::any('mentorview/inboxajax','MentorController@inboxajax');
Route::any('mentorstatus/{status}/{sid}','MentorController@mentorstatus');
Route::any('mentor/details/{msg_id}','MentorController@mentor_details');
Route::any('mentor/compose/','MentorController@compose');
Route::any('mentor/delete/{msg_id}','MentorController@mentor_delete');
/* End Mentor Routes*/

/*Create job specification*/
Route::any('jobspec','JobspecController@index');
Route::any('jobspec/view','JobspecController@view_job');
Route::any('jobspec/edit/{job_id}','JobspecController@edit_job');
Route::any('jobspec/delete/{job_id}','JobspecController@delete_job');
Route::post('jobspec/view','JobspecController@jobspec_add');
Route::post('jobspec/edit/{job_id}','JobspecController@jobspec_add');
Route::post('sendjobspec','JobspecController@sendjobspec');
Route::any('recruit','JobspecController@recruit');
Route::any('recruit/ajax_recruit','JobspecController@ajax_recruit');
Route::any('recruit/details/{job_id}','JobspecController@recruit_details');
Route::any('recruit/delete/{job_id}','JobspecController@recruit_delete');
/*end of job specification*/

/* invitation routes*/
Route::any('invitations','InvitationController@index');
Route::any('invitation/compose','InvitationController@compose');
Route::any('invitation/ajax_invitations','InvitationController@ajax_invitations');
Route::any('invitation_typeahead','InvitationController@typeahead');
Route::any('invitations/details/{inv_id}','InvitationController@invitation_details');
Route::any('invitations/action_update/{inv_id}/{per_type}','InvitationController@invitation_action_update');
Route::post('invitation/reply','InvitationController@invitation_reply');
/* End invitation routes*/

/*Inquiries Routes*/
Route::post('share/inquiries','InquirController@request');
Route::any('Inquiries','InquirController@index');
Route::any('inquiry/ajax_inquiries','InquirController@ajax_inquiries');
Route::any('inquiries/details/{inq_id}','InquirController@inquiry_details');
/* End Inquiries Routes*/
/* for import user contact */
Route::any('getcontacts','SearchController@getContacts');
Route::any('searchcontacts','SearchController@searchContacts');
Route::get('homesearch', 'HomesearchController@index');
Route::get('home_search_ajax','HomesearchController@ajax');
Route::any('searchprofiles/{id}','HomesearchController@talent');
Route::post('subscribe','HomeController@subscribe');
/*end for import user contact for connections*/
/*Content Pages*/
// could be page/{slug} or only slug
Route::get('/{slug}', array('as' => 'page.show', 'uses' => 'PageController@show'));
Route::post('contact', 'ContactController@index');
Route::any('legal/{leg_id}', 'LegalController@index');


/*End Content Pages*/